/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.ParseException;
import android.net.WebAddress;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.android.browser.Bookmarks;
import com.android.browser.BrowserActivity;
import com.android.browser.DownloadTouchIcon;
import com.android.browser.LogTag;
import java.net.URI;
import java.net.URISyntaxException;

public class AddBookmarkPage
extends Activity {
    private final String LOGTAG = "Bookmarks";
    private EditText mTitle;
    private EditText mAddress;
    private TextView mButton;
    private View mCancelButton;
    private boolean mEditingExisting;
    private Bundle mMap;
    private String mTouchIconUrl;
    private Bitmap mThumbnail;
    private String mOriginalUrl;
    private static final int SAVE_BOOKMARK = 100;
    private Handler mHandler;
    private View.OnClickListener mSaveBookmark = new View.OnClickListener(){

        public void onClick(View v) {
            if (AddBookmarkPage.this.save()) {
                AddBookmarkPage.this.finish();
            }
        }
    };
    private View.OnClickListener mCancel = new View.OnClickListener(){

        public void onClick(View v) {
            AddBookmarkPage.this.finish();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.requestWindowFeature(3);
        this.setContentView(2130903044);
        this.setTitle(2131230769);
        this.getWindow().setFeatureDrawableResource(3, 2130837535);
        String title = null;
        String url = null;
        this.mMap = this.getIntent().getExtras();
        if (this.mMap != null) {
            Bundle b = this.mMap.getBundle("bookmark");
            if (b != null) {
                this.mMap = b;
                this.mEditingExisting = true;
                this.setTitle(2131230770);
            }
            title = this.mMap.getString("title");
            url = this.mOriginalUrl = this.mMap.getString("url");
            this.mTouchIconUrl = this.mMap.getString("touch_icon_url");
            this.mThumbnail = (Bitmap)this.mMap.getParcelable("thumbnail");
        }
        this.mTitle = (EditText)this.findViewById(2131492866);
        this.mTitle.setText(title);
        this.mAddress = (EditText)this.findViewById(2131492878);
        this.mAddress.setText((CharSequence)url);
        View.OnClickListener accept = this.mSaveBookmark;
        this.mButton = (TextView)this.findViewById(2131492879);
        this.mButton.setOnClickListener(accept);
        this.mCancelButton = this.findViewById(2131492880);
        this.mCancelButton.setOnClickListener(this.mCancel);
        if (!this.getWindow().getDecorView().isInTouchMode()) {
            this.mButton.requestFocus();
        }
    }

    private void createHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 100: {
                            if (1 == msg.arg1) {
                                Toast.makeText((Context)AddBookmarkPage.this, (int)2131230777, (int)1).show();
                                break;
                            }
                            Toast.makeText((Context)AddBookmarkPage.this, (int)2131230778, (int)1).show();
                        }
                    }
                }
            };
        }
    }

    boolean save() {
        String url;
        String title;
        block11: {
            this.createHandler();
            title = this.mTitle.getText().toString().trim();
            String unfilteredUrl = BrowserActivity.fixUrl(this.mAddress.getText().toString());
            boolean emptyTitle = title.length() == 0;
            boolean emptyUrl = unfilteredUrl.trim().length() == 0;
            Resources r = this.getResources();
            if (emptyTitle || emptyUrl) {
                if (emptyTitle) {
                    this.mTitle.setError(r.getText(2131230780));
                }
                if (emptyUrl) {
                    this.mAddress.setError(r.getText(2131230781));
                }
                return false;
            }
            url = unfilteredUrl.trim();
            try {
                WebAddress address;
                if (url.toLowerCase().startsWith("javascript:")) break block11;
                URI uriObj = new URI(url);
                String scheme = uriObj.getScheme();
                if (Bookmarks.urlHasAcceptableScheme(url)) break block11;
                if (scheme != null) {
                    this.mAddress.setError(r.getText(2131230783));
                    return false;
                }
                try {
                    address = new WebAddress(unfilteredUrl);
                }
                catch (ParseException e) {
                    throw new URISyntaxException("", "");
                }
                if (address.mHost.length() == 0) {
                    throw new URISyntaxException("", "");
                }
                url = address.toString();
            }
            catch (URISyntaxException e) {
                this.mAddress.setError(r.getText(2131230782));
                return false;
            }
        }
        if (this.mEditingExisting) {
            this.mMap.putString("title", title);
            this.mMap.putString("url", url);
            this.mMap.putBoolean("invalidateThumbnail", !url.equals(this.mOriginalUrl));
            this.setResult(-1, new Intent().setAction(this.getIntent().toString()).putExtras(this.mMap));
        } else {
            Bundle bundle = new Bundle();
            bundle.putString("title", title);
            bundle.putString("url", url);
            bundle.putParcelable("thumbnail", (Parcelable)this.mThumbnail);
            bundle.putBoolean("invalidateThumbnail", !url.equals(this.mOriginalUrl));
            bundle.putString("touchIconUrl", this.mTouchIconUrl);
            Message msg = Message.obtain((Handler)this.mHandler, (int)100);
            msg.setData(bundle);
            Thread t = new Thread(new SaveBookmarkRunnable(msg));
            t.start();
            this.setResult(-1);
            LogTag.logBookmarkAdded(url, "bookmarkview");
        }
        return true;
    }

    private class SaveBookmarkRunnable
    implements Runnable {
        private Message mMessage;

        public SaveBookmarkRunnable(Message msg) {
            this.mMessage = msg;
        }

        public void run() {
            Bundle bundle = this.mMessage.getData();
            String title = bundle.getString("title");
            String url = bundle.getString("url");
            boolean invalidateThumbnail = bundle.getBoolean("invalidateThumbnail");
            Bitmap thumbnail = invalidateThumbnail ? null : (Bitmap)bundle.getParcelable("thumbnail");
            String touchIconUrl = bundle.getString("touchIconUrl");
            try {
                ContentResolver cr = AddBookmarkPage.this.getContentResolver();
                Bookmarks.addBookmark(null, cr, url, title, thumbnail, true);
                if (touchIconUrl != null) {
                    new DownloadTouchIcon(cr, url).execute(new String[]{AddBookmarkPage.this.mTouchIconUrl});
                }
                this.mMessage.arg1 = 1;
            }
            catch (IllegalStateException e) {
                this.mMessage.arg1 = 0;
            }
            this.mMessage.sendToTarget();
        }
    }
}

