/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.pbap;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.pim.vcard.VCardComposer;
import android.provider.CallLog;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.util.Log;
import com.android.bluetooth.pbap.BluetoothPbapCallLogComposer;
import com.android.bluetooth.pbap.BluetoothPbapObexServer;
import com.android.bluetooth.pbap.BluetoothPbapService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.obex.Operation;
import javax.obex.ServerOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothPbapVcardManager {
    private static final String TAG = "BluetoothPbapVcardManager";
    private static final boolean V = false;
    private ContentResolver mResolver;
    private Context mContext;
    private StringBuilder mVcardResults = null;
    static final String[] PHONES_PROJECTION = new String[]{"_id", "data2", "data3", "data1", "display_name"};
    private static final int ID_COLUMN_INDEX = 0;
    private static final int PHONE_TYPE_COLUMN_INDEX = 1;
    private static final int PHONE_LABEL_COLUMN_INDEX = 2;
    private static final int PHONE_NUMBER_COLUMN_INDEX = 3;
    private static final int CONTACTS_DISPLAY_NAME_COLUMN_INDEX = 4;
    static final String SORT_ORDER_PHONE_NUMBER = "data1 ASC";
    static final String[] CONTACTS_PROJECTION = new String[]{"_id", "display_name"};
    static final int CONTACTS_ID_COLUMN_INDEX = 0;
    static final int CONTACTS_NAME_COLUMN_INDEX = 1;
    static final String CALLLOG_SORT_ORDER = "_id DESC";
    private static final String CLAUSE_ONLY_VISIBLE = "in_visible_group=1";

    public BluetoothPbapVcardManager(Context context) {
        this.mContext = context;
        this.mResolver = this.mContext.getContentResolver();
    }

    public final String getOwnerPhoneNumberVcard(boolean vcardType21) {
        BluetoothPbapCallLogComposer composer = new BluetoothPbapCallLogComposer(this.mContext, false);
        String name = BluetoothPbapService.getLocalPhoneName();
        String number = BluetoothPbapService.getLocalPhoneNum();
        String vcard = composer.composeVCardForPhoneOwnNumber(2, name, number, vcardType21);
        return vcard;
    }

    public final int getPhonebookSize(int type) {
        int size;
        switch (type) {
            case 1: {
                size = this.getContactsSize();
                break;
            }
            default: {
                size = this.getCallHistorySize(type);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getContactsSize() {
        Uri myUri = ContactsContract.Contacts.CONTENT_URI;
        int size = 0;
        Cursor contactCursor = null;
        try {
            contactCursor = this.mResolver.query(myUri, null, CLAUSE_ONLY_VISIBLE, null, null);
            if (contactCursor != null) {
                size = contactCursor.getCount() + 1;
            }
            Object var5_4 = null;
            if (contactCursor == null) return size;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (contactCursor == null) throw throwable;
            contactCursor.close();
            throw throwable;
        }
        contactCursor.close();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getCallHistorySize(int type) {
        Uri myUri = CallLog.Calls.CONTENT_URI;
        String selection = BluetoothPbapObexServer.createSelectionPara(type);
        int size = 0;
        Cursor callCursor = null;
        try {
            callCursor = this.mResolver.query(myUri, null, selection, null, "date DESC");
            if (callCursor != null) {
                size = callCursor.getCount();
            }
            Object var7_6 = null;
            if (callCursor == null) return size;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (callCursor == null) throw throwable;
            callCursor.close();
            throw throwable;
        }
        callCursor.close();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<String> loadCallHistoryList(int type) {
        Uri myUri = CallLog.Calls.CONTENT_URI;
        String selection = BluetoothPbapObexServer.createSelectionPara(type);
        String[] projection = new String[]{"number", "name"};
        boolean CALLS_NUMBER_COLUMN_INDEX = false;
        boolean CALLS_NAME_COLUMN_INDEX = true;
        Cursor callCursor = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            callCursor = this.mResolver.query(myUri, projection, selection, null, CALLLOG_SORT_ORDER);
            if (callCursor != null) {
                callCursor.moveToFirst();
                while (!callCursor.isAfterLast()) {
                    String name = callCursor.getString(1);
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        name = callCursor.getString(0);
                    }
                    list.add(name);
                    callCursor.moveToNext();
                }
            }
            Object var11_10 = null;
            if (callCursor == null) return list;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (callCursor == null) throw throwable;
            callCursor.close();
            throw throwable;
        }
        callCursor.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<String> getPhonebookNameList(int orderByWhat) {
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(BluetoothPbapService.getLocalPhoneName());
        Uri myUri = ContactsContract.Contacts.CONTENT_URI;
        Cursor contactCursor = null;
        try {
            if (orderByWhat == BluetoothPbapObexServer.ORDER_BY_INDEXED) {
                contactCursor = this.mResolver.query(myUri, CONTACTS_PROJECTION, CLAUSE_ONLY_VISIBLE, null, "_id");
            } else if (orderByWhat == BluetoothPbapObexServer.ORDER_BY_ALPHABETICAL) {
                contactCursor = this.mResolver.query(myUri, CONTACTS_PROJECTION, CLAUSE_ONLY_VISIBLE, null, "display_name");
            }
            if (contactCursor != null) {
                contactCursor.moveToFirst();
                while (!contactCursor.isAfterLast()) {
                    String name = contactCursor.getString(1);
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        name = this.mContext.getString(17039374);
                    }
                    nameList.add(name);
                    contactCursor.moveToNext();
                }
            }
            Object var7_6 = null;
            if (contactCursor == null) return nameList;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (contactCursor == null) throw throwable;
            contactCursor.close();
            throw throwable;
        }
        contactCursor.close();
        return nameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<String> getContactNamesByNumber(String phoneNumber) {
        ArrayList<String> nameList = new ArrayList<String>();
        Cursor contactCursor = null;
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)phoneNumber));
        try {
            contactCursor = this.mResolver.query(uri, CONTACTS_PROJECTION, CLAUSE_ONLY_VISIBLE, null, "_id");
            if (contactCursor != null) {
                contactCursor.moveToFirst();
                while (!contactCursor.isAfterLast()) {
                    String name = contactCursor.getString(1);
                    long id2 = contactCursor.getLong(0);
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        name = this.mContext.getString(17039374);
                    }
                    nameList.add(name);
                    contactCursor.moveToNext();
                }
            }
            Object var9_7 = null;
            if (contactCursor == null) return nameList;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (contactCursor == null) throw throwable;
            contactCursor.close();
            throw throwable;
        }
        contactCursor.close();
        return nameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int composeAndSendCallLogVcards(int type, Operation op, int startPoint, int endPoint, boolean vcardType21) {
        String selection;
        long endPointId;
        long startPointId;
        String typeSelection;
        block7: {
            if (startPoint < 1 || startPoint > endPoint) {
                Log.e((String)TAG, (String)"internal error: startPoint or endPoint is not correct.");
                return 208;
            }
            typeSelection = BluetoothPbapObexServer.createSelectionPara(type);
            Uri myUri = CallLog.Calls.CONTENT_URI;
            String[] CALLLOG_PROJECTION = new String[]{"_id"};
            boolean ID_COLUMN_INDEX = false;
            Cursor callsCursor = null;
            startPointId = 0L;
            endPointId = 0L;
            try {
                callsCursor = this.mResolver.query(myUri, CALLLOG_PROJECTION, typeSelection, null, CALLLOG_SORT_ORDER);
                if (callsCursor != null) {
                    callsCursor.moveToPosition(startPoint - 1);
                    startPointId = callsCursor.getLong(0);
                    if (startPoint == endPoint) {
                        endPointId = startPointId;
                    } else {
                        callsCursor.moveToPosition(endPoint - 1);
                        endPointId = callsCursor.getLong(0);
                    }
                }
                Object var16_13 = null;
                if (callsCursor == null) break block7;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (callsCursor == null) throw throwable;
                callsCursor.close();
                throw throwable;
            }
            callsCursor.close();
        }
        String recordSelection = startPoint == endPoint ? "_id=" + startPointId : "_id>=" + endPointId + " AND " + "_id" + "<=" + startPointId;
        if (typeSelection == null) {
            selection = recordSelection;
            return this.composeAndSendVCards(op, selection, vcardType21, null, false);
        }
        selection = "(" + typeSelection + ") AND (" + recordSelection + ")";
        return this.composeAndSendVCards(op, selection, vcardType21, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int composeAndSendPhonebookVcards(Operation op, int startPoint, int endPoint, boolean vcardType21, String ownerVCard) {
        String selection;
        long endPointId;
        long startPointId;
        block7: {
            if (startPoint < 1 || startPoint > endPoint) {
                Log.e((String)TAG, (String)"internal error: startPoint or endPoint is not correct.");
                return 208;
            }
            Uri myUri = ContactsContract.Contacts.CONTENT_URI;
            Cursor contactCursor = null;
            startPointId = 0L;
            endPointId = 0L;
            try {
                contactCursor = this.mResolver.query(myUri, CONTACTS_PROJECTION, CLAUSE_ONLY_VISIBLE, null, "_id");
                if (contactCursor != null) {
                    contactCursor.moveToPosition(startPoint - 1);
                    startPointId = contactCursor.getLong(0);
                    if (startPoint == endPoint) {
                        endPointId = startPointId;
                    } else {
                        contactCursor.moveToPosition(endPoint - 1);
                        endPointId = contactCursor.getLong(0);
                    }
                }
                Object var13_10 = null;
                if (contactCursor == null) break block7;
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                if (contactCursor == null) throw throwable;
                contactCursor.close();
                throw throwable;
            }
            contactCursor.close();
        }
        if (startPoint == endPoint) {
            selection = "_id=" + startPointId + " AND " + CLAUSE_ONLY_VISIBLE;
            return this.composeAndSendVCards(op, selection, vcardType21, ownerVCard, true);
        }
        selection = "_id>=" + startPointId + " AND " + "_id" + "<=" + endPointId + " AND " + CLAUSE_ONLY_VISIBLE;
        return this.composeAndSendVCards(op, selection, vcardType21, ownerVCard, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int composeAndSendPhonebookOneVcard(Operation op, int offset, boolean vcardType21, String ownerVCard, int orderByWhat) {
        long contactId;
        String selection;
        block12: {
            if (offset < 1) {
                Log.e((String)TAG, (String)"Internal error: offset is not correct.");
                return 208;
            }
            Uri myUri = ContactsContract.Contacts.CONTENT_URI;
            Cursor contactCursor = null;
            selection = null;
            contactId = 0L;
            if (orderByWhat == BluetoothPbapObexServer.ORDER_BY_INDEXED) {
                try {
                    contactCursor = this.mResolver.query(myUri, CONTACTS_PROJECTION, CLAUSE_ONLY_VISIBLE, null, "_id");
                    if (contactCursor != null) {
                        contactCursor.moveToPosition(offset - 1);
                        contactId = contactCursor.getLong(0);
                    }
                    Object var12_10 = null;
                    if (contactCursor == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (contactCursor != null) {
                        contactCursor.close();
                    }
                    throw throwable;
                }
                contactCursor.close();
            } else {
                if (orderByWhat != BluetoothPbapObexServer.ORDER_BY_ALPHABETICAL) {
                    Log.e((String)TAG, (String)"Parameter orderByWhat is not supported!");
                    return 208;
                }
                try {
                    contactCursor = this.mResolver.query(myUri, CONTACTS_PROJECTION, CLAUSE_ONLY_VISIBLE, null, "display_name");
                    if (contactCursor != null) {
                        contactCursor.moveToPosition(offset - 1);
                        contactId = contactCursor.getLong(0);
                    }
                    Object var14_13 = null;
                    if (contactCursor == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    if (contactCursor != null) {
                        contactCursor.close();
                    }
                    throw throwable;
                }
                contactCursor.close();
            }
        }
        selection = "_id=" + contactId;
        return this.composeAndSendVCards(op, selection, vcardType21, ownerVCard, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int composeAndSendVCards(Operation op, String selection, boolean vcardType21, String ownerVCard, boolean isContacts) {
        BluetoothPbapCallLogComposer composer;
        block14: {
            int n;
            block15: {
                long timestamp = 0L;
                if (isContacts) {
                    VCardComposer composer2;
                    block12: {
                        int n2;
                        block13: {
                            int n3;
                            block11: {
                                composer2 = null;
                                try {
                                    int vcardType = vcardType21 ? -1073741824 : -1073741823;
                                    vcardType |= 0x800000;
                                    composer2 = new VCardComposer(this.mContext, vcardType |= 0x2000000, true);
                                    composer2.addHandler((VCardComposer.OneEntryHandler)new HandlerForStringBuffer(op, ownerVCard));
                                    if (!composer2.init(ContactsContract.Contacts.CONTENT_URI, selection, null, "_id")) {
                                        n3 = 208;
                                        Object var12_14 = null;
                                        if (composer2 == null) return n3;
                                        break block11;
                                    }
                                    while (!composer2.isAfterLast()) {
                                        if (BluetoothPbapObexServer.sIsAborted) {
                                            ((ServerOperation)op).isAborted = true;
                                            BluetoothPbapObexServer.sIsAborted = false;
                                            break block12;
                                        }
                                        if (composer2.createOneEntry()) continue;
                                        Log.e((String)TAG, (String)("Failed to read a contact. Error reason: " + composer2.getErrorReason()));
                                        n2 = 208;
                                        break block13;
                                    }
                                    break block12;
                                }
                                catch (Throwable throwable) {
                                    Object var12_17 = null;
                                    if (composer2 == null) throw throwable;
                                    composer2.terminate();
                                    throw throwable;
                                }
                            }
                            composer2.terminate();
                            return n3;
                        }
                        Object var12_15 = null;
                        if (composer2 == null) return n2;
                        composer2.terminate();
                        return n2;
                    }
                    Object var12_16 = null;
                    if (composer2 == null) return 160;
                    composer2.terminate();
                    return 160;
                }
                composer = null;
                try {
                    composer = new BluetoothPbapCallLogComposer(this.mContext, true);
                    composer.addHandler(new HandlerForStringBuffer(op, ownerVCard));
                    if (!composer.init(CallLog.Calls.CONTENT_URI, selection, null, CALLLOG_SORT_ORDER)) {
                        int n4 = 208;
                        Object var14_19 = null;
                        if (composer == null) return n4;
                        composer.terminate();
                        return n4;
                    }
                    while (!composer.isAfterLast()) {
                        if (BluetoothPbapObexServer.sIsAborted) {
                            ((ServerOperation)op).isAborted = true;
                            BluetoothPbapObexServer.sIsAborted = false;
                            break block14;
                        }
                        if (composer.createOneEntry()) continue;
                        Log.e((String)TAG, (String)("Failed to read a contact. Error reason: " + composer.getErrorReason()));
                        n = 208;
                        break block15;
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    if (composer == null) throw throwable;
                    composer.terminate();
                    throw throwable;
                }
            }
            Object var14_20 = null;
            if (composer == null) return n;
            composer.terminate();
            return n;
        }
        Object var14_21 = null;
        if (composer == null) return 160;
        composer.terminate();
        return 160;
    }

    public class HandlerForStringBuffer
    implements VCardComposer.OneEntryHandler {
        private Operation operation;
        private OutputStream outputStream;
        private int maxPacketSize;
        private String phoneOwnVCard = null;

        public HandlerForStringBuffer(Operation op, String ownerVCard) {
            this.operation = op;
            this.maxPacketSize = this.operation.getMaxPacketSize();
            if (ownerVCard != null) {
                this.phoneOwnVCard = ownerVCard;
            }
        }

        public boolean onInit(Context context) {
            try {
                this.outputStream = this.operation.openOutputStream();
                BluetoothPbapVcardManager.this.mVcardResults = new StringBuilder();
                if (this.phoneOwnVCard != null) {
                    BluetoothPbapVcardManager.this.mVcardResults.append(this.phoneOwnVCard);
                }
            }
            catch (IOException e) {
                Log.e((String)BluetoothPbapVcardManager.TAG, (String)("open outputstrem failed" + e.toString()));
                return false;
            }
            return true;
        }

        public boolean onEntryCreated(String vcard) {
            int vcardLen = vcard.length();
            BluetoothPbapVcardManager.this.mVcardResults.append(vcard);
            int vcardByteLen = BluetoothPbapVcardManager.this.mVcardResults.toString().getBytes().length;
            if (vcardByteLen >= this.maxPacketSize) {
                int position;
                long timestamp = 0L;
                for (position = 0; !BluetoothPbapObexServer.sIsAborted && position < vcardByteLen - this.maxPacketSize; position += this.maxPacketSize) {
                    String subStr = BluetoothPbapVcardManager.this.mVcardResults.toString().substring(position, position + this.maxPacketSize);
                    try {
                        this.outputStream.write(subStr.getBytes(), 0, this.maxPacketSize);
                        continue;
                    }
                    catch (IOException e) {
                        Log.e((String)BluetoothPbapVcardManager.TAG, (String)("write outputstrem failed" + e.toString()));
                        return false;
                    }
                }
                BluetoothPbapVcardManager.this.mVcardResults.delete(0, position);
            }
            return true;
        }

        public void onTerminate() {
            byte[] lastBytes = BluetoothPbapVcardManager.this.mVcardResults.toString().getBytes();
            try {
                this.outputStream.write(lastBytes, 0, lastBytes.length);
            }
            catch (IOException e) {
                Log.e((String)BluetoothPbapVcardManager.TAG, (String)("write outputstrem failed" + e.toString()));
            }
            if (!BluetoothPbapObexServer.closeStream(this.outputStream, this.operation)) {
                // empty if block
            }
        }
    }
}

