/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.pbap;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetoothPbap;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.bluetooth.pbap.BluetoothPbapActivity;
import com.android.bluetooth.pbap.BluetoothPbapAuthenticator;
import com.android.bluetooth.pbap.BluetoothPbapObexServer;
import com.android.bluetooth.pbap.BluetoothPbapReceiver;
import com.android.bluetooth.pbap.BluetoothPbapRfcommTransport;
import java.io.IOException;
import javax.obex.Authenticator;
import javax.obex.ObexTransport;
import javax.obex.ServerRequestHandler;
import javax.obex.ServerSession;

public class BluetoothPbapService
extends Service {
    private static final String TAG = "BluetoothPbapService";
    public static final boolean DEBUG = false;
    public static final boolean VERBOSE = false;
    public static final String ACCESS_REQUEST_ACTION = "com.android.bluetooth.pbap.accessrequest";
    public static final String ACCESS_ALLOWED_ACTION = "com.android.bluetooth.pbap.accessallowed";
    public static final String ACCESS_DISALLOWED_ACTION = "com.android.bluetooth.pbap.accessdisallowed";
    public static final String AUTH_CHALL_ACTION = "com.android.bluetooth.pbap.authchall";
    public static final String AUTH_RESPONSE_ACTION = "com.android.bluetooth.pbap.authresponse";
    public static final String AUTH_CANCELLED_ACTION = "com.android.bluetooth.pbap.authcancelled";
    public static final String USER_CONFIRM_TIMEOUT_ACTION = "com.android.bluetooth.pbap.userconfirmtimeout";
    public static final String EXTRA_ALWAYS_ALLOWED = "com.android.bluetooth.pbap.alwaysallowed";
    public static final String EXTRA_SESSION_KEY = "com.android.bluetooth.pbap.sessionkey";
    public static final String THIS_PACKAGE_NAME = "com.android.bluetooth";
    public static final int MSG_SERVERSESSION_CLOSE = 5000;
    public static final int MSG_SESSION_ESTABLISHED = 5001;
    public static final int MSG_SESSION_DISCONNECTED = 5002;
    public static final int MSG_OBEX_AUTH_CHALL = 5003;
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final int START_LISTENER = 1;
    private static final int USER_TIMEOUT = 2;
    private static final int AUTH_TIMEOUT = 3;
    private static final int PORT_NUM = 19;
    private static final int USER_CONFIRM_TIMEOUT_VALUE = 30000;
    private static final int TIME_TO_WAIT_VALUE = 6000;
    private static final int NOTIFICATION_ID_ACCESS = -1000001;
    private static final int NOTIFICATION_ID_AUTH = -1000002;
    private PowerManager.WakeLock mWakeLock = null;
    private BluetoothAdapter mAdapter;
    private SocketAcceptThread mAcceptThread = null;
    private BluetoothPbapAuthenticator mAuth = null;
    private BluetoothPbapObexServer mPbapServer;
    private ServerSession mServerSession = null;
    private BluetoothServerSocket mServerSocket = null;
    private BluetoothSocket mConnSocket = null;
    private BluetoothDevice mRemoteDevice = null;
    private static String sLocalPhoneNum = null;
    private static String sLocalPhoneName = null;
    private static String sRemoteDeviceName = null;
    private boolean mHasStarted = false;
    private volatile boolean mInterrupted;
    private int mState = 0;
    private int mStartId = -1;
    private final Handler mSessionStatusHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (BluetoothPbapService.this.mAdapter.isEnabled()) {
                        BluetoothPbapService.this.startRfcommSocketListener();
                        break;
                    }
                    BluetoothPbapService.this.closeService();
                    break;
                }
                case 2: {
                    Intent intent = new Intent(BluetoothPbapService.USER_CONFIRM_TIMEOUT_ACTION);
                    BluetoothPbapService.this.sendBroadcast(intent);
                    BluetoothPbapService.this.removePbapNotification(-1000001);
                    BluetoothPbapService.this.stopObexServerSession();
                    break;
                }
                case 3: {
                    Intent i = new Intent(BluetoothPbapService.USER_CONFIRM_TIMEOUT_ACTION);
                    BluetoothPbapService.this.sendBroadcast(i);
                    BluetoothPbapService.this.removePbapNotification(-1000002);
                    BluetoothPbapService.this.notifyAuthCancelled();
                    break;
                }
                case 5000: {
                    BluetoothPbapService.this.stopObexServerSession();
                    break;
                }
                case 5001: {
                    break;
                }
                case 5002: {
                    break;
                }
                case 5003: {
                    BluetoothPbapService.this.createPbapNotification(BluetoothPbapService.AUTH_CHALL_ACTION);
                    BluetoothPbapService.this.mSessionStatusHandler.sendMessageDelayed(BluetoothPbapService.this.mSessionStatusHandler.obtainMessage(3), 30000L);
                    break;
                }
            }
        }
    };
    private final IBluetoothPbap.Stub mBinder = new IBluetoothPbap.Stub(){

        public int getState() {
            BluetoothPbapService.this.enforceCallingOrSelfPermission(BluetoothPbapService.BLUETOOTH_PERM, "Need BLUETOOTH permission");
            return BluetoothPbapService.this.mState;
        }

        public BluetoothDevice getClient() {
            BluetoothPbapService.this.enforceCallingOrSelfPermission(BluetoothPbapService.BLUETOOTH_PERM, "Need BLUETOOTH permission");
            if (BluetoothPbapService.this.mState == 0) {
                return null;
            }
            return BluetoothPbapService.this.mRemoteDevice;
        }

        public boolean isConnected(BluetoothDevice device) {
            BluetoothPbapService.this.enforceCallingOrSelfPermission(BluetoothPbapService.BLUETOOTH_PERM, "Need BLUETOOTH permission");
            return BluetoothPbapService.this.mState == 2 && BluetoothPbapService.this.mRemoteDevice.equals((Object)device);
        }

        public boolean connect(BluetoothDevice device) {
            BluetoothPbapService.this.enforceCallingOrSelfPermission(BluetoothPbapService.BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            BluetoothPbapService.this.enforceCallingOrSelfPermission(BluetoothPbapService.BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
            BluetoothPbapService bluetoothPbapService = BluetoothPbapService.this;
            synchronized (bluetoothPbapService) {
                switch (BluetoothPbapService.this.mState) {
                    case 2: {
                        if (BluetoothPbapService.this.mServerSession != null) {
                            BluetoothPbapService.this.mServerSession.close();
                            BluetoothPbapService.this.mServerSession = null;
                        }
                        try {
                            BluetoothPbapService.this.closeSocket(false, true);
                            BluetoothPbapService.this.mConnSocket = null;
                        }
                        catch (IOException ex) {
                            Log.e((String)BluetoothPbapService.TAG, (String)("Caught the error: " + ex));
                        }
                        BluetoothPbapService.this.setState(0, 2);
                        break;
                    }
                }
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        this.mInterrupted = false;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        if (!this.mHasStarted) {
            this.mHasStarted = true;
            int state = this.mAdapter.getState();
            if (state == 12) {
                this.mSessionStatusHandler.sendMessageDelayed(this.mSessionStatusHandler.obtainMessage(1), 6000L);
            }
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int retCode = super.onStartCommand(intent, flags, startId);
        if (retCode == 1) {
            this.mStartId = startId;
            if (this.mAdapter == null) {
                Log.w((String)TAG, (String)"Stopping BluetoothPbapService: device does not have BT or device is not ready");
                this.closeService();
            } else if (intent != null) {
                this.parseIntent(intent);
            }
        }
        return retCode;
    }

    private void parseIntent(Intent intent) {
        boolean removeTimeoutMsg;
        block16: {
            String action = intent.getStringExtra("action");
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            removeTimeoutMsg = true;
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                removeTimeoutMsg = false;
                if (state == 10) {
                    this.closeService();
                }
            } else if (action.equals(ACCESS_ALLOWED_ACTION)) {
                if (intent.getBooleanExtra(EXTRA_ALWAYS_ALLOWED, false)) {
                    boolean result = this.mRemoteDevice.setTrust(true);
                }
                try {
                    if (this.mConnSocket != null) {
                        this.startObexServerSession();
                        break block16;
                    }
                    this.stopObexServerSession();
                }
                catch (IOException ex) {
                    Log.e((String)TAG, (String)("Caught the error: " + ex.toString()));
                }
            } else if (action.equals(ACCESS_DISALLOWED_ACTION)) {
                this.stopObexServerSession();
            } else if (action.equals(AUTH_RESPONSE_ACTION)) {
                String sessionkey = intent.getStringExtra(EXTRA_SESSION_KEY);
                this.notifyAuthKeyInput(sessionkey);
            } else if (action.equals(AUTH_CANCELLED_ACTION)) {
                this.notifyAuthCancelled();
            } else {
                removeTimeoutMsg = false;
            }
        }
        if (removeTimeoutMsg) {
            this.mSessionStatusHandler.removeMessages(2);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.setState(0, 2);
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
            this.mWakeLock = null;
        }
        this.closeService();
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    private void startRfcommSocketListener() {
        if (this.mServerSocket == null && !this.initSocket()) {
            this.closeService();
            return;
        }
        if (this.mAcceptThread == null) {
            this.mAcceptThread = new SocketAcceptThread();
            this.mAcceptThread.setName("BluetoothPbapAcceptThread");
            this.mAcceptThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean initSocket() {
        boolean initSocketOK = true;
        int CREATE_RETRY_TIME = 10;
        for (int i = 0; i < 10 && !this.mInterrupted; ++i) {
            try {
                this.mServerSocket = this.mAdapter.listenUsingInsecureRfcommOn(19);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error create RfcommServerSocket " + e.toString()));
                initSocketOK = false;
            }
            if (initSocketOK) break;
            BluetoothPbapService bluetoothPbapService = this;
            synchronized (bluetoothPbapService) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"socketAcceptThread thread was interrupted (3)");
                    this.mInterrupted = true;
                }
                continue;
            }
        }
        if (!initSocketOK) {
            Log.e((String)TAG, (String)"Error to create listening socket after 10 try");
        }
        return initSocketOK;
    }

    private final void closeSocket(boolean server, boolean accept) throws IOException {
        if (server) {
            this.mInterrupted = true;
            if (this.mServerSocket != null) {
                this.mServerSocket.close();
            }
        }
        if (accept && this.mConnSocket != null) {
            this.mConnSocket.close();
        }
    }

    private final void closeService() {
        try {
            this.closeSocket(true, true);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("CloseSocket error: " + ex));
        }
        if (this.mAcceptThread != null) {
            try {
                this.mAcceptThread.shutdown();
                this.mAcceptThread.join();
                this.mAcceptThread = null;
            }
            catch (InterruptedException ex) {
                Log.w((String)TAG, (String)("mAcceptThread close error" + ex));
            }
        }
        this.mServerSocket = null;
        this.mConnSocket = null;
        if (this.mServerSession != null) {
            this.mServerSession.close();
            this.mServerSession = null;
        }
        this.mHasStarted = false;
        if (this.stopSelfResult(this.mStartId)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startObexServerSession() throws IOException {
        TelephonyManager tm;
        if (this.mWakeLock == null) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.mWakeLock = pm.newWakeLock(1, "StartingObexPbapTransaction");
            this.mWakeLock.setReferenceCounted(false);
            this.mWakeLock.acquire();
        }
        if ((tm = (TelephonyManager)this.getSystemService("phone")) != null) {
            sLocalPhoneNum = tm.getLine1Number();
            sLocalPhoneName = tm.getLine1AlphaTag();
            if (TextUtils.isEmpty((CharSequence)sLocalPhoneName)) {
                sLocalPhoneName = this.getString(2130968686);
            }
        }
        this.mPbapServer = new BluetoothPbapObexServer(this.mSessionStatusHandler, (Context)this);
        BluetoothPbapService bluetoothPbapService = this;
        synchronized (bluetoothPbapService) {
            this.mAuth = new BluetoothPbapAuthenticator(this.mSessionStatusHandler);
            this.mAuth.setChallenged(false);
            this.mAuth.setCancelled(false);
        }
        BluetoothPbapRfcommTransport transport = new BluetoothPbapRfcommTransport(this.mConnSocket);
        this.mServerSession = new ServerSession((ObexTransport)transport, (ServerRequestHandler)this.mPbapServer, (Authenticator)this.mAuth);
        this.setState(2);
    }

    private void stopObexServerSession() {
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
            this.mWakeLock = null;
        }
        if (this.mServerSession != null) {
            this.mServerSession.close();
            this.mServerSession = null;
        }
        this.mAcceptThread = null;
        try {
            this.closeSocket(false, true);
            this.mConnSocket = null;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("closeSocket error: " + e.toString()));
        }
        if (this.mAdapter.isEnabled()) {
            this.startRfcommSocketListener();
        }
        this.setState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAuthKeyInput(String key) {
        BluetoothPbapAuthenticator bluetoothPbapAuthenticator = this.mAuth;
        synchronized (bluetoothPbapAuthenticator) {
            if (key != null) {
                this.mAuth.setSessionKey(key);
            }
            this.mAuth.setChallenged(true);
            this.mAuth.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAuthCancelled() {
        BluetoothPbapAuthenticator bluetoothPbapAuthenticator = this.mAuth;
        synchronized (bluetoothPbapAuthenticator) {
            this.mAuth.setCancelled(true);
            this.mAuth.notify();
        }
    }

    private void setState(int state) {
        this.setState(state, 1);
    }

    private synchronized void setState(int state, int result) {
        if (state != this.mState) {
            Intent intent = new Intent("android.bluetooth.pbap.intent.action.PBAP_STATE_CHANGED");
            intent.putExtra("android.bluetooth.pbap.intent.PBAP_PREVIOUS_STATE", this.mState);
            this.mState = state;
            intent.putExtra("android.bluetooth.pbap.intent.PBAP_STATE", this.mState);
            intent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)this.mRemoteDevice);
            this.sendBroadcast(intent, BLUETOOTH_PERM);
        }
    }

    private void createPbapNotification(String action) {
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        Intent clickIntent = new Intent();
        clickIntent.setClass((Context)this, BluetoothPbapActivity.class);
        clickIntent.addFlags(0x10000000);
        clickIntent.setAction(action);
        Intent deleteIntent = new Intent();
        deleteIntent.setClass((Context)this, BluetoothPbapReceiver.class);
        Notification notification = null;
        String name = BluetoothPbapService.getRemoteDeviceName();
        if (action.equals(ACCESS_REQUEST_ACTION)) {
            deleteIntent.setAction(ACCESS_DISALLOWED_ACTION);
            notification = new Notification(0x1080080, (CharSequence)this.getString(2130968677), System.currentTimeMillis());
            notification.setLatestEventInfo((Context)this, (CharSequence)this.getString(2130968678), (CharSequence)this.getString(2130968679, new Object[]{name}), PendingIntent.getActivity((Context)this, (int)0, (Intent)clickIntent, (int)0));
            notification.flags |= 0x10;
            notification.flags |= 8;
            notification.defaults = 1;
            notification.deleteIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)deleteIntent, (int)0);
            nm.notify(-1000001, notification);
        } else if (action.equals(AUTH_CHALL_ACTION)) {
            deleteIntent.setAction(AUTH_CANCELLED_ACTION);
            notification = new Notification(0x1080080, (CharSequence)this.getString(2130968680), System.currentTimeMillis());
            notification.setLatestEventInfo((Context)this, (CharSequence)this.getString(2130968681), (CharSequence)this.getString(2130968682, new Object[]{name}), PendingIntent.getActivity((Context)this, (int)0, (Intent)clickIntent, (int)0));
            notification.flags |= 0x10;
            notification.flags |= 8;
            notification.defaults = 1;
            notification.deleteIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)deleteIntent, (int)0);
            nm.notify(-1000002, notification);
        }
    }

    private void removePbapNotification(int id2) {
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        nm.cancel(id2);
    }

    public static String getLocalPhoneNum() {
        return sLocalPhoneNum;
    }

    public static String getLocalPhoneName() {
        return sLocalPhoneName;
    }

    public static String getRemoteDeviceName() {
        return sRemoteDeviceName;
    }

    private class SocketAcceptThread
    extends Thread {
        private boolean stopped = false;

        private SocketAcceptThread() {
        }

        public void run() {
            while (!this.stopped) {
                try {
                    boolean trust;
                    BluetoothPbapService.this.mConnSocket = BluetoothPbapService.this.mServerSocket.accept();
                    BluetoothPbapService.this.mRemoteDevice = BluetoothPbapService.this.mConnSocket.getRemoteDevice();
                    if (BluetoothPbapService.this.mRemoteDevice == null) {
                        Log.i((String)BluetoothPbapService.TAG, (String)"getRemoteDevice() = null");
                        break;
                    }
                    sRemoteDeviceName = BluetoothPbapService.this.mRemoteDevice.getName();
                    if (TextUtils.isEmpty((CharSequence)sRemoteDeviceName)) {
                        sRemoteDeviceName = BluetoothPbapService.this.getString(2130968684);
                    }
                    if (trust = BluetoothPbapService.this.mRemoteDevice.getTrustState()) {
                        try {
                            BluetoothPbapService.this.startObexServerSession();
                        }
                        catch (IOException ex) {
                            Log.e((String)BluetoothPbapService.TAG, (String)("catch exception starting obex server session" + ex.toString()));
                        }
                    } else {
                        BluetoothPbapService.this.createPbapNotification(BluetoothPbapService.ACCESS_REQUEST_ACTION);
                        BluetoothPbapService.this.mSessionStatusHandler.sendMessageDelayed(BluetoothPbapService.this.mSessionStatusHandler.obtainMessage(2), 30000L);
                    }
                    this.stopped = true;
                }
                catch (IOException ex) {
                    if (!this.stopped) continue;
                    break;
                }
            }
        }

        void shutdown() {
            this.stopped = true;
            this.interrupt();
        }
    }
}

