/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.pbap;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.android.bluetooth.pbap.BluetoothPbapVcardManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.obex.ApplicationParameter;
import javax.obex.HeaderSet;
import javax.obex.Operation;
import javax.obex.ServerOperation;
import javax.obex.ServerRequestHandler;

public class BluetoothPbapObexServer
extends ServerRequestHandler {
    private static final String TAG = "BluetoothPbapObexServer";
    private static final boolean D = false;
    private static final boolean V = false;
    private static final int UUID_LENGTH = 16;
    private static final int VCARD_NAME_SUFFIX_LENGTH = 5;
    private static final byte[] PBAP_TARGET = new byte[]{121, 97, 53, -16, -16, -59, 17, -40, 9, 102, 8, 0, 32, 12, -102, 102};
    private static final String[] LEGAL_PATH = new String[]{"/telecom", "/telecom/pb", "/telecom/ich", "/telecom/och", "/telecom/mch", "/telecom/cch"};
    private static final String[] LEGAL_PATH_WITH_SIM = new String[]{"/telecom", "/telecom/pb", "/telecom/ich", "/telecom/och", "/telecom/mch", "/telecom/cch", "/SIM1", "/SIM1/telecom", "/SIM1/telecom/ich", "/SIM1/telecom/och", "/SIM1/telecom/mch", "/SIM1/telecom/cch", "/SIM1/telecom/pb"};
    private static final String SIM1 = "SIM1";
    private static final String MCH = "mch";
    private static final String ICH = "ich";
    private static final String OCH = "och";
    private static final String CCH = "cch";
    private static final String PB = "pb";
    private static final String ICH_PATH = "/telecom/ich";
    private static final String OCH_PATH = "/telecom/och";
    private static final String MCH_PATH = "/telecom/mch";
    private static final String CCH_PATH = "/telecom/cch";
    private static final String PB_PATH = "/telecom/pb";
    private static final String TYPE_LISTING = "x-bt/vcard-listing";
    private static final String TYPE_VCARD = "x-bt/vcard";
    private static final int NEED_SEND_BODY = -1;
    private static final String TYPE_PB = "x-bt/phonebook";
    private boolean mNeedPhonebookSize = false;
    private boolean mNeedNewMissedCallsNum = false;
    private int mMissedCallSize = 0;
    private String mCurrentPath = "";
    private long mConnectionId = -1L;
    private Handler mCallback = null;
    private Context mContext;
    private BluetoothPbapVcardManager mVcardManager;
    private int mOrderBy = ORDER_BY_INDEXED;
    private static int CALLLOG_NUM_LIMIT = 50;
    public static int ORDER_BY_INDEXED = 0;
    public static int ORDER_BY_ALPHABETICAL = 1;
    public static boolean sIsAborted = false;

    public BluetoothPbapObexServer(Handler callback, Context context) {
        this.mCallback = callback;
        this.mContext = context;
        this.mVcardManager = new BluetoothPbapVcardManager(this.mContext);
        this.mMissedCallSize = this.mVcardManager.getPhonebookSize(4);
    }

    public int onConnect(HeaderSet request, HeaderSet reply) {
        try {
            byte[] uuid = (byte[])request.getHeader(70);
            if (uuid == null) {
                return 198;
            }
            if (uuid.length != 16) {
                Log.w((String)TAG, (String)"Wrong UUID length");
                return 198;
            }
            for (int i = 0; i < 16; ++i) {
                if (uuid[i] == PBAP_TARGET[i]) continue;
                Log.w((String)TAG, (String)"Wrong UUID");
                return 198;
            }
            reply.setHeader(74, (Object)uuid);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
            return 208;
        }
        try {
            byte[] remote = (byte[])request.getHeader(74);
            if (remote != null) {
                reply.setHeader(70, (Object)remote);
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
            return 208;
        }
        Message msg = Message.obtain((Handler)this.mCallback);
        msg.what = 5001;
        msg.sendToTarget();
        return 160;
    }

    public void onDisconnect(HeaderSet req, HeaderSet resp) {
        resp.responseCode = 160;
        if (this.mCallback != null) {
            Message msg = Message.obtain((Handler)this.mCallback);
            msg.what = 5002;
            msg.sendToTarget();
        }
    }

    public int onAbort(HeaderSet request, HeaderSet reply) {
        sIsAborted = true;
        return 160;
    }

    public int onPut(Operation op) {
        return 192;
    }

    public int onSetPath(HeaderSet request, HeaderSet reply, boolean backup, boolean create) {
        String current_path_tmp = this.mCurrentPath;
        String tmp_path = null;
        try {
            tmp_path = (String)request.getHeader(1);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Get name header fail");
            return 208;
        }
        if (backup) {
            if (current_path_tmp.length() != 0) {
                current_path_tmp = current_path_tmp.substring(0, current_path_tmp.lastIndexOf("/"));
            }
        } else {
            current_path_tmp = tmp_path == null ? "" : current_path_tmp + "/" + tmp_path;
        }
        if (current_path_tmp.length() != 0 && !this.isLegalPath(current_path_tmp)) {
            if (create) {
                Log.w((String)TAG, (String)"path create is forbidden!");
                return 195;
            }
            Log.w((String)TAG, (String)"path is not legal");
            return 196;
        }
        this.mCurrentPath = current_path_tmp;
        return 160;
    }

    public void onClose() {
        if (this.mCallback != null) {
            Message msg = Message.obtain((Handler)this.mCallback);
            msg.what = 5000;
            msg.sendToTarget();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int onGet(Operation op) {
        AppParamValue appParamValue;
        byte[] appParam;
        String name;
        String type;
        HeaderSet reply;
        block23: {
            block24: {
                block26: {
                    block25: {
                        sIsAborted = false;
                        HeaderSet request = null;
                        reply = new HeaderSet();
                        type = "";
                        name = "";
                        appParam = null;
                        appParamValue = new AppParamValue();
                        try {
                            request = op.getReceivedHeader();
                            type = (String)request.getHeader(66);
                            name = (String)request.getHeader(1);
                            appParam = (byte[])request.getHeader(76);
                        }
                        catch (IOException e) {
                            Log.e((String)TAG, (String)"request headers error");
                            return 208;
                        }
                        if (type == null) {
                            return 198;
                        }
                        boolean validName = true;
                        if (TextUtils.isEmpty((CharSequence)name)) {
                            validName = false;
                        }
                        if (validName && (!validName || !type.equals(TYPE_VCARD))) break block24;
                        if (!this.mCurrentPath.equals(PB_PATH)) break block25;
                        appParamValue.needTag = 1;
                        break block23;
                    }
                    if (!this.mCurrentPath.equals(ICH_PATH)) break block26;
                    appParamValue.needTag = 2;
                    break block23;
                }
                if (this.mCurrentPath.equals(OCH_PATH)) {
                    appParamValue.needTag = 3;
                    break block23;
                } else if (this.mCurrentPath.equals(MCH_PATH)) {
                    appParamValue.needTag = 4;
                    this.mNeedNewMissedCallsNum = true;
                    break block23;
                } else {
                    if (!this.mCurrentPath.equals(CCH_PATH)) {
                        Log.w((String)TAG, (String)"mCurrentpath is not valid path!!!");
                        return 198;
                    }
                    appParamValue.needTag = 5;
                }
                break block23;
            }
            if (name.contains(SIM1.subSequence(0, SIM1.length()))) {
                Log.w((String)TAG, (String)"Not support access SIM card info!");
                return 198;
            }
            if (name.contains(PB.subSequence(0, PB.length()))) {
                appParamValue.needTag = 1;
            } else if (name.contains(ICH.subSequence(0, ICH.length()))) {
                appParamValue.needTag = 2;
            } else if (name.contains(OCH.subSequence(0, OCH.length()))) {
                appParamValue.needTag = 3;
            } else if (name.contains(MCH.subSequence(0, MCH.length()))) {
                appParamValue.needTag = 4;
                this.mNeedNewMissedCallsNum = true;
            } else {
                if (!name.contains(CCH.subSequence(0, CCH.length()))) {
                    Log.w((String)TAG, (String)"Input name doesn't contain valid info!!!");
                    return 198;
                }
                appParamValue.needTag = 5;
            }
        }
        if (appParam != null && !this.parseApplicationParameter(appParam, appParamValue)) {
            return 192;
        }
        if (type.equals(TYPE_LISTING)) {
            return this.pullVcardListing(appParam, appParamValue, reply, op);
        }
        if (type.equals(TYPE_VCARD)) {
            return this.pullVcardEntry(appParam, appParamValue, op, name, this.mCurrentPath);
        }
        if (type.equals(TYPE_PB)) {
            return this.pullPhonebook(appParam, appParamValue, reply, op, name);
        }
        Log.w((String)TAG, (String)"unknown type request!!!");
        return 198;
    }

    private final boolean isLegalPath(String str) {
        if (str.length() == 0) {
            return true;
        }
        for (int i = 0; i < LEGAL_PATH.length; ++i) {
            if (!str.equals(LEGAL_PATH[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean parseApplicationParameter(byte[] appParam, AppParamValue appParamValue) {
        int i = 0;
        boolean parseOk = true;
        block9: while (i < appParam.length) {
            switch (appParam[i]) {
                case 6: {
                    i += 2;
                    i += 8;
                    continue block9;
                }
                case 1: {
                    appParamValue.order = Byte.toString(appParam[i += 2]);
                    ++i;
                    continue block9;
                }
                case 2: {
                    byte length = appParam[++i];
                    if (length == 0) {
                        parseOk = false;
                        continue block9;
                    }
                    appParamValue.searchValue = appParam[i + length] == 0 ? new String(appParam, i + 1, length - 1) : new String(appParam, i + 1, (int)length);
                    i += length;
                    ++i;
                    continue block9;
                }
                case 3: {
                    appParamValue.searchAttr = Byte.toString(appParam[i += 2]);
                    ++i;
                    continue block9;
                }
                case 4: {
                    int lowValue;
                    int highValue;
                    if (appParam[i += 2] == 0 && appParam[i + 1] == 0) {
                        this.mNeedPhonebookSize = true;
                    } else {
                        highValue = appParam[i] & 0xFF;
                        lowValue = appParam[i + 1] & 0xFF;
                        appParamValue.maxListCount = highValue * 256 + lowValue;
                    }
                    i += 2;
                    continue block9;
                }
                case 5: {
                    int highValue = appParam[i += 2] & 0xFF;
                    int lowValue = appParam[i + 1] & 0xFF;
                    appParamValue.listStartOffset = highValue * 256 + lowValue;
                    i += 2;
                    continue block9;
                }
                case 7: {
                    if (appParam[i += 2] != 0) {
                        appParamValue.vcard21 = false;
                    }
                    ++i;
                    continue block9;
                }
            }
            parseOk = false;
            Log.e((String)TAG, (String)"Parse Application Parameter error");
        }
        return parseOk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int sendVcardListingXml(int type, Operation op, int maxListCount, int listStartOffset, String searchValue, String searchAttr) {
        StringBuilder result = new StringBuilder();
        int itemsFound = 0;
        result.append("<?xml version=\"1.0\"?>");
        result.append("<!DOCTYPE vcard-listing SYSTEM \"vcard-listing.dtd\">");
        result.append("<vCard-listing version=\"1.0\">");
        if (type == 1) {
            if (searchAttr.equals("0")) {
                itemsFound = this.createList(maxListCount, listStartOffset, searchValue, result, "name");
            } else {
                if (!searchAttr.equals("1")) return 204;
                itemsFound = this.createList(maxListCount, listStartOffset, searchValue, result, "number");
            }
        } else {
            int startPoint = listStartOffset;
            ArrayList<String> nameList = this.mVcardManager.loadCallHistoryList(type);
            int requestSize = nameList.size() >= maxListCount ? maxListCount : nameList.size();
            int endPoint = startPoint + requestSize;
            if (endPoint > nameList.size()) {
                endPoint = nameList.size();
            }
            for (int j = startPoint; j < endPoint; ++j) {
                result.append("<card handle=\"" + (j + 1) + ".vcf\" name=\"" + nameList.get(j) + "\"" + "/>");
                ++itemsFound;
            }
        }
        result.append("</vCard-listing>");
        return this.pushBytes(op, result.toString());
    }

    private int createList(int maxListCount, int listStartOffset, String searchValue, StringBuilder result, String type) {
        int itemsFound = 0;
        ArrayList<String> nameList = this.mVcardManager.getPhonebookNameList(this.mOrderBy);
        int requestSize = nameList.size() >= maxListCount ? maxListCount : nameList.size();
        int listSize = nameList.size();
        String compareValue = "";
        if (type.equals("number")) {
            ArrayList<String> names = this.mVcardManager.getContactNamesByNumber(searchValue);
            for (int i = 0; i < names.size(); ++i) {
                compareValue = names.get(i).trim();
                for (int pos = listStartOffset; pos < listSize && itemsFound < requestSize; ++pos) {
                    String currentValue = nameList.get(pos);
                    if (!currentValue.startsWith(compareValue)) continue;
                    ++itemsFound;
                    result.append("<card handle=\"" + pos + ".vcf\" name=\"" + currentValue + "\"" + "/>");
                }
                if (itemsFound < requestSize) {
                    continue;
                }
                break;
            }
        } else {
            if (searchValue != null) {
                compareValue = searchValue.trim();
            }
            for (int pos = listStartOffset; pos < listSize && itemsFound < requestSize; ++pos) {
                String currentValue = nameList.get(pos);
                if (searchValue != null && !currentValue.startsWith(compareValue)) continue;
                ++itemsFound;
                result.append("<card handle=\"" + pos + ".vcf\" name=\"" + currentValue + "\"" + "/>");
            }
        }
        return itemsFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int pushHeader(Operation op, HeaderSet reply) {
        OutputStream outputStream = null;
        int pushResult = 160;
        try {
            try {
                op.sendHeaders(reply);
                outputStream = op.openOutputStream();
                outputStream.flush();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.toString());
                pushResult = 208;
                Object var7_6 = null;
                if (BluetoothPbapObexServer.closeStream(outputStream, op)) return pushResult;
                return 208;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (BluetoothPbapObexServer.closeStream(outputStream, op)) throw throwable;
            pushResult = 208;
            throw throwable;
        }
        if (BluetoothPbapObexServer.closeStream(outputStream, op)) return pushResult;
        return 208;
    }

    private final int pushBytes(Operation op, String vcardString) {
        int readLength;
        if (vcardString == null) {
            Log.w((String)TAG, (String)"vcardString is null!");
            return 160;
        }
        int vcardStringLen = vcardString.length();
        OutputStream outputStream = null;
        int pushResult = 160;
        try {
            outputStream = op.openOutputStream();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("open outputstrem failed" + e.toString()));
            return 208;
        }
        long timestamp = 0L;
        int outputBufferSize = op.getMaxPacketSize();
        for (int position = 0; position != vcardStringLen; position += readLength) {
            if (sIsAborted) {
                ((ServerOperation)op).isAborted = true;
                sIsAborted = false;
                break;
            }
            readLength = outputBufferSize;
            if (vcardStringLen - position < outputBufferSize) {
                readLength = vcardStringLen - position;
            }
            String subStr = vcardString.substring(position, position + readLength);
            try {
                outputStream.write(subStr.getBytes(), 0, readLength);
                continue;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("write outputstrem failed" + e.toString()));
                pushResult = 208;
                break;
            }
        }
        if (!BluetoothPbapObexServer.closeStream(outputStream, op)) {
            pushResult = 208;
        }
        return pushResult;
    }

    private final int handleAppParaForResponse(AppParamValue appParamValue, int size, HeaderSet reply, Operation op) {
        byte[] misnum = new byte[1];
        ApplicationParameter ap = new ApplicationParameter();
        if (this.mNeedPhonebookSize) {
            this.mNeedPhonebookSize = false;
            byte[] pbsize = new byte[]{(byte)(size / 256 & 0xFF), (byte)(size % 256 & 0xFF)};
            ap.addAPPHeader((byte)8, (byte)2, pbsize);
            if (this.mNeedNewMissedCallsNum) {
                int nmnum = size - this.mMissedCallSize;
                this.mMissedCallSize = size;
                nmnum = nmnum > 0 ? nmnum : 0;
                misnum[0] = (byte)nmnum;
                ap.addAPPHeader((byte)9, (byte)1, misnum);
            }
            reply.setHeader(76, (Object)ap.getAPPparam());
            return this.pushHeader(op, reply);
        }
        if (this.mNeedNewMissedCallsNum) {
            this.mNeedNewMissedCallsNum = false;
            int nmnum = size - this.mMissedCallSize;
            this.mMissedCallSize = size;
            nmnum = nmnum > 0 ? nmnum : 0;
            misnum[0] = (byte)nmnum;
            ap.addAPPHeader((byte)9, (byte)1, misnum);
            reply.setHeader(76, (Object)ap.getAPPparam());
            try {
                op.sendHeaders(reply);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.toString());
                return 208;
            }
        }
        return -1;
    }

    private final int pullVcardListing(byte[] appParam, AppParamValue appParamValue, HeaderSet reply, Operation op) {
        String searchAttr = appParamValue.searchAttr.trim();
        if (searchAttr == null || searchAttr.length() == 0) {
            appParamValue.searchAttr = "0";
        } else {
            if (!searchAttr.equals("0") && !searchAttr.equals("1")) {
                Log.w((String)TAG, (String)"search attr not supported");
                if (searchAttr.equals("2")) {
                    Log.w((String)TAG, (String)"do not support search by sound");
                    return 209;
                }
                return 204;
            }
            Log.i((String)TAG, (String)("searchAttr is valid: " + searchAttr));
        }
        int size = this.mVcardManager.getPhonebookSize(appParamValue.needTag);
        int needSendBody = this.handleAppParaForResponse(appParamValue, size, reply, op);
        if (needSendBody != -1) {
            return needSendBody;
        }
        if (size == 0) {
            return 160;
        }
        String orderPara = appParamValue.order.trim();
        if (TextUtils.isEmpty((CharSequence)orderPara)) {
            orderPara = "0";
        } else {
            if (!orderPara.equals("0") && !orderPara.equals("1")) {
                if (orderPara.equals("2")) {
                    Log.w((String)TAG, (String)"Do not support order by sound");
                    return 209;
                }
                return 204;
            }
            Log.i((String)TAG, (String)("Order parameter is valid: " + orderPara));
        }
        if (orderPara.equals("0")) {
            this.mOrderBy = ORDER_BY_INDEXED;
        } else if (orderPara.equals("1")) {
            this.mOrderBy = ORDER_BY_ALPHABETICAL;
        }
        int sendResult = this.sendVcardListingXml(appParamValue.needTag, op, appParamValue.maxListCount, appParamValue.listStartOffset, appParamValue.searchValue, appParamValue.searchAttr);
        return sendResult;
    }

    private final int pullVcardEntry(byte[] appParam, AppParamValue appParamValue, Operation op, String name, String current_path) {
        int size;
        if (name == null || name.length() < 5) {
            return 198;
        }
        String strIndex = name.substring(0, name.length() - 5 + 1);
        int intIndex = 0;
        if (strIndex.trim().length() != 0) {
            try {
                intIndex = Integer.parseInt(strIndex);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("catch number format exception " + e.toString()));
                return 198;
            }
        }
        if ((size = this.mVcardManager.getPhonebookSize(appParamValue.needTag)) == 0) {
            return 160;
        }
        boolean vcard21 = appParamValue.vcard21;
        if (appParamValue.needTag == 0) {
            Log.w((String)TAG, (String)"wrong path!");
            return 198;
        }
        if (appParamValue.needTag == 1) {
            if (intIndex < 0 || intIndex >= size) {
                Log.w((String)TAG, (String)("The requested vcard is not acceptable! name= " + name));
                return 160;
            }
            if (intIndex == 0) {
                String ownerVcard = this.mVcardManager.getOwnerPhoneNumberVcard(vcard21);
                return this.pushBytes(op, ownerVcard);
            }
            return this.mVcardManager.composeAndSendPhonebookOneVcard(op, intIndex, vcard21, null, this.mOrderBy);
        }
        if (intIndex <= 0 || intIndex > size) {
            Log.w((String)TAG, (String)("The requested vcard is not acceptable! name= " + name));
            return 160;
        }
        if (intIndex >= 1) {
            return this.mVcardManager.composeAndSendCallLogVcards(appParamValue.needTag, op, intIndex, intIndex, vcard21);
        }
        return 160;
    }

    private final int pullPhonebook(byte[] appParam, AppParamValue appParamValue, HeaderSet reply, Operation op, String name) {
        int endPoint;
        int pbSize;
        int needSendBody;
        if (name != null) {
            int dotIndex = name.indexOf(".");
            String vcf = "vcf";
            if (dotIndex >= 0 && dotIndex <= name.length() && !name.regionMatches(dotIndex + 1, vcf, 0, vcf.length())) {
                Log.w((String)TAG, (String)"name is not .vcf");
                return 198;
            }
        }
        if ((needSendBody = this.handleAppParaForResponse(appParamValue, pbSize = this.mVcardManager.getPhonebookSize(appParamValue.needTag), reply, op)) != -1) {
            return needSendBody;
        }
        if (pbSize == 0) {
            return 160;
        }
        int requestSize = pbSize >= appParamValue.maxListCount ? appParamValue.maxListCount : pbSize;
        int startPoint = appParamValue.listStartOffset;
        if (startPoint < 0 || startPoint >= pbSize) {
            Log.w((String)TAG, (String)("listStartOffset is not correct! " + startPoint));
            return 160;
        }
        if (appParamValue.needTag != 1 && requestSize > CALLLOG_NUM_LIMIT) {
            requestSize = CALLLOG_NUM_LIMIT;
        }
        if ((endPoint = startPoint + requestSize - 1) > pbSize - 1) {
            endPoint = pbSize - 1;
        }
        Object result = null;
        boolean vcard21 = appParamValue.vcard21;
        if (appParamValue.needTag == 1) {
            if (startPoint == 0) {
                String ownerVcard = this.mVcardManager.getOwnerPhoneNumberVcard(vcard21);
                if (endPoint == 0) {
                    return this.pushBytes(op, ownerVcard);
                }
                return this.mVcardManager.composeAndSendPhonebookVcards(op, 1, endPoint, vcard21, ownerVcard);
            }
            return this.mVcardManager.composeAndSendPhonebookVcards(op, startPoint, endPoint, vcard21, null);
        }
        return this.mVcardManager.composeAndSendCallLogVcards(appParamValue.needTag, op, startPoint + 1, endPoint + 1, vcard21);
    }

    public static boolean closeStream(OutputStream out, Operation op) {
        boolean returnvalue = true;
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("outputStream close failed" + e.toString()));
            returnvalue = false;
        }
        try {
            if (op != null) {
                op.close();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("operation close failed" + e.toString()));
            returnvalue = false;
        }
        return returnvalue;
    }

    public final void onAuthenticationFailure(byte[] userName) {
    }

    public static final String createSelectionPara(int type) {
        String selection = null;
        switch (type) {
            case 2: {
                selection = "type=1";
                break;
            }
            case 3: {
                selection = "type=2";
                break;
            }
            case 4: {
                selection = "type=3";
                break;
            }
        }
        return selection;
    }

    public static final void logHeader(HeaderSet hs) {
        Log.v((String)TAG, (String)("Dumping HeaderSet " + hs.toString()));
        try {
            Log.v((String)TAG, (String)("COUNT : " + hs.getHeader(192)));
            Log.v((String)TAG, (String)("NAME : " + hs.getHeader(1)));
            Log.v((String)TAG, (String)("TYPE : " + hs.getHeader(66)));
            Log.v((String)TAG, (String)("LENGTH : " + hs.getHeader(195)));
            Log.v((String)TAG, (String)("TIME_ISO_8601 : " + hs.getHeader(68)));
            Log.v((String)TAG, (String)("TIME_4_BYTE : " + hs.getHeader(196)));
            Log.v((String)TAG, (String)("DESCRIPTION : " + hs.getHeader(5)));
            Log.v((String)TAG, (String)("TARGET : " + hs.getHeader(70)));
            Log.v((String)TAG, (String)("HTTP : " + hs.getHeader(71)));
            Log.v((String)TAG, (String)("WHO : " + hs.getHeader(74)));
            Log.v((String)TAG, (String)("OBJECT_CLASS : " + hs.getHeader(79)));
            Log.v((String)TAG, (String)("APPLICATION_PARAMETER : " + hs.getHeader(76)));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("dump HeaderSet error " + e));
        }
    }

    private class AppParamValue {
        public int maxListCount = 65535;
        public int listStartOffset = 0;
        public String searchValue = "";
        public String searchAttr = "";
        public String order = "";
        public int needTag = 0;
        public boolean vcard21 = true;

        public void dump() {
            Log.i((String)BluetoothPbapObexServer.TAG, (String)("maxListCount=" + this.maxListCount + " listStartOffset=" + this.listStartOffset + " searchValue=" + this.searchValue + " searchAttr=" + this.searchAttr + " needTag=" + this.needTag + " vcard21=" + this.vcard21 + " order=" + this.order));
        }
    }

    public static class ContentType {
        public static final int PHONEBOOK = 1;
        public static final int INCOMING_CALL_HISTORY = 2;
        public static final int OUTGOING_CALL_HISTORY = 3;
        public static final int MISSED_CALL_HISTORY = 4;
        public static final int COMBINED_CALL_HISTORY = 5;
    }
}

