/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.pbap;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.pim.vcard.VCardBuilder;
import android.pim.vcard.VCardComposer;
import android.pim.vcard.VCardUtils;
import android.provider.CallLog;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BluetoothPbapCallLogComposer {
    private static final String TAG = "CallLogComposer";
    private static final String FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO = "Failed to get database information";
    private static final String FAILURE_REASON_NO_ENTRY = "There's no exportable in the database";
    private static final String FAILURE_REASON_NOT_INITIALIZED = "The vCard composer object is not correctly initialized";
    private static final String FAILURE_REASON_UNSUPPORTED_URI = "The Uri vCard composer received is not supported by the composer.";
    private static final String NO_ERROR = "No error";
    private static final String[] sCallLogProjection = new String[]{"number", "date", "type", "name", "numbertype", "numberlabel"};
    private static final int NUMBER_COLUMN_INDEX = 0;
    private static final int DATE_COLUMN_INDEX = 1;
    private static final int CALL_TYPE_COLUMN_INDEX = 2;
    private static final int CALLER_NAME_COLUMN_INDEX = 3;
    private static final int CALLER_NUMBERTYPE_COLUMN_INDEX = 4;
    private static final int CALLER_NUMBERLABEL_COLUMN_INDEX = 5;
    private static final String VCARD_PROPERTY_X_TIMESTAMP = "X-IRMC-CALL-DATETIME";
    private static final String VCARD_PROPERTY_CALLTYPE_INCOMING = "RECEIVED";
    private static final String VCARD_PROPERTY_CALLTYPE_OUTGOING = "DIALED";
    private static final String VCARD_PROPERTY_CALLTYPE_MISSED = "MISSED";
    private static final String FLAG_TIMEZONE_UTC = "Z";
    private final Context mContext;
    private ContentResolver mContentResolver;
    private Cursor mCursor;
    private final boolean mCareHandlerErrors;
    private boolean mTerminateIsCalled;
    private final List<VCardComposer.OneEntryHandler> mHandlerList;
    private String mErrorReason = "No error";

    public BluetoothPbapCallLogComposer(Context context, boolean careHandlerErrors) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mCareHandlerErrors = careHandlerErrors;
        this.mHandlerList = new ArrayList<VCardComposer.OneEntryHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Uri contentUri, String selection, String[] selectionArgs, String sortOrder) {
        if (!CallLog.Calls.CONTENT_URI.equals((Object)contentUri)) {
            this.mErrorReason = FAILURE_REASON_UNSUPPORTED_URI;
            return false;
        }
        String[] projection = sCallLogProjection;
        this.mCursor = this.mContentResolver.query(contentUri, projection, selection, selectionArgs, sortOrder);
        if (this.mCursor == null) {
            this.mErrorReason = FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO;
            return false;
        }
        if (this.mCareHandlerErrors) {
            ArrayList finishedList = new ArrayList(this.mHandlerList.size());
            for (VCardComposer.OneEntryHandler handler : this.mHandlerList) {
                if (handler.onInit(this.mContext)) continue;
                for (VCardComposer.OneEntryHandler finished : finishedList) {
                    finished.onTerminate();
                }
                return false;
            }
        } else {
            for (VCardComposer.OneEntryHandler handler : this.mHandlerList) {
                handler.onInit(this.mContext);
            }
        }
        if (this.mCursor.getCount() == 0 || !this.mCursor.moveToFirst()) {
            try {
                try {
                    this.mCursor.close();
                }
                catch (SQLiteException e) {
                    Log.e((String)TAG, (String)("SQLiteException on Cursor#close(): " + e.getMessage()));
                    Object var12_14 = null;
                    this.mErrorReason = FAILURE_REASON_NO_ENTRY;
                    this.mCursor = null;
                }
                Object var12_13 = null;
                this.mErrorReason = FAILURE_REASON_NO_ENTRY;
                this.mCursor = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                this.mErrorReason = FAILURE_REASON_NO_ENTRY;
                this.mCursor = null;
                throw throwable;
            }
            return false;
        }
        return true;
    }

    public void addHandler(VCardComposer.OneEntryHandler handler) {
        if (handler != null) {
            this.mHandlerList.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createOneEntry() {
        String vcard;
        if (this.mCursor == null || this.mCursor.isAfterLast()) {
            this.mErrorReason = FAILURE_REASON_NOT_INITIALIZED;
            return false;
        }
        try {
            try {
                vcard = this.createOneCallLogEntryInternal();
            }
            catch (OutOfMemoryError error) {
                Log.e((String)TAG, (String)"OutOfMemoryError occured. Ignore the entry");
                System.gc();
                boolean bl = true;
                Object var5_3 = null;
                this.mCursor.moveToNext();
                return bl;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.mCursor.moveToNext();
            throw throwable;
        }
        this.mCursor.moveToNext();
        if (this.mCareHandlerErrors) {
            ArrayList finishedList = new ArrayList(this.mHandlerList.size());
            for (VCardComposer.OneEntryHandler handler : this.mHandlerList) {
                if (handler.onEntryCreated(vcard)) continue;
                return false;
            }
        } else {
            for (VCardComposer.OneEntryHandler handler : this.mHandlerList) {
                handler.onEntryCreated(vcard);
            }
        }
        return true;
    }

    private String createOneCallLogEntryInternal() {
        int vcardType = -1040187392;
        VCardBuilder builder = new VCardBuilder(-1040187392);
        String name = this.mCursor.getString(3);
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = this.mCursor.getString(0);
        }
        boolean needCharset = !VCardUtils.containsOnlyPrintableAscii((String[])new String[]{name});
        builder.appendLine("FN", name, needCharset, false);
        builder.appendLine("N", name, needCharset, false);
        String number = this.mCursor.getString(0);
        if (number.equals("-1")) {
            number = this.mContext.getString(2130968580);
        }
        int type = this.mCursor.getInt(4);
        String label = this.mCursor.getString(5);
        if (TextUtils.isEmpty((CharSequence)label)) {
            label = Integer.toString(type);
        }
        builder.appendTelLine(Integer.valueOf(type), label, number, false);
        this.tryAppendCallHistoryTimeStampField(builder);
        return builder.toString();
    }

    public String composeVCardForPhoneOwnNumber(int phonetype, String phoneName, String phoneNumber, boolean vcardVer21) {
        int vcardType = (vcardVer21 ? -1073741824 : -1073741823) | 0x2000000;
        VCardBuilder builder = new VCardBuilder(vcardType);
        boolean needCharset = false;
        if (!VCardUtils.containsOnlyPrintableAscii((String[])new String[]{phoneName})) {
            needCharset = true;
        }
        builder.appendLine("FN", phoneName, needCharset, false);
        builder.appendLine("N", phoneName, needCharset, false);
        if (!TextUtils.isEmpty((CharSequence)phoneNumber)) {
            String label = Integer.toString(phonetype);
            builder.appendTelLine(Integer.valueOf(phonetype), label, phoneNumber, false);
        }
        return builder.toString();
    }

    private final String toRfc2455Format(long millSecs) {
        Time startDate = new Time();
        startDate.set(millSecs);
        String date = startDate.format2445();
        return date + FLAG_TIMEZONE_UTC;
    }

    private void tryAppendCallHistoryTimeStampField(VCardBuilder builder) {
        String callLogTypeStr;
        int callLogType = this.mCursor.getInt(2);
        switch (callLogType) {
            case 1: {
                callLogTypeStr = VCARD_PROPERTY_CALLTYPE_INCOMING;
                break;
            }
            case 2: {
                callLogTypeStr = VCARD_PROPERTY_CALLTYPE_OUTGOING;
                break;
            }
            case 3: {
                callLogTypeStr = VCARD_PROPERTY_CALLTYPE_MISSED;
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Call log type not correct.");
                return;
            }
        }
        long dateAsLong = this.mCursor.getLong(1);
        builder.appendLine(VCARD_PROPERTY_X_TIMESTAMP, Arrays.asList(callLogTypeStr), this.toRfc2455Format(dateAsLong));
    }

    public void terminate() {
        for (VCardComposer.OneEntryHandler handler : this.mHandlerList) {
            handler.onTerminate();
        }
        if (this.mCursor != null) {
            try {
                this.mCursor.close();
            }
            catch (SQLiteException e) {
                Log.e((String)TAG, (String)("SQLiteException on Cursor#close(): " + e.getMessage()));
            }
            this.mCursor = null;
        }
        this.mTerminateIsCalled = true;
    }

    public void finalize() {
        if (!this.mTerminateIsCalled) {
            this.terminate();
        }
    }

    public int getCount() {
        if (this.mCursor == null) {
            return 0;
        }
        return this.mCursor.getCount();
    }

    public boolean isAfterLast() {
        if (this.mCursor == null) {
            return false;
        }
        return this.mCursor.isAfterLast();
    }

    public String getErrorReason() {
        return this.mErrorReason;
    }
}

