/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.pbap;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import javax.obex.Authenticator;
import javax.obex.PasswordAuthentication;

public class BluetoothPbapAuthenticator
implements Authenticator {
    private static final String TAG = "BluetoothPbapAuthenticator";
    private boolean mChallenged;
    private boolean mAuthCancelled;
    private String mSessionKey;
    private Handler mCallback;

    public BluetoothPbapAuthenticator(Handler callback) {
        this.mCallback = callback;
        this.mChallenged = false;
        this.mAuthCancelled = false;
        this.mSessionKey = null;
    }

    public final synchronized void setChallenged(boolean bool) {
        this.mChallenged = bool;
    }

    public final synchronized void setCancelled(boolean bool) {
        this.mAuthCancelled = bool;
    }

    public final synchronized void setSessionKey(String string2) {
        this.mSessionKey = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUserConfirmation() {
        Message msg = Message.obtain((Handler)this.mCallback);
        msg.what = 5003;
        msg.sendToTarget();
        BluetoothPbapAuthenticator bluetoothPbapAuthenticator = this;
        synchronized (bluetoothPbapAuthenticator) {
            while (!this.mChallenged && !this.mAuthCancelled) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"Interrupted while waiting on isChalled");
                }
            }
        }
    }

    public PasswordAuthentication onAuthenticationChallenge(String description, boolean isUserIdRequired, boolean isFullAccess) {
        this.waitUserConfirmation();
        if (this.mSessionKey.trim().length() != 0) {
            PasswordAuthentication pa = new PasswordAuthentication(null, this.mSessionKey.getBytes());
            return pa;
        }
        return null;
    }

    public byte[] onAuthenticationResponse(byte[] userName) {
        byte[] b = null;
        return b;
    }
}

