/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.pbap;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.Preference;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.TextView;
import com.android.bluetooth.pbap.BluetoothPbapReceiver;
import com.android.bluetooth.pbap.BluetoothPbapService;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class BluetoothPbapActivity
extends AlertActivity
implements DialogInterface.OnClickListener,
Preference.OnPreferenceChangeListener,
TextWatcher {
    private static final String TAG = "BluetoothPbapActivity";
    private static final boolean V = false;
    private static final int BLUETOOTH_OBEX_AUTHKEY_MAX_LENGTH = 16;
    private static final int DIALOG_YES_NO_CONNECT = 1;
    private static final int DIALOG_YES_NO_AUTH = 2;
    private static final String KEY_USER_TIMEOUT = "user_timeout";
    private View mView;
    private EditText mKeyView;
    private TextView messageView;
    private String mSessionKey = "";
    private int mCurrentDialog;
    private Button mOkButton;
    private CheckBox mAlwaysAllowed;
    private boolean mTimeout = false;
    private boolean mAlwaysAllowedValue = true;
    private static final int DISMISS_TIMEOUT_DIALOG = 0;
    private static final int DISMISS_TIMEOUT_DIALOG_VALUE = 2000;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!"com.android.bluetooth.pbap.userconfirmtimeout".equals(intent.getAction())) {
                return;
            }
            BluetoothPbapActivity.this.onTimeout();
        }
    };
    private final Handler mTimeoutHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BluetoothPbapActivity.this.finish();
                    break;
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent i = this.getIntent();
        String action = i.getAction();
        if (action.equals("com.android.bluetooth.pbap.accessrequest")) {
            this.showPbapDialog(1);
            this.mCurrentDialog = 1;
        } else if (action.equals("com.android.bluetooth.pbap.authchall")) {
            this.showPbapDialog(2);
            this.mCurrentDialog = 2;
        } else {
            Log.e((String)TAG, (String)"Error: this activity may be started only with intent PBAP_ACCESS_REQUEST or PBAP_AUTH_CHALL ");
            this.finish();
        }
        this.registerReceiver(this.mReceiver, new IntentFilter("com.android.bluetooth.pbap.userconfirmtimeout"));
    }

    private void showPbapDialog(int id2) {
        AlertController.AlertParams p = this.mAlertParams;
        switch (id2) {
            case 1: {
                p.mIconId = 17301659;
                p.mTitle = this.getString(2130968672);
                p.mView = this.createView(1);
                p.mPositiveButtonText = this.getString(17039379);
                p.mPositiveButtonListener = this;
                p.mNegativeButtonText = this.getString(17039369);
                p.mNegativeButtonListener = this;
                this.mOkButton = this.mAlert.getButton(-1);
                this.setupAlert();
                break;
            }
            case 2: {
                p.mIconId = 17301659;
                p.mTitle = this.getString(2130968674);
                p.mView = this.createView(2);
                p.mPositiveButtonText = this.getString(17039370);
                p.mPositiveButtonListener = this;
                p.mNegativeButtonText = this.getString(0x1040000);
                p.mNegativeButtonListener = this;
                this.setupAlert();
                this.mOkButton = this.mAlert.getButton(-1);
                this.mOkButton.setEnabled(false);
                break;
            }
        }
    }

    private String createDisplayText(int id2) {
        String mRemoteName = BluetoothPbapService.getRemoteDeviceName();
        switch (id2) {
            case 1: {
                String mMessage1 = this.getString(2130968671, new Object[]{mRemoteName, mRemoteName});
                return mMessage1;
            }
            case 2: {
                String mMessage2 = this.getString(2130968673, new Object[]{mRemoteName});
                return mMessage2;
            }
        }
        return null;
    }

    private View createView(int id2) {
        switch (id2) {
            case 1: {
                this.mView = this.getLayoutInflater().inflate(2130903040, null);
                this.messageView = (TextView)this.mView.findViewById(2131099648);
                this.messageView.setText((CharSequence)this.createDisplayText(id2));
                this.mAlwaysAllowed = (CheckBox)this.mView.findViewById(2131099649);
                this.mAlwaysAllowed.setChecked(true);
                this.mAlwaysAllowed.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        if (isChecked) {
                            BluetoothPbapActivity.this.mAlwaysAllowedValue = true;
                        } else {
                            BluetoothPbapActivity.this.mAlwaysAllowedValue = false;
                        }
                    }
                });
                return this.mView;
            }
            case 2: {
                this.mView = this.getLayoutInflater().inflate(2130903041, null);
                this.messageView = (TextView)this.mView.findViewById(2131099648);
                this.messageView.setText((CharSequence)this.createDisplayText(id2));
                this.mKeyView = (EditText)this.mView.findViewById(2131099650);
                this.mKeyView.addTextChangedListener((TextWatcher)this);
                this.mKeyView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(16)});
                return this.mView;
            }
        }
        return null;
    }

    private void onPositive() {
        if (!this.mTimeout) {
            if (this.mCurrentDialog == 1) {
                this.sendIntentToReceiver("com.android.bluetooth.pbap.accessallowed", "com.android.bluetooth.pbap.alwaysallowed", this.mAlwaysAllowedValue);
            } else if (this.mCurrentDialog == 2) {
                this.sendIntentToReceiver("com.android.bluetooth.pbap.authresponse", "com.android.bluetooth.pbap.sessionkey", this.mSessionKey);
                this.mKeyView.removeTextChangedListener((TextWatcher)this);
            }
        }
        this.mTimeout = false;
        this.finish();
    }

    private void onNegative() {
        if (this.mCurrentDialog == 1) {
            this.sendIntentToReceiver("com.android.bluetooth.pbap.accessdisallowed", null, null);
        } else if (this.mCurrentDialog == 2) {
            this.sendIntentToReceiver("com.android.bluetooth.pbap.authcancelled", null, null);
            this.mKeyView.removeTextChangedListener((TextWatcher)this);
        }
        this.finish();
    }

    private void sendIntentToReceiver(String intentName, String extraName, String extraValue) {
        Intent intent = new Intent(intentName);
        intent.setClassName("com.android.bluetooth", BluetoothPbapReceiver.class.getName());
        if (extraName != null) {
            intent.putExtra(extraName, extraValue);
        }
        this.sendBroadcast(intent);
    }

    private void sendIntentToReceiver(String intentName, String extraName, boolean extraValue) {
        Intent intent = new Intent(intentName);
        intent.setClassName("com.android.bluetooth", BluetoothPbapReceiver.class.getName());
        if (extraName != null) {
            intent.putExtra(extraName, extraValue);
        }
        this.sendBroadcast(intent);
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mCurrentDialog == 2) {
                    this.mSessionKey = this.mKeyView.getText().toString();
                }
                this.onPositive();
                break;
            }
            case -2: {
                this.onNegative();
                break;
            }
        }
    }

    private void onTimeout() {
        this.mTimeout = true;
        if (this.mCurrentDialog == 1) {
            this.messageView.setText((CharSequence)this.getString(2130968675, new Object[]{BluetoothPbapService.getRemoteDeviceName()}));
            this.mAlert.getButton(-2).setVisibility(8);
            this.mAlwaysAllowed.setVisibility(8);
            this.mAlwaysAllowed.clearFocus();
        } else if (this.mCurrentDialog == 2) {
            this.messageView.setText((CharSequence)this.getString(2130968676, new Object[]{BluetoothPbapService.getRemoteDeviceName()}));
            this.mKeyView.setVisibility(8);
            this.mKeyView.clearFocus();
            this.mKeyView.removeTextChangedListener((TextWatcher)this);
            this.mOkButton.setEnabled(true);
            this.mAlert.getButton(-2).setVisibility(8);
        }
        this.mTimeoutHandler.sendMessageDelayed(this.mTimeoutHandler.obtainMessage(0), 2000L);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.mTimeout = savedInstanceState.getBoolean(KEY_USER_TIMEOUT);
        if (this.mTimeout) {
            this.onTimeout();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_USER_TIMEOUT, this.mTimeout);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mReceiver);
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        return true;
    }

    public void beforeTextChanged(CharSequence s, int start, int before, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        if (s.length() > 0) {
            this.mOkButton.setEnabled(true);
        }
    }
}

