/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.util.Log;
import com.android.bluetooth.opp.TestTcpSessionNotifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.obex.HeaderSet;
import javax.obex.Operation;
import javax.obex.ServerRequestHandler;

class TestTcpServer
extends ServerRequestHandler
implements Runnable {
    private static final String TAG = "ServerRequestHandler";
    private static final boolean D = false;
    private static final boolean V = false;
    static final int port = 6500;
    public boolean a = false;

    public void run() {
        try {
            this.updateStatus("[server:] listen on port 6500");
            TestTcpSessionNotifier rsn = new TestTcpSessionNotifier(6500);
            this.updateStatus("[server:] Now waiting for a client to connect");
            rsn.acceptAndOpen(this);
            this.updateStatus("[server:] A client is now connected");
        }
        catch (Exception ex) {
            this.updateStatus("[server:] Caught the error: " + ex);
        }
    }

    public TestTcpServer() {
        this.updateStatus("enter construtor of TcpServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onConnect(HeaderSet request, HeaderSet reply) {
        this.updateStatus("[server:] The client has created an OBEX session");
        TestTcpServer testTcpServer = this;
        synchronized (testTcpServer) {
            try {
                while (!this.a) {
                    this.wait(500L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.updateStatus("[server:] we accpet the seesion");
        return 160;
    }

    public int onPut(Operation op) {
        FileOutputStream fos = null;
        try {
            int len;
            InputStream is = op.openInputStream();
            this.updateStatus("Got data bytes " + is.available() + " name " + op.getReceivedHeader().getHeader(1) + " type " + op.getType());
            File f = new File((String)op.getReceivedHeader().getHeader(1));
            fos = new FileOutputStream(f);
            byte[] b = new byte[1000];
            while (is.available() > 0 && (len = is.read(b)) > 0) {
                fos.write(b, 0, len);
            }
            fos.close();
            is.close();
            this.updateStatus("[server:] Wrote data to " + f.getAbsolutePath());
        }
        catch (Exception e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
        }
        return 160;
    }

    public void onDisconnect(HeaderSet req, HeaderSet resp) {
        this.updateStatus("[server:] The client has disconnected the OBEX session");
    }

    public void updateStatus(String message) {
        Log.v((String)TAG, (String)("\n" + message));
    }

    public void onAuthenticationFailure(byte[] userName) {
    }

    public int onSetPath(HeaderSet request, HeaderSet reply, boolean backup, boolean create) {
        return 209;
    }

    public int onDelete(HeaderSet request, HeaderSet reply) {
        return 209;
    }

    public int onGet(Operation op) {
        return 209;
    }
}

