/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.bluetooth.opp.TestTcpTransport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

class TestTcpListener {
    private static final String TAG = "BtOppRfcommListener";
    private static final boolean D = false;
    private static final boolean V = false;
    private volatile boolean mInterrupted;
    private Thread mSocketAcceptThread;
    private Handler mCallback;
    private static final int ACCEPT_WAIT_TIMEOUT = 5000;
    public static final int DEFAULT_OPP_CHANNEL = 12;
    public static final int MSG_INCOMING_BTOPP_CONNECTION = 100;
    private int mBtOppRfcommChannel = -1;

    public TestTcpListener() {
        this(12);
    }

    public TestTcpListener(int channel) {
        this.mBtOppRfcommChannel = channel;
    }

    public synchronized boolean start(Handler callback) {
        if (this.mSocketAcceptThread == null) {
            this.mCallback = callback;
            this.mSocketAcceptThread = new Thread(TAG){
                ServerSocket mServerSocket;

                public void run() {
                    try {
                        this.mServerSocket = new ServerSocket(6500, 1);
                    }
                    catch (IOException e) {
                        Log.e((String)TestTcpListener.TAG, (String)("Error listing on channel" + TestTcpListener.this.mBtOppRfcommChannel));
                        TestTcpListener.this.mInterrupted = true;
                    }
                    while (!TestTcpListener.this.mInterrupted) {
                        try {
                            this.mServerSocket.setSoTimeout(5000);
                            Socket clientSocket = this.mServerSocket.accept();
                            if (clientSocket != null) {
                                Log.d((String)TestTcpListener.TAG, (String)("remote addr is " + clientSocket.getRemoteSocketAddress()));
                                TestTcpTransport transport = new TestTcpTransport(clientSocket);
                                Message msg = Message.obtain();
                                msg.setTarget(TestTcpListener.this.mCallback);
                                msg.what = 100;
                                msg.obj = transport;
                                msg.sendToTarget();
                            }
                        }
                        catch (SocketException e) {
                            Log.e((String)TestTcpListener.TAG, (String)("Error accept connection " + e));
                        }
                        catch (IOException e) {
                            Log.e((String)TestTcpListener.TAG, (String)("Error accept connection " + e));
                        }
                        if (!TestTcpListener.this.mInterrupted) continue;
                        Log.e((String)TestTcpListener.TAG, (String)"socketAcceptThread thread was interrupted (2), exiting");
                    }
                }
            };
            this.mInterrupted = false;
            this.mSocketAcceptThread.start();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.mSocketAcceptThread != null) {
            this.mInterrupted = true;
            try {
                this.mSocketAcceptThread.interrupt();
                this.mSocketAcceptThread.join();
                this.mSocketAcceptThread = null;
                this.mCallback = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

