/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.android.bluetooth.opp.BluetoothShare;
import com.android.bluetooth.opp.TestTcpServer;

public class TestActivity
extends Activity {
    public String currentInsert;
    public int mCurrentByte = 0;
    EditText mUpdateView;
    EditText mAckView;
    EditText mDeleteView;
    EditText mInsertView;
    EditText mAddressView;
    EditText mMediaView;
    TestTcpServer server;
    public View.OnClickListener insertRecordListener = new View.OnClickListener(){

        public void onClick(View view) {
            String address = null;
            if (TestActivity.this.mAddressView.getText().length() != 0) {
                address = TestActivity.this.mAddressView.getText().toString();
                Log.v((String)"BluetoothOpp", (String)("Send to address  " + address));
            }
            if (address == null) {
                address = "00:17:83:58:5D:CC";
            }
            Integer media = null;
            if (TestActivity.this.mMediaView.getText().length() != 0) {
                media = Integer.parseInt(TestActivity.this.mMediaView.getText().toString().trim());
                Log.v((String)"BluetoothOpp", (String)("Send media no.  " + media));
            }
            if (media == null) {
                media = 1;
            }
            ContentValues values = new ContentValues();
            values.put("uri", "content://media/external/images/media/" + media);
            values.put("destination", address);
            values.put("direction", Integer.valueOf(0));
            Long ts = System.currentTimeMillis();
            values.put("timestamp", ts);
            Integer records = null;
            if (TestActivity.this.mInsertView.getText().length() != 0) {
                records = Integer.parseInt(TestActivity.this.mInsertView.getText().toString().trim());
                Log.v((String)"BluetoothOpp", (String)("parseInt  " + records));
            }
            if (records == null) {
                records = 1;
            }
            for (int i = 0; i < records; ++i) {
                Uri contentUri = TestActivity.this.getContentResolver().insert(BluetoothShare.CONTENT_URI, values);
                Log.v((String)"BluetoothOpp", (String)("insert contentUri: " + contentUri));
                TestActivity.this.currentInsert = (String)contentUri.getPathSegments().get(1);
                Log.v((String)"BluetoothOpp", (String)("currentInsert = " + TestActivity.this.currentInsert));
            }
        }
    };
    public View.OnClickListener deleteRecordListener = new View.OnClickListener(){

        public void onClick(View view) {
            Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + TestActivity.this.mDeleteView.getText().toString()));
            TestActivity.this.getContentResolver().delete(contentUri, null, null);
        }
    };
    public View.OnClickListener updateRecordListener = new View.OnClickListener(){

        public void onClick(View view) {
            Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + TestActivity.this.mUpdateView.getText().toString()));
            ContentValues updateValues = new ContentValues();
            updateValues.put("confirm", Integer.valueOf(1));
            TestActivity.this.getContentResolver().update(contentUri, updateValues, null, null);
        }
    };
    public View.OnClickListener ackRecordListener = new View.OnClickListener(){

        public void onClick(View view) {
            Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + TestActivity.this.mAckView.getText().toString()));
            ContentValues updateValues = new ContentValues();
            updateValues.put("visibility", Integer.valueOf(1));
            TestActivity.this.getContentResolver().update(contentUri, updateValues, null, null);
        }
    };
    public View.OnClickListener deleteAllRecordListener = new View.OnClickListener(){

        public void onClick(View view) {
            Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + ""));
            TestActivity.this.getContentResolver().delete(contentUri, null, null);
        }
    };
    public View.OnClickListener startTcpServerListener = new View.OnClickListener(){

        public void onClick(View view) {
            TestActivity.this.server = new TestTcpServer();
            Thread server_thread = new Thread(TestActivity.this.server);
            server_thread.start();
        }
    };
    public View.OnClickListener notifyTcpServerListener = new View.OnClickListener(){

        public void onClick(View view) {
            Thread notifyThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    TestTcpServer testTcpServer = TestActivity.this.server;
                    synchronized (testTcpServer) {
                        TestActivity.this.server.a = true;
                        TestActivity.this.server.notify();
                    }
                }
            };
            notifyThread.start();
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String action = intent.getAction();
        Context c = this.getBaseContext();
        if ("android.intent.action.SEND".equals(action)) {
            String type = intent.getType();
            Uri stream = (Uri)intent.getParcelableExtra("android.intent.extra.STREAM");
            if (stream != null && type != null) {
                Log.v((String)"BluetoothOpp", (String)(" Get share intent with Uri " + stream + " mimetype is " + type));
                Cursor cursor = c.getContentResolver().query(stream, null, null, null, null);
                cursor.close();
            }
        }
        this.setContentView(2130903049);
        Button mInsertRecord = (Button)this.findViewById(2131099674);
        Button mDeleteRecord = (Button)this.findViewById(2131099676);
        Button mUpdateRecord = (Button)this.findViewById(2131099678);
        Button mAckRecord = (Button)this.findViewById(2131099680);
        Button mDeleteAllRecord = (Button)this.findViewById(2131099681);
        this.mUpdateView = (EditText)this.findViewById(2131099677);
        this.mAckView = (EditText)this.findViewById(2131099679);
        this.mDeleteView = (EditText)this.findViewById(2131099675);
        this.mInsertView = (EditText)this.findViewById(2131099671);
        this.mAddressView = (EditText)this.findViewById(2131099673);
        this.mMediaView = (EditText)this.findViewById(2131099672);
        mInsertRecord.setOnClickListener(this.insertRecordListener);
        mDeleteRecord.setOnClickListener(this.deleteRecordListener);
        mUpdateRecord.setOnClickListener(this.updateRecordListener);
        mAckRecord.setOnClickListener(this.ackRecordListener);
        mDeleteAllRecord.setOnClickListener(this.deleteAllRecordListener);
        Button mStartTcpServer = (Button)this.findViewById(2131099682);
        mStartTcpServer.setOnClickListener(this.startTcpServerListener);
        Button mNotifyTcpServer = (Button)this.findViewById(2131099683);
        mNotifyTcpServer.setOnClickListener(this.notifyTcpServerListener);
    }
}

