/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppReceiver;
import com.android.bluetooth.opp.BluetoothShare;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.obex.HeaderSet;

public class Constants {
    public static final String TAG = "BluetoothOpp";
    public static final String ACTION_RETRY = "android.btopp.intent.action.RETRY";
    public static final String ACTION_OPEN = "android.btopp.intent.action.OPEN";
    public static final String ACTION_OPEN_OUTBOUND_TRANSFER = "android.btopp.intent.action.OPEN_OUTBOUND";
    public static final String ACTION_OPEN_INBOUND_TRANSFER = "android.btopp.intent.action.OPEN_INBOUND";
    public static final String ACTION_LIST = "android.btopp.intent.action.LIST";
    public static final String ACTION_HIDE = "android.btopp.intent.action.HIDE";
    public static final String ACTION_COMPLETE_HIDE = "android.btopp.intent.action.HIDE_COMPLETE";
    public static final String ACTION_INCOMING_FILE_CONFIRM = "android.btopp.intent.action.CONFIRM";
    public static final String THIS_PACKAGE_NAME = "com.android.bluetooth";
    public static final String MEDIA_SCANNED = "scanned";
    public static final int MEDIA_SCANNED_NOT_SCANNED = 0;
    public static final int MEDIA_SCANNED_SCANNED_OK = 1;
    public static final int MEDIA_SCANNED_SCANNED_FAILED = 2;
    public static final String[] ACCEPTABLE_SHARE_OUTBOUND_TYPES = new String[]{"image/*", "text/x-vcard"};
    public static final String[] UNACCEPTABLE_SHARE_OUTBOUND_TYPES = new String[]{"virus/*"};
    public static final String[] ACCEPTABLE_SHARE_INBOUND_TYPES = new String[]{"image/*", "video/*", "audio/*", "text/x-vcard", "text/plain", "text/html", "application/zip", "application/vnd.ms-excel", "application/msword", "application/vnd.ms-powerpoint", "application/pdf"};
    public static final String[] UNACCEPTABLE_SHARE_INBOUND_TYPES = new String[]{"text/x-vcalendar"};
    public static final String DEFAULT_STORE_SUBDIR = "/bluetooth";
    public static final boolean DEBUG = false;
    public static final boolean VERBOSE = false;
    public static final boolean USE_TCP_DEBUG = false;
    public static final boolean USE_TCP_SIMPLE_SERVER = false;
    public static final int TCP_DEBUG_PORT = 6500;
    public static final boolean USE_EMULATOR_DEBUG = false;
    public static final int MAX_RECORDS_IN_DATABASE = 1000;
    public static final int BATCH_STATUS_PENDING = 0;
    public static final int BATCH_STATUS_RUNNING = 1;
    public static final int BATCH_STATUS_FINISHED = 2;
    public static final int BATCH_STATUS_FAILED = 3;
    public static final String BLUETOOTHOPP_NAME_PREFERENCE = "btopp_names";
    public static final String BLUETOOTHOPP_CHANNEL_PREFERENCE = "btopp_channels";
    public static String filename_SEQUENCE_SEPARATOR = "-";

    public static void updateShareStatus(Context context, int id2, int status) {
        Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + id2));
        ContentValues updateValues = new ContentValues();
        updateValues.put("status", Integer.valueOf(status));
        context.getContentResolver().update(contentUri, updateValues, null, null);
        Constants.sendIntentIfCompleted(context, contentUri, status);
    }

    public static void sendIntentIfCompleted(Context context, Uri contentUri, int status) {
        if (BluetoothShare.isStatusCompleted(status)) {
            Intent intent = new Intent("android.btopp.intent.action.TRANSFER_COMPLETE");
            intent.setClassName(THIS_PACKAGE_NAME, BluetoothOppReceiver.class.getName());
            intent.setData(contentUri);
            context.sendBroadcast(intent);
        }
    }

    public static boolean mimeTypeMatches(String mimeType, String[] matchAgainst) {
        for (String matchType : matchAgainst) {
            if (!Constants.mimeTypeMatches(mimeType, matchType)) continue;
            return true;
        }
        return false;
    }

    public static boolean mimeTypeMatches(String mimeType, String matchAgainst) {
        Pattern p = Pattern.compile(matchAgainst.replaceAll("\\*", "\\.\\*"), 2);
        return p.matcher(mimeType).matches();
    }

    public static void logHeader(HeaderSet hs) {
        Log.v((String)TAG, (String)("Dumping HeaderSet " + hs.toString()));
        try {
            Log.v((String)TAG, (String)("COUNT : " + hs.getHeader(192)));
            Log.v((String)TAG, (String)("NAME : " + hs.getHeader(1)));
            Log.v((String)TAG, (String)("TYPE : " + hs.getHeader(66)));
            Log.v((String)TAG, (String)("LENGTH : " + hs.getHeader(195)));
            Log.v((String)TAG, (String)("TIME_ISO_8601 : " + hs.getHeader(68)));
            Log.v((String)TAG, (String)("TIME_4_BYTE : " + hs.getHeader(196)));
            Log.v((String)TAG, (String)("DESCRIPTION : " + hs.getHeader(5)));
            Log.v((String)TAG, (String)("TARGET : " + hs.getHeader(70)));
            Log.v((String)TAG, (String)("HTTP : " + hs.getHeader(71)));
            Log.v((String)TAG, (String)("WHO : " + hs.getHeader(74)));
            Log.v((String)TAG, (String)("OBJECT_CLASS : " + hs.getHeader(79)));
            Log.v((String)TAG, (String)("APPLICATION_PARAMETER : " + hs.getHeader(76)));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("dump HeaderSet error " + e));
        }
    }
}

