/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppBtErrorActivity;
import com.android.bluetooth.opp.BluetoothOppManager;
import com.android.bluetooth.opp.BluetoothOppTransferInfo;
import com.android.bluetooth.opp.BluetoothShare;
import com.google.android.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothOppUtility {
    private static final String TAG = "BluetoothOppUtility";
    private static final boolean D = false;
    private static final boolean V = false;

    public static BluetoothOppTransferInfo queryRecord(Context context, Uri uri) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        BluetoothOppTransferInfo info = new BluetoothOppTransferInfo();
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                Uri u;
                info.mID = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                info.mStatus = cursor.getInt(cursor.getColumnIndexOrThrow("status"));
                info.mDirection = cursor.getInt(cursor.getColumnIndexOrThrow("direction"));
                info.mTotalBytes = cursor.getInt(cursor.getColumnIndexOrThrow("total_bytes"));
                info.mCurrentBytes = cursor.getInt(cursor.getColumnIndexOrThrow("current_bytes"));
                info.mTimeStamp = cursor.getLong(cursor.getColumnIndexOrThrow("timestamp"));
                info.mDestAddr = cursor.getString(cursor.getColumnIndexOrThrow("destination"));
                info.mFileName = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                if (info.mFileName == null) {
                    info.mFileName = cursor.getString(cursor.getColumnIndexOrThrow("hint"));
                }
                if (info.mFileName == null) {
                    info.mFileName = context.getString(2130968628);
                }
                info.mFileUri = cursor.getString(cursor.getColumnIndexOrThrow("uri"));
                if (info.mFileUri != null) {
                    u = Uri.parse((String)info.mFileUri);
                    info.mFileType = context.getContentResolver().getType(u);
                } else {
                    u = Uri.parse((String)info.mFileName);
                    info.mFileType = context.getContentResolver().getType(u);
                }
                if (info.mFileType == null) {
                    info.mFileType = cursor.getString(cursor.getColumnIndexOrThrow("mimetype"));
                }
                BluetoothDevice remoteDevice = adapter.getRemoteDevice(info.mDestAddr);
                info.mDeviceName = BluetoothOppManager.getInstance(context).getDeviceName(remoteDevice);
            }
            cursor.close();
        } else {
            info = null;
        }
        return info;
    }

    public static ArrayList<String> queryTransfersInBatch(Context context, Long timeStamp) {
        ArrayList uris = Lists.newArrayList();
        String WHERE = "timestamp == " + timeStamp;
        Cursor metadataCursor = context.getContentResolver().query(BluetoothShare.CONTENT_URI, new String[]{"_data"}, WHERE, null, "_id");
        if (metadataCursor == null) {
            return null;
        }
        metadataCursor.moveToFirst();
        while (!metadataCursor.isAfterLast()) {
            String fileName = metadataCursor.getString(0);
            Uri path = Uri.parse((String)fileName);
            if (path.getScheme() == null) {
                path = Uri.fromFile((File)new File(fileName));
            }
            uris.add(path.toString());
            metadataCursor.moveToNext();
        }
        metadataCursor.close();
        return uris;
    }

    public static void openReceivedFile(Context context, String fileName, String mimetype, Long timeStamp, Uri uri) {
        if (fileName == null || mimetype == null) {
            Log.e((String)TAG, (String)"ERROR: Para fileName ==null, or mimetype == null");
            return;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            Intent in = new Intent(context, BluetoothOppBtErrorActivity.class);
            in.setFlags(0x10000000);
            in.putExtra("title", context.getString(2130968630));
            in.putExtra("content", context.getString(2130968631));
            context.startActivity(in);
            context.getContentResolver().delete(uri, null, null);
            return;
        }
        Uri path = Uri.parse((String)fileName);
        if (path.getScheme() == null) {
            path = Uri.fromFile((File)new File(fileName));
        }
        if (BluetoothOppUtility.isRecognizedFileType(context, path, mimetype)) {
            Intent activityIntent = new Intent("android.intent.action.VIEW");
            activityIntent.setDataAndType(path, mimetype);
            activityIntent.setFlags(0x10000000);
            try {
                context.startActivity(activityIntent);
            }
            catch (ActivityNotFoundException ex) {}
        } else {
            Intent in = new Intent(context, BluetoothOppBtErrorActivity.class);
            in.setFlags(0x10000000);
            in.putExtra("title", context.getString(2130968628));
            in.putExtra("content", context.getString(2130968629));
            context.startActivity(in);
        }
    }

    public static boolean isRecognizedFileType(Context context, Uri fileUri, String mimetype) {
        boolean ret = true;
        Intent mimetypeIntent = new Intent("android.intent.action.VIEW");
        mimetypeIntent.setDataAndType(fileUri, mimetype);
        List list = context.getPackageManager().queryIntentActivities(mimetypeIntent, 65536);
        if (list.size() == 0) {
            ret = false;
        }
        return ret;
    }

    public static void updateVisibilityToHidden(Context context, Uri uri) {
        ContentValues updateValues = new ContentValues();
        updateValues.put("visibility", Integer.valueOf(1));
        context.getContentResolver().update(uri, updateValues, null, null);
    }

    public static String formatProgressText(long totalBytes, long currentBytes) {
        if (totalBytes <= 0L) {
            return "0%";
        }
        long progress = currentBytes * 100L / totalBytes;
        StringBuilder sb = new StringBuilder();
        sb.append(progress);
        sb.append('%');
        return sb.toString();
    }

    public static String getStatusDescription(Context context, int statusCode, String deviceName) {
        String ret = statusCode == 190 ? context.getString(2130968643) : (statusCode == 192 ? context.getString(2130968644) : (statusCode == 200 ? context.getString(2130968645) : (statusCode == 406 ? context.getString(2130968646) : (statusCode == 403 ? context.getString(2130968647) : (statusCode == 490 ? context.getString(2130968648) : (statusCode == 492 ? context.getString(2130968649) : (statusCode == 493 ? context.getString(2130968650) : (statusCode == 497 ? context.getString(2130968651) : (statusCode == 494 ? context.getString(2130968640, new Object[]{deviceName}) : (statusCode == 400 || statusCode == 411 || statusCode == 412 || statusCode == 495 || statusCode == 496 ? context.getString(2130968652) : context.getString(2130968653)))))))))));
        return ret;
    }

    public static void retryTransfer(Context context, BluetoothOppTransferInfo transInfo) {
        ContentValues values = new ContentValues();
        values.put("uri", transInfo.mFileUri);
        values.put("mimetype", transInfo.mFileType);
        values.put("destination", transInfo.mDestAddr);
        Uri contentUri = context.getContentResolver().insert(BluetoothShare.CONTENT_URI, values);
    }
}

