/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.bluetooth.opp.BluetoothOppNotification;
import com.android.bluetooth.opp.BluetoothOppTransferActivity;
import com.android.bluetooth.opp.BluetoothOppTransferAdapter;
import com.android.bluetooth.opp.BluetoothOppTransferInfo;
import com.android.bluetooth.opp.BluetoothOppUtility;
import com.android.bluetooth.opp.BluetoothShare;

public class BluetoothOppTransferHistory
extends Activity
implements View.OnCreateContextMenuListener,
AdapterView.OnItemClickListener {
    private static final String TAG = "BluetoothOppTransferHistory";
    private static final boolean D = false;
    private static final boolean V = false;
    private ListView mListView;
    private Cursor mTransferCursor;
    private BluetoothOppTransferAdapter mTransferAdapter;
    private int mIdColumnId;
    private int mContextMenuPosition;
    private BluetoothOppNotification mNotifier;

    public void onCreate(Bundle icicle) {
        String direction;
        super.onCreate(icicle);
        this.setContentView(2130903043);
        this.mListView = (ListView)this.findViewById(2131099656);
        this.mListView.setEmptyView(this.findViewById(2131099657));
        int dir = this.getIntent().getIntExtra("direction", 0);
        if (dir == 0) {
            this.setTitle(this.getText(2130968658));
            direction = "(direction == 0)";
        } else {
            this.setTitle(this.getText(2130968657));
            direction = "(direction == 1)";
        }
        String selection = "status >= '200' AND (visibility IS NULL OR visibility == '0') AND " + direction;
        String sortOrder = "timestamp DESC";
        this.mTransferCursor = this.managedQuery(BluetoothShare.CONTENT_URI, new String[]{"_id", "hint", "status", "total_bytes", "_data", "timestamp", "visibility", "destination", "direction"}, selection, "timestamp DESC");
        if (this.mTransferCursor != null) {
            this.mIdColumnId = this.mTransferCursor.getColumnIndexOrThrow("_id");
            this.mTransferAdapter = new BluetoothOppTransferAdapter((Context)this, 2130903042, this.mTransferCursor);
            this.mListView.setAdapter((ListAdapter)this.mTransferAdapter);
            this.mListView.setScrollBarStyle(0x1000000);
            this.mListView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
            this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        }
        this.mNotifier = new BluetoothOppNotification((Context)this);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.mTransferCursor != null) {
            MenuInflater inflater = this.getMenuInflater();
            inflater.inflate(2131034112, menu2);
        }
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        boolean showClear = this.getClearableCount() > 0;
        menu2.findItem(2131099684).setEnabled(showClear);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131099684: {
                this.promptClearList();
                return true;
            }
        }
        return false;
    }

    public boolean onContextItemSelected(MenuItem item) {
        this.mTransferCursor.moveToPosition(this.mContextMenuPosition);
        switch (item.getItemId()) {
            case 2131099685: {
                this.openCompleteTransfer();
                this.updateNotificationWhenBtDisabled();
                return true;
            }
            case 2131099686: {
                int sessionId = this.mTransferCursor.getInt(this.mIdColumnId);
                Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + sessionId));
                BluetoothOppUtility.updateVisibilityToHidden((Context)this, contentUri);
                this.updateNotificationWhenBtDisabled();
                return true;
            }
        }
        return false;
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (this.mTransferCursor != null) {
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
            this.mTransferCursor.moveToPosition(info.position);
            this.mContextMenuPosition = info.position;
            String fileName = this.mTransferCursor.getString(this.mTransferCursor.getColumnIndexOrThrow("hint"));
            if (fileName == null) {
                fileName = this.getString(2130968628);
            }
            menu2.setHeaderTitle((CharSequence)fileName);
            MenuInflater inflater = this.getMenuInflater();
            inflater.inflate(2131034113, (Menu)menu2);
        }
    }

    private void promptClearList() {
        new AlertDialog.Builder((Context)this).setTitle(2130968667).setMessage(2130968660).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                BluetoothOppTransferHistory.this.clearAllDownloads();
            }
        }).setNegativeButton(0x1040000, null).show();
    }

    private int getClearableCount() {
        int count = 0;
        if (this.mTransferCursor.moveToFirst()) {
            while (!this.mTransferCursor.isAfterLast()) {
                int statusColumnId = this.mTransferCursor.getColumnIndexOrThrow("status");
                int status = this.mTransferCursor.getInt(statusColumnId);
                if (BluetoothShare.isStatusCompleted(status)) {
                    ++count;
                }
                this.mTransferCursor.moveToNext();
            }
        }
        return count;
    }

    private void clearAllDownloads() {
        if (this.mTransferCursor.moveToFirst()) {
            while (!this.mTransferCursor.isAfterLast()) {
                int sessionId = this.mTransferCursor.getInt(this.mIdColumnId);
                Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + sessionId));
                BluetoothOppUtility.updateVisibilityToHidden((Context)this, contentUri);
                this.mTransferCursor.moveToNext();
            }
            this.updateNotificationWhenBtDisabled();
        }
    }

    public void onItemClick(AdapterView parent, View view, int position, long id2) {
        this.mTransferCursor.moveToPosition(position);
        this.openCompleteTransfer();
        this.updateNotificationWhenBtDisabled();
    }

    private void openCompleteTransfer() {
        int sessionId = this.mTransferCursor.getInt(this.mIdColumnId);
        Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + sessionId));
        BluetoothOppTransferInfo transInfo = new BluetoothOppTransferInfo();
        transInfo = BluetoothOppUtility.queryRecord((Context)this, contentUri);
        if (transInfo == null) {
            Log.e((String)TAG, (String)"Error: Can not get data from db");
            return;
        }
        if (transInfo.mDirection == 1 && BluetoothShare.isStatusSuccess(transInfo.mStatus)) {
            BluetoothOppUtility.updateVisibilityToHidden((Context)this, contentUri);
            BluetoothOppUtility.openReceivedFile((Context)this, transInfo.mFileName, transInfo.mFileType, transInfo.mTimeStamp, contentUri);
        } else {
            Intent in = new Intent((Context)this, BluetoothOppTransferActivity.class);
            in.setFlags(0x10000000);
            in.setData(contentUri);
            this.startActivity(in);
        }
    }

    private void updateNotificationWhenBtDisabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (!adapter.isEnabled()) {
            this.mNotifier.updateNotification();
        }
    }
}

