/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.format.Formatter;
import android.view.View;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;
import com.android.bluetooth.opp.BluetoothOppManager;
import com.android.bluetooth.opp.BluetoothOppUtility;
import com.android.bluetooth.opp.BluetoothShare;
import java.util.Date;

public class BluetoothOppTransferAdapter
extends ResourceCursorAdapter {
    private Context mContext;

    public BluetoothOppTransferAdapter(Context context, int layout2, Cursor c) {
        super(context, layout2, c);
        this.mContext = context;
    }

    public void bindView(View view, Context context, Cursor cursor) {
        Resources r = context.getResources();
        ImageView iv = (ImageView)view.findViewById(2131099651);
        int status = cursor.getInt(cursor.getColumnIndexOrThrow("status"));
        int dir = cursor.getInt(cursor.getColumnIndexOrThrow("direction"));
        if (BluetoothShare.isStatusError(status)) {
            iv.setImageResource(17301624);
        } else if (dir == 0) {
            iv.setImageResource(17301641);
        } else {
            iv.setImageResource(17301634);
        }
        TextView tv = (TextView)view.findViewById(2131099652);
        String title = cursor.getString(cursor.getColumnIndexOrThrow("hint"));
        if (title == null) {
            title = this.mContext.getString(2130968628);
        }
        tv.setText((CharSequence)title);
        tv = (TextView)view.findViewById(2131099653);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        int destinationColumnId = cursor.getColumnIndexOrThrow("destination");
        BluetoothDevice remoteDevice = adapter.getRemoteDevice(cursor.getString(destinationColumnId));
        String deviceName = BluetoothOppManager.getInstance(context).getDeviceName(remoteDevice);
        tv.setText((CharSequence)deviceName);
        long totalBytes = cursor.getLong(cursor.getColumnIndexOrThrow("total_bytes"));
        if (BluetoothShare.isStatusCompleted(status)) {
            tv = (TextView)view.findViewById(2131099655);
            tv.setVisibility(0);
            if (BluetoothShare.isStatusError(status)) {
                tv.setText((CharSequence)BluetoothOppUtility.getStatusDescription(this.mContext, status, deviceName));
            } else {
                String completeText = dir == 1 ? r.getString(2130968655, new Object[]{Formatter.formatFileSize((Context)this.mContext, (long)totalBytes)}) : r.getString(2130968656, new Object[]{Formatter.formatFileSize((Context)this.mContext, (long)totalBytes)});
                tv.setText((CharSequence)completeText);
            }
            int dateColumnId = cursor.getColumnIndexOrThrow("timestamp");
            long time = cursor.getLong(dateColumnId);
            Date d = new Date(time);
            String str = DateUtils.isToday((long)time) ? DateFormat.getTimeFormat((Context)this.mContext).format(d) : DateFormat.getDateFormat((Context)this.mContext).format(d);
            tv = (TextView)view.findViewById(2131099654);
            tv.setVisibility(0);
            tv.setText((CharSequence)str);
        }
    }
}

