/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.NotificationManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.format.Formatter;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.android.bluetooth.opp.BluetoothOppManager;
import com.android.bluetooth.opp.BluetoothOppTransferInfo;
import com.android.bluetooth.opp.BluetoothOppUtility;
import com.android.bluetooth.opp.BluetoothShare;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class BluetoothOppTransferActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = "BluetoothOppTransferActivity";
    private static final boolean D = false;
    private static final boolean V = false;
    private Uri mUri;
    boolean mIsComplete;
    private BluetoothOppTransferInfo mTransInfo;
    private ProgressBar mProgressTransfer;
    private TextView mPercentView;
    private AlertController.AlertParams mPara;
    private View mView = null;
    private TextView mLine1View;
    private TextView mLine2View;
    private TextView mLine3View;
    private TextView mLine5View;
    private int mWhichDialog;
    private BluetoothAdapter mAdapter;
    public static final int DIALOG_RECEIVE_ONGOING = 0;
    public static final int DIALOG_RECEIVE_COMPLETE_SUCCESS = 1;
    public static final int DIALOG_RECEIVE_COMPLETE_FAIL = 2;
    public static final int DIALOG_SEND_ONGOING = 3;
    public static final int DIALOG_SEND_COMPLETE_SUCCESS = 4;
    public static final int DIALOG_SEND_COMPLETE_FAIL = 5;
    private BluetoothTransferContentObserver mObserver;
    private boolean mNeedUpdateButton = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mUri = intent.getData();
        this.mTransInfo = new BluetoothOppTransferInfo();
        this.mTransInfo = BluetoothOppUtility.queryRecord((Context)this, this.mUri);
        if (this.mTransInfo == null) {
            this.finish();
            return;
        }
        this.mIsComplete = BluetoothShare.isStatusCompleted(this.mTransInfo.mStatus);
        this.displayWhichDialog();
        if (!this.mIsComplete) {
            this.mObserver = new BluetoothTransferContentObserver();
            this.getContentResolver().registerContentObserver(BluetoothShare.CONTENT_URI, true, (ContentObserver)this.mObserver);
        }
        if (this.mWhichDialog != 3 && this.mWhichDialog != 0) {
            BluetoothOppUtility.updateVisibilityToHidden((Context)this, this.mUri);
        }
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.setUpDialog();
    }

    protected void onDestroy() {
        if (this.mObserver != null) {
            this.getContentResolver().unregisterContentObserver((ContentObserver)this.mObserver);
        }
        super.onDestroy();
    }

    private void displayWhichDialog() {
        int direction = this.mTransInfo.mDirection;
        boolean isSuccess = BluetoothShare.isStatusSuccess(this.mTransInfo.mStatus);
        boolean isComplete = BluetoothShare.isStatusCompleted(this.mTransInfo.mStatus);
        if (direction == 1) {
            if (isComplete) {
                if (isSuccess) {
                    this.mWhichDialog = 1;
                } else if (!isSuccess) {
                    this.mWhichDialog = 2;
                }
            } else if (!isComplete) {
                this.mWhichDialog = 0;
            }
        } else if (direction == 0) {
            if (isComplete) {
                if (isSuccess) {
                    this.mWhichDialog = 4;
                } else if (!isSuccess) {
                    this.mWhichDialog = 5;
                }
            } else if (!isComplete) {
                this.mWhichDialog = 3;
            }
        }
    }

    private void setUpDialog() {
        this.mPara = this.mAlertParams;
        this.mPara.mIconId = 17301659;
        this.mPara.mTitle = this.getString(2130968604);
        if (this.mWhichDialog == 0 || this.mWhichDialog == 3) {
            this.mPara.mPositiveButtonText = this.getString(2130968611);
            this.mPara.mPositiveButtonListener = this;
            this.mPara.mNegativeButtonText = this.getString(2130968610);
            this.mPara.mNegativeButtonListener = this;
        } else if (this.mWhichDialog == 1) {
            this.mPara.mPositiveButtonText = this.getString(2130968617);
            this.mPara.mPositiveButtonListener = this;
        } else if (this.mWhichDialog == 2) {
            this.mPara.mIconId = 17301543;
            this.mPara.mPositiveButtonText = this.getString(2130968615);
            this.mPara.mPositiveButtonListener = this;
        } else if (this.mWhichDialog == 4) {
            this.mPara.mPositiveButtonText = this.getString(2130968622);
            this.mPara.mPositiveButtonListener = this;
        } else if (this.mWhichDialog == 5) {
            this.mPara.mIconId = 17301543;
            this.mPara.mPositiveButtonText = this.getString(2130968625);
            this.mPara.mPositiveButtonListener = this;
            this.mPara.mNegativeButtonText = this.getString(2130968626);
            this.mPara.mNegativeButtonListener = this;
        }
        this.mPara.mView = this.createView();
        this.setupAlert();
    }

    private View createView() {
        this.mView = this.getLayoutInflater().inflate(2130903046, null);
        this.mProgressTransfer = (ProgressBar)this.mView.findViewById(2131099666);
        this.mPercentView = (TextView)this.mView.findViewById(2131099665);
        this.customizeViewContent();
        this.mNeedUpdateButton = false;
        this.updateProgressbar();
        return this.mView;
    }

    private void customizeViewContent() {
        if (this.mWhichDialog == 0 || this.mWhichDialog == 1) {
            this.mLine1View = (TextView)this.mView.findViewById(2131099660);
            String tmp = this.getString(2130968605, new Object[]{this.mTransInfo.mDeviceName});
            this.mLine1View.setText((CharSequence)tmp);
            this.mLine2View = (TextView)this.mView.findViewById(2131099661);
            tmp = this.getString(2130968606, new Object[]{this.mTransInfo.mFileName});
            this.mLine2View.setText((CharSequence)tmp);
            this.mLine3View = (TextView)this.mView.findViewById(2131099662);
            tmp = this.getString(2130968607, new Object[]{Formatter.formatFileSize((Context)this, (long)this.mTransInfo.mTotalBytes)});
            this.mLine3View.setText((CharSequence)tmp);
            this.mLine5View = (TextView)this.mView.findViewById(2131099664);
            if (this.mWhichDialog == 0) {
                tmp = this.getString(2130968609);
            } else if (this.mWhichDialog == 1) {
                tmp = this.getString(2130968616);
            }
            this.mLine5View.setText((CharSequence)tmp);
        } else if (this.mWhichDialog == 3 || this.mWhichDialog == 4) {
            this.mLine1View = (TextView)this.mView.findViewById(2131099660);
            String tmp = this.getString(2130968618, new Object[]{this.mTransInfo.mDeviceName});
            this.mLine1View.setText((CharSequence)tmp);
            this.mLine2View = (TextView)this.mView.findViewById(2131099661);
            tmp = this.getString(2130968606, new Object[]{this.mTransInfo.mFileName});
            this.mLine2View.setText((CharSequence)tmp);
            this.mLine3View = (TextView)this.mView.findViewById(2131099662);
            tmp = this.getString(2130968619, new Object[]{this.mTransInfo.mFileType, Formatter.formatFileSize((Context)this, (long)this.mTransInfo.mTotalBytes)});
            this.mLine3View.setText((CharSequence)tmp);
            this.mLine5View = (TextView)this.mView.findViewById(2131099664);
            if (this.mWhichDialog == 3) {
                tmp = this.getString(2130968620);
            } else if (this.mWhichDialog == 4) {
                tmp = this.getString(2130968621);
            }
            this.mLine5View.setText((CharSequence)tmp);
        } else if (this.mWhichDialog == 2) {
            if (this.mTransInfo.mStatus == 494) {
                this.mLine1View = (TextView)this.mView.findViewById(2131099660);
                String tmp = this.getString(2130968640, new Object[]{this.mTransInfo.mDeviceName});
                this.mLine1View.setText((CharSequence)tmp);
                this.mLine2View = (TextView)this.mView.findViewById(2131099661);
                tmp = this.getString(2130968613, new Object[]{this.mTransInfo.mFileName});
                this.mLine2View.setText((CharSequence)tmp);
                this.mLine3View = (TextView)this.mView.findViewById(2131099662);
                tmp = this.getString(2130968641, new Object[]{Formatter.formatFileSize((Context)this, (long)this.mTransInfo.mTotalBytes)});
                this.mLine3View.setText((CharSequence)tmp);
            } else {
                this.mLine1View = (TextView)this.mView.findViewById(2131099660);
                String tmp = this.getString(2130968612);
                this.mLine1View.setText((CharSequence)tmp);
                this.mLine2View = (TextView)this.mView.findViewById(2131099661);
                tmp = this.getString(2130968613, new Object[]{this.mTransInfo.mFileName});
                this.mLine2View.setText((CharSequence)tmp);
                this.mLine3View = (TextView)this.mView.findViewById(2131099662);
                tmp = this.getString(2130968614, new Object[]{BluetoothOppUtility.getStatusDescription((Context)this, this.mTransInfo.mStatus, this.mTransInfo.mDeviceName)});
                this.mLine3View.setText((CharSequence)tmp);
            }
            this.mLine5View = (TextView)this.mView.findViewById(2131099664);
            this.mLine5View.setVisibility(8);
        } else if (this.mWhichDialog == 5) {
            this.mLine1View = (TextView)this.mView.findViewById(2131099660);
            String tmp = this.getString(2130968623, new Object[]{this.mTransInfo.mDeviceName});
            this.mLine1View.setText((CharSequence)tmp);
            this.mLine2View = (TextView)this.mView.findViewById(2131099661);
            tmp = this.getString(2130968624, new Object[]{this.mTransInfo.mFileName});
            this.mLine2View.setText((CharSequence)tmp);
            this.mLine3View = (TextView)this.mView.findViewById(2131099662);
            tmp = this.getString(2130968614, new Object[]{BluetoothOppUtility.getStatusDescription((Context)this, this.mTransInfo.mStatus, this.mTransInfo.mDeviceName)});
            this.mLine3View.setText((CharSequence)tmp);
            this.mLine5View = (TextView)this.mView.findViewById(2131099664);
            this.mLine5View.setVisibility(8);
        }
        if (BluetoothShare.isStatusError(this.mTransInfo.mStatus)) {
            this.mProgressTransfer.setVisibility(8);
            this.mPercentView.setVisibility(8);
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mWhichDialog == 1) {
                    BluetoothOppUtility.openReceivedFile((Context)this, this.mTransInfo.mFileName, this.mTransInfo.mFileType, this.mTransInfo.mTimeStamp, this.mUri);
                    BluetoothOppUtility.updateVisibilityToHidden((Context)this, this.mUri);
                    ((NotificationManager)this.getSystemService("notification")).cancel(this.mTransInfo.mID);
                    break;
                }
                if (this.mWhichDialog == 5) {
                    BluetoothOppUtility.updateVisibilityToHidden((Context)this, this.mUri);
                    ((NotificationManager)this.getSystemService("notification")).cancel(this.mTransInfo.mID);
                    BluetoothOppUtility.retryTransfer((Context)this, this.mTransInfo);
                    BluetoothDevice remoteDevice = this.mAdapter.getRemoteDevice(this.mTransInfo.mDestAddr);
                    Toast.makeText((Context)this, (CharSequence)this.getString(2130968637, new Object[]{BluetoothOppManager.getInstance((Context)this).getDeviceName(remoteDevice)}), (int)0).show();
                    break;
                }
                if (this.mWhichDialog != 4) break;
                BluetoothOppUtility.updateVisibilityToHidden((Context)this, this.mUri);
                ((NotificationManager)this.getSystemService("notification")).cancel(this.mTransInfo.mID);
                break;
            }
            case -2: {
                if (this.mWhichDialog == 0 || this.mWhichDialog == 3) {
                    this.getContentResolver().delete(this.mUri, null, null);
                    String msg = "";
                    if (this.mWhichDialog == 0) {
                        msg = this.getString(2130968636, new Object[]{this.mTransInfo.mDeviceName});
                    } else if (this.mWhichDialog == 3) {
                        msg = this.getString(2130968639, new Object[]{this.mTransInfo.mDeviceName});
                    }
                    Toast.makeText((Context)this, (CharSequence)msg, (int)0).show();
                    ((NotificationManager)this.getSystemService("notification")).cancel(this.mTransInfo.mID);
                    break;
                }
                if (this.mWhichDialog != 5) break;
                BluetoothOppUtility.updateVisibilityToHidden((Context)this, this.mUri);
            }
        }
        this.finish();
    }

    private void updateProgressbar() {
        this.mTransInfo = BluetoothOppUtility.queryRecord((Context)this, this.mUri);
        if (this.mTransInfo == null) {
            return;
        }
        if (this.mTransInfo.mTotalBytes == 0) {
            this.mProgressTransfer.setMax(100);
        } else {
            this.mProgressTransfer.setMax(this.mTransInfo.mTotalBytes);
        }
        this.mProgressTransfer.setProgress(this.mTransInfo.mCurrentBytes);
        this.mPercentView.setText((CharSequence)BluetoothOppUtility.formatProgressText(this.mTransInfo.mTotalBytes, this.mTransInfo.mCurrentBytes));
        if (!this.mIsComplete && BluetoothShare.isStatusCompleted(this.mTransInfo.mStatus) && this.mNeedUpdateButton) {
            this.displayWhichDialog();
            this.updateButton();
            this.customizeViewContent();
        }
    }

    private void updateButton() {
        if (this.mWhichDialog == 1) {
            this.mAlert.getButton(-2).setVisibility(8);
            this.mAlert.getButton(-1).setText((CharSequence)this.getString(2130968617));
        } else if (this.mWhichDialog == 2) {
            this.mAlert.setIcon(17301543);
            this.mAlert.getButton(-2).setVisibility(8);
            this.mAlert.getButton(-1).setText((CharSequence)this.getString(2130968615));
        } else if (this.mWhichDialog == 4) {
            this.mAlert.getButton(-2).setVisibility(8);
            this.mAlert.getButton(-1).setText((CharSequence)this.getString(2130968622));
        } else if (this.mWhichDialog == 5) {
            this.mAlert.setIcon(17301543);
            this.mAlert.getButton(-1).setText((CharSequence)this.getString(2130968625));
            this.mAlert.getButton(-2).setText((CharSequence)this.getString(2130968626));
        }
    }

    private class BluetoothTransferContentObserver
    extends ContentObserver {
        public BluetoothTransferContentObserver() {
            super(new Handler());
        }

        public void onChange(boolean selfChange) {
            BluetoothOppTransferActivity.this.mNeedUpdateButton = true;
            BluetoothOppTransferActivity.this.updateProgressbar();
        }
    }
}

