/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.NotificationManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.BluetoothUuid;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppBatch;
import com.android.bluetooth.opp.BluetoothOppObexClientSession;
import com.android.bluetooth.opp.BluetoothOppObexSession;
import com.android.bluetooth.opp.BluetoothOppPreference;
import com.android.bluetooth.opp.BluetoothOppRfcommTransport;
import com.android.bluetooth.opp.BluetoothOppSendFileInfo;
import com.android.bluetooth.opp.BluetoothOppShareInfo;
import com.android.bluetooth.opp.BluetoothShare;
import com.android.bluetooth.opp.Constants;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import javax.obex.ObexTransport;

public class BluetoothOppTransfer
implements BluetoothOppBatch.BluetoothOppBatchListener {
    private static final String TAG = "BtOppTransfer";
    private static final boolean D = false;
    private static final boolean V = false;
    public static final int RFCOMM_ERROR = 10;
    public static final int RFCOMM_CONNECTED = 11;
    public static final int SDP_RESULT = 12;
    private static final int CONNECT_WAIT_TIMEOUT = 45000;
    private static final int CONNECT_RETRY_TIME = 100;
    private static final short OPUSH_UUID16 = 4357;
    private Context mContext;
    private BluetoothAdapter mAdapter;
    private BluetoothOppBatch mBatch;
    private BluetoothOppObexSession mSession;
    private BluetoothOppShareInfo mCurrentShare;
    private ObexTransport mTransport;
    private HandlerThread mHandlerThread;
    private EventHandler mSessionHandler;
    private PowerManager mPowerManager;
    private long mTimestamp;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device;
            if (intent.getAction().equals("android.bleutooth.device.action.UUID") && (device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE")).equals((Object)((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDestination)) {
                int channel = -1;
                Parcelable[] uuid = intent.getParcelableArrayExtra("android.bluetooth.device.extra.UUID");
                if (uuid != null) {
                    ParcelUuid[] uuids = new ParcelUuid[uuid.length];
                    for (int i = 0; i < uuid.length; ++i) {
                        uuids[i] = (ParcelUuid)uuid[i];
                    }
                    if (BluetoothUuid.isUuidPresent((ParcelUuid[])uuids, (ParcelUuid)BluetoothUuid.ObexObjectPush)) {
                        channel = ((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDestination.getServiceChannel(BluetoothUuid.ObexObjectPush);
                    }
                }
                BluetoothOppTransfer.this.mSessionHandler.obtainMessage(12, channel, -1, ((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDestination).sendToTarget();
            }
        }
    };
    private SocketConnectThread mConnectThread;

    public BluetoothOppTransfer(Context context, PowerManager powerManager, BluetoothOppBatch batch, BluetoothOppObexSession session) {
        this.mContext = context;
        this.mPowerManager = powerManager;
        this.mBatch = batch;
        this.mSession = session;
        this.mBatch.registerListern(this);
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public BluetoothOppTransfer(Context context, PowerManager powerManager, BluetoothOppBatch batch) {
        this(context, powerManager, batch, null);
    }

    public int getBatchId() {
        return this.mBatch.mId;
    }

    private void markShareTimeout(BluetoothOppShareInfo share) {
        Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + share.mId));
        ContentValues updateValues = new ContentValues();
        updateValues.put("confirm", Integer.valueOf(4));
        this.mContext.getContentResolver().update(contentUri, updateValues, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBatchFailed(int failReason) {
        BluetoothOppTransfer bluetoothOppTransfer = this;
        synchronized (bluetoothOppTransfer) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.mCurrentShare != null) {
            if (BluetoothShare.isStatusError(this.mCurrentShare.mStatus)) {
                failReason = this.mCurrentShare.mStatus;
            }
            if (this.mCurrentShare.mDirection == 1 && this.mCurrentShare.mFilename != null) {
                new File(this.mCurrentShare.mFilename).delete();
            }
        }
        BluetoothOppShareInfo info = this.mBatch.getPendingShare();
        while (info != null) {
            if (info.mStatus < 200) {
                info.mStatus = failReason;
                Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + info.mId));
                ContentValues updateValues = new ContentValues();
                updateValues.put("status", Integer.valueOf(info.mStatus));
                if (info.mDirection == 0) {
                    BluetoothOppSendFileInfo fileInfo = null;
                    fileInfo = BluetoothOppSendFileInfo.generateFileInfo(this.mContext, info.mUri, info.mMimetype, info.mDestination);
                    if (fileInfo.mFileName != null) {
                        updateValues.put("hint", fileInfo.mFileName);
                        updateValues.put("total_bytes", Long.valueOf(fileInfo.mLength));
                        updateValues.put("mimetype", fileInfo.mMimetype);
                    }
                } else if (info.mStatus < 200 && info.mFilename != null) {
                    new File(info.mFilename).delete();
                }
                this.mContext.getContentResolver().update(contentUri, updateValues, null, null);
                Constants.sendIntentIfCompleted(this.mContext, contentUri, info.mStatus);
            }
            info = this.mBatch.getPendingShare();
        }
    }

    private void markBatchFailed() {
        this.markBatchFailed(491);
    }

    public void start() {
        if (!this.mAdapter.isEnabled()) {
            Log.e((String)TAG, (String)("Can't start transfer when Bluetooth is disabled for " + this.mBatch.mId));
            this.markBatchFailed();
            this.mBatch.mStatus = 3;
            return;
        }
        if (this.mHandlerThread == null) {
            this.mHandlerThread = new HandlerThread("BtOpp Transfer Handler", 10);
            this.mHandlerThread.start();
            this.mSessionHandler = new EventHandler(this.mHandlerThread.getLooper());
            if (this.mBatch.mDirection == 0) {
                this.startConnectSession();
            } else if (this.mBatch.mDirection == 1) {
                this.startObexSession();
            }
        }
    }

    public void stop() {
        if (this.mConnectThread != null) {
            try {
                this.mConnectThread.interrupt();
                this.mConnectThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mConnectThread = null;
        }
        if (this.mSession != null) {
            this.mSession.stop();
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.getLooper().quit();
            this.mHandlerThread.interrupt();
            this.mHandlerThread = null;
        }
    }

    private void startObexSession() {
        this.mBatch.mStatus = 1;
        this.mCurrentShare = this.mBatch.getPendingShare();
        if (this.mCurrentShare == null) {
            Log.e((String)TAG, (String)"Unexpected error happened !");
            return;
        }
        if (this.mBatch.mDirection == 0) {
            this.mSession = new BluetoothOppObexClientSession(this.mContext, this.mTransport);
        } else if (this.mBatch.mDirection == 1 && this.mSession == null) {
            Log.e((String)TAG, (String)"Unexpected error happened !");
            this.markBatchFailed();
            this.mBatch.mStatus = 3;
            return;
        }
        this.mSession.start(this.mSessionHandler);
        this.processCurrentShare();
    }

    private void processCurrentShare() {
        this.mSession.addShare(this.mCurrentShare);
    }

    public void setConfirmed() {
        Thread notifyThread = new Thread("Server Unblock thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BluetoothOppObexSession bluetoothOppObexSession = BluetoothOppTransfer.this.mSession;
                synchronized (bluetoothOppObexSession) {
                    BluetoothOppTransfer.this.mSession.unblock();
                    BluetoothOppTransfer.this.mSession.notify();
                }
            }
        };
        notifyThread.start();
    }

    private void startConnectSession() {
        int channel = BluetoothOppPreference.getInstance(this.mContext).getChannel(this.mBatch.mDestination, 4357);
        if (channel != -1) {
            this.mTimestamp = System.currentTimeMillis();
            this.mSessionHandler.obtainMessage(12, channel, -1, this.mBatch.mDestination).sendToTarget();
        } else {
            this.doOpushSdp();
        }
    }

    private void doOpushSdp() {
        this.mTimestamp = System.currentTimeMillis();
        int channel = this.mBatch.mDestination.getServiceChannel(BluetoothUuid.ObexObjectPush);
        if (channel != -1) {
            this.mSessionHandler.obtainMessage(12, channel, -1, this.mBatch.mDestination).sendToTarget();
            return;
        }
        if (this.mBatch.mDestination.fetchUuidsWithSdp()) {
            IntentFilter intentFilter = new IntentFilter("android.bleutooth.device.action.UUID");
            this.mContext.registerReceiver(this.mReceiver, intentFilter);
            return;
        }
        Log.e((String)TAG, (String)"Start SDP query failed");
        Message msg = this.mSessionHandler.obtainMessage(12, channel, -1, this.mBatch.mDestination);
        this.mSessionHandler.sendMessageDelayed(msg, 2000L);
    }

    private void tickShareStatus(BluetoothOppShareInfo share) {
        Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + share.mId));
        ContentValues updateValues = new ContentValues();
        updateValues.put("direction", Integer.valueOf(share.mDirection));
        this.mContext.getContentResolver().update(contentUri, updateValues, null, null);
    }

    public void onShareAdded(int id2) {
        BluetoothOppShareInfo info = this.mBatch.getPendingShare();
        if (info.mDirection == 1) {
            this.mCurrentShare = this.mBatch.getPendingShare();
            if (this.mCurrentShare != null && this.mCurrentShare.mConfirm == 2) {
                this.processCurrentShare();
                this.setConfirmed();
            }
        }
    }

    public void onShareDeleted(int id2) {
    }

    public void onBatchCanceled() {
        this.stop();
        this.mBatch.mStatus = 2;
    }

    private class SocketConnectThread
    extends Thread {
        private final String host;
        private final BluetoothDevice device;
        private final int channel;
        private boolean isConnected;
        private long timestamp;
        private BluetoothSocket btSocket;

        public SocketConnectThread(String host, int port, int dummy) {
            super("Socket Connect Thread");
            this.btSocket = null;
            this.host = host;
            this.channel = port;
            this.device = null;
            this.isConnected = false;
        }

        public SocketConnectThread(BluetoothDevice device, int channel) {
            super("Socket Connect Thread");
            this.btSocket = null;
            this.device = device;
            this.host = null;
            this.channel = channel;
            this.isConnected = false;
        }

        public void interrupt() {
            if (this.btSocket != null) {
                try {
                    this.btSocket.close();
                }
                catch (IOException e) {
                    Log.v((String)BluetoothOppTransfer.TAG, (String)"Error when close socket");
                }
            }
        }

        public void run() {
            this.timestamp = System.currentTimeMillis();
            try {
                this.btSocket = this.device.createInsecureRfcommSocket(this.channel);
            }
            catch (IOException e1) {
                Log.e((String)BluetoothOppTransfer.TAG, (String)"Rfcomm socket create error");
                this.markConnectionFailed(this.btSocket);
                return;
            }
            try {
                this.btSocket.connect();
                BluetoothOppRfcommTransport transport = new BluetoothOppRfcommTransport(this.btSocket);
                BluetoothOppPreference.getInstance(BluetoothOppTransfer.this.mContext).setChannel(this.device, 4357, this.channel);
                BluetoothOppPreference.getInstance(BluetoothOppTransfer.this.mContext).setName(this.device, this.device.getName());
                BluetoothOppTransfer.this.mSessionHandler.obtainMessage(11, transport).sendToTarget();
            }
            catch (IOException e) {
                Log.e((String)BluetoothOppTransfer.TAG, (String)"Rfcomm socket connect exception ");
                BluetoothOppPreference.getInstance(BluetoothOppTransfer.this.mContext).removeChannel(this.device, 4357);
                this.markConnectionFailed(this.btSocket);
                return;
            }
        }

        private void markConnectionFailed(Socket s) {
            try {
                s.close();
            }
            catch (IOException e) {
                Log.e((String)BluetoothOppTransfer.TAG, (String)"TCP socket close error");
            }
            BluetoothOppTransfer.this.mSessionHandler.obtainMessage(10).sendToTarget();
        }

        private void markConnectionFailed(BluetoothSocket s) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BluetoothOppTransfer.this.mSessionHandler.obtainMessage(10).sendToTarget();
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 12: {
                    if (!((BluetoothDevice)msg.obj).equals((Object)((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDestination)) {
                        return;
                    }
                    try {
                        BluetoothOppTransfer.this.mContext.unregisterReceiver(BluetoothOppTransfer.this.mReceiver);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (msg.arg1 > 0) {
                        BluetoothOppTransfer.this.mConnectThread = new SocketConnectThread(((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDestination, msg.arg1);
                        BluetoothOppTransfer.this.mConnectThread.start();
                        break;
                    }
                    Log.e((String)BluetoothOppTransfer.TAG, (String)"SDP query failed!");
                    BluetoothOppTransfer.this.markBatchFailed(497);
                    ((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mStatus = 3;
                    break;
                }
                case 10: {
                    BluetoothOppTransfer.this.mConnectThread = null;
                    BluetoothOppTransfer.this.markBatchFailed(497);
                    ((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mStatus = 3;
                    break;
                }
                case 11: {
                    BluetoothOppTransfer.this.mConnectThread = null;
                    BluetoothOppTransfer.this.mTransport = (ObexTransport)msg.obj;
                    BluetoothOppTransfer.this.startObexSession();
                    break;
                }
                case 0: {
                    BluetoothOppShareInfo info = (BluetoothOppShareInfo)msg.obj;
                    if (((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDirection != 0) break;
                    BluetoothOppTransfer.this.mCurrentShare = BluetoothOppTransfer.this.mBatch.getPendingShare();
                    if (BluetoothOppTransfer.this.mCurrentShare != null) {
                        BluetoothOppTransfer.this.processCurrentShare();
                        break;
                    }
                    BluetoothOppTransfer.this.mSession.stop();
                    break;
                }
                case 1: {
                    BluetoothOppShareInfo info1 = (BluetoothOppShareInfo)msg.obj;
                    ((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mStatus = 2;
                    BluetoothOppTransfer.this.tickShareStatus(info1);
                    break;
                }
                case 2: {
                    BluetoothOppShareInfo info2 = (BluetoothOppShareInfo)msg.obj;
                    BluetoothOppTransfer.this.mSession.stop();
                    ((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mStatus = 3;
                    BluetoothOppTransfer.this.markBatchFailed(info2.mStatus);
                    BluetoothOppTransfer.this.tickShareStatus(BluetoothOppTransfer.this.mCurrentShare);
                    break;
                }
                case 3: {
                    BluetoothOppShareInfo info3 = (BluetoothOppShareInfo)msg.obj;
                    if (((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDirection != 0) break;
                    try {
                        if (BluetoothOppTransfer.this.mTransport == null) {
                            Log.v((String)BluetoothOppTransfer.TAG, (String)"receive MSG_SHARE_INTERRUPTED but mTransport = null");
                        } else {
                            BluetoothOppTransfer.this.mTransport.close();
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)BluetoothOppTransfer.TAG, (String)"failed to close mTransport");
                    }
                    ((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mStatus = 3;
                    if (info3 != null) {
                        BluetoothOppTransfer.this.markBatchFailed(info3.mStatus);
                    } else {
                        BluetoothOppTransfer.this.markBatchFailed();
                    }
                    BluetoothOppTransfer.this.tickShareStatus(BluetoothOppTransfer.this.mCurrentShare);
                    break;
                }
                case 4: {
                    if (((BluetoothOppTransfer)BluetoothOppTransfer.this).mBatch.mDirection == 0) {
                        try {
                            if (BluetoothOppTransfer.this.mTransport == null) {
                                Log.v((String)BluetoothOppTransfer.TAG, (String)"receive MSG_SHARE_INTERRUPTED but mTransport = null");
                                break;
                            }
                            BluetoothOppTransfer.this.mTransport.close();
                        }
                        catch (IOException e) {
                            Log.e((String)BluetoothOppTransfer.TAG, (String)"failed to close mTransport");
                        }
                        break;
                    }
                    NotificationManager nm = (NotificationManager)BluetoothOppTransfer.this.mContext.getSystemService("notification");
                    nm.cancel(((BluetoothOppTransfer)BluetoothOppTransfer.this).mCurrentShare.mId);
                    Intent in = new Intent("android.btopp.intent.action.USER_CONFIRMATION_TIMEOUT");
                    BluetoothOppTransfer.this.mContext.sendBroadcast(in);
                    BluetoothOppTransfer.this.markShareTimeout(BluetoothOppTransfer.this.mCurrentShare);
                }
            }
        }
    }
}

