/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppBatch;
import com.android.bluetooth.opp.BluetoothOppNotification;
import com.android.bluetooth.opp.BluetoothOppObexServerSession;
import com.android.bluetooth.opp.BluetoothOppRfcommListener;
import com.android.bluetooth.opp.BluetoothOppShareInfo;
import com.android.bluetooth.opp.BluetoothOppTransfer;
import com.android.bluetooth.opp.BluetoothShare;
import com.android.bluetooth.opp.Constants;
import com.google.android.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.obex.ObexTransport;

public class BluetoothOppService
extends Service {
    private static final boolean D = false;
    private static final boolean V = false;
    private boolean userAccepted = false;
    private static final String TAG = "BtOpp Service";
    private BluetoothShareContentObserver mObserver;
    private BluetoothOppNotification mNotifier;
    private boolean mPendingUpdate;
    private UpdateThread mUpdateThread;
    private ArrayList<BluetoothOppShareInfo> mShares;
    private ArrayList<BluetoothOppBatch> mBatchs;
    private BluetoothOppTransfer mTransfer;
    private BluetoothOppTransfer mServerTransfer;
    private int mBatchId;
    private CharArrayBuffer mOldChars;
    private CharArrayBuffer mNewChars;
    private BluetoothAdapter mAdapter;
    private PowerManager mPowerManager;
    private BluetoothOppRfcommListener mSocketListener;
    private boolean mListenStarted = false;
    private boolean mMediaScanInProgress;
    private int mIncomingRetries = 0;
    private ObexTransport mPendingConnection = null;
    private BluetoothOppObexServerSession mServerSession;
    private static final int START_LISTENER = 1;
    private static final int MEDIA_SCANNED = 2;
    private static final int MEDIA_SCANNED_FAILED = 3;
    private static final int MSG_INCOMING_CONNECTION_RETRY = 4;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (!BluetoothOppService.this.mAdapter.isEnabled()) break;
                    BluetoothOppService.this.startSocketListener();
                    break;
                }
                case 2: {
                    ContentValues updateValues = new ContentValues();
                    Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + msg.arg1));
                    updateValues.put("scanned", Integer.valueOf(1));
                    updateValues.put("uri", msg.obj.toString());
                    updateValues.put("mimetype", BluetoothOppService.this.getContentResolver().getType(Uri.parse((String)msg.obj.toString())));
                    BluetoothOppService.this.getContentResolver().update(contentUri, updateValues, null, null);
                    BluetoothOppService bluetoothOppService = BluetoothOppService.this;
                    synchronized (bluetoothOppService) {
                        BluetoothOppService.this.mMediaScanInProgress = false;
                        break;
                    }
                }
                case 3: {
                    Log.v((String)BluetoothOppService.TAG, (String)("Update mInfo.id " + msg.arg1 + " for MEDIA_SCANNED_FAILED"));
                    ContentValues updateValues1 = new ContentValues();
                    Uri contentUri1 = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + msg.arg1));
                    updateValues1.put("scanned", Integer.valueOf(2));
                    BluetoothOppService.this.getContentResolver().update(contentUri1, updateValues1, null, null);
                    BluetoothOppService bluetoothOppService = BluetoothOppService.this;
                    synchronized (bluetoothOppService) {
                        BluetoothOppService.this.mMediaScanInProgress = false;
                        break;
                    }
                }
                case 100: {
                    ObexTransport transport = (ObexTransport)msg.obj;
                    if (BluetoothOppService.this.mBatchs.size() == 0 && BluetoothOppService.this.mPendingConnection == null) {
                        Log.i((String)BluetoothOppService.TAG, (String)"Start Obex Server");
                        BluetoothOppService.this.createServerSession(transport);
                        break;
                    }
                    if (BluetoothOppService.this.mPendingConnection != null) {
                        Log.w((String)BluetoothOppService.TAG, (String)"OPP busy! Reject connection");
                        try {
                            transport.close();
                        }
                        catch (IOException e) {
                            Log.e((String)BluetoothOppService.TAG, (String)"close tranport error");
                        }
                        break;
                    }
                    Log.i((String)BluetoothOppService.TAG, (String)"OPP busy! Retry after 1 second");
                    BluetoothOppService.this.mIncomingRetries = BluetoothOppService.this.mIncomingRetries + 1;
                    BluetoothOppService.this.mPendingConnection = transport;
                    Message msg1 = Message.obtain((Handler)BluetoothOppService.this.mHandler);
                    msg1.what = 4;
                    BluetoothOppService.this.mHandler.sendMessageDelayed(msg1, 1000L);
                    break;
                }
                case 4: {
                    if (BluetoothOppService.this.mBatchs.size() == 0) {
                        Log.i((String)BluetoothOppService.TAG, (String)"Start Obex Server");
                        BluetoothOppService.this.createServerSession(BluetoothOppService.this.mPendingConnection);
                        BluetoothOppService.this.mIncomingRetries = 0;
                        BluetoothOppService.this.mPendingConnection = null;
                        break;
                    }
                    if (BluetoothOppService.this.mIncomingRetries == 20) {
                        Log.w((String)BluetoothOppService.TAG, (String)"Retried 20 seconds, reject connection");
                        try {
                            BluetoothOppService.this.mPendingConnection.close();
                        }
                        catch (IOException e) {
                            Log.e((String)BluetoothOppService.TAG, (String)"close tranport error");
                        }
                        BluetoothOppService.this.mIncomingRetries = 0;
                        BluetoothOppService.this.mPendingConnection = null;
                        break;
                    }
                    Log.i((String)BluetoothOppService.TAG, (String)"OPP busy! Retry after 1 second");
                    BluetoothOppService.this.mIncomingRetries = BluetoothOppService.this.mIncomingRetries + 1;
                    Message msg2 = Message.obtain((Handler)BluetoothOppService.this.mHandler);
                    msg2.what = 4;
                    BluetoothOppService.this.mHandler.sendMessageDelayed(msg2, 1000L);
                }
            }
        }
    };
    private final BroadcastReceiver mBluetoothReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                switch (intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) {
                    case 12: {
                        BluetoothOppService.this.startSocketListener();
                        break;
                    }
                    case 13: {
                        BluetoothOppService.this.mSocketListener.stop();
                        BluetoothOppService.this.mListenStarted = false;
                        BluetoothOppService bluetoothOppService = BluetoothOppService.this;
                        synchronized (bluetoothOppService) {
                            if (BluetoothOppService.this.mUpdateThread == null) {
                                BluetoothOppService.this.stopSelf();
                            }
                            break;
                        }
                    }
                }
            }
        }
    };

    public IBinder onBind(Intent arg0) {
        throw new UnsupportedOperationException("Cannot bind to Bluetooth OPP Service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate() {
        super.onCreate();
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mSocketListener = new BluetoothOppRfcommListener(this.mAdapter);
        this.mShares = Lists.newArrayList();
        this.mBatchs = Lists.newArrayList();
        this.mObserver = new BluetoothShareContentObserver();
        this.getContentResolver().registerContentObserver(BluetoothShare.CONTENT_URI, true, (ContentObserver)this.mObserver);
        this.mBatchId = 1;
        this.mNotifier = new BluetoothOppNotification((Context)this);
        this.mNotifier.mNotificationMgr.cancelAll();
        this.mNotifier.updateNotification();
        final ContentResolver contentResolver = this.getContentResolver();
        new Thread("trimDatabase"){

            public void run() {
                BluetoothOppService.trimDatabase(contentResolver);
            }
        }.start();
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        this.registerReceiver(this.mBluetoothReceiver, filter);
        BluetoothOppService bluetoothOppService = this;
        synchronized (bluetoothOppService) {
            if (this.mAdapter == null) {
                Log.w((String)TAG, (String)"Local BT device is not enabled");
            } else {
                this.startListenerDelayed();
            }
        }
        this.updateFromProvider();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int retCode = super.onStartCommand(intent, flags, startId);
        if (retCode == 1) {
            if (this.mAdapter == null) {
                Log.w((String)TAG, (String)"Local BT device is not enabled");
            } else {
                this.startListenerDelayed();
            }
            this.updateFromProvider();
        }
        return retCode;
    }

    private void startListenerDelayed() {
        if (!this.mListenStarted && this.mAdapter.isEnabled()) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), 9000L);
            this.mListenStarted = true;
        }
    }

    private void startSocketListener() {
        this.mSocketListener.start(this.mHandler);
    }

    public void onDestroy() {
        super.onDestroy();
        this.getContentResolver().unregisterContentObserver((ContentObserver)this.mObserver);
        this.unregisterReceiver(this.mBluetoothReceiver);
        this.mSocketListener.stop();
    }

    private void createServerSession(ObexTransport transport) {
        this.mServerSession = new BluetoothOppObexServerSession((Context)this, transport);
        this.mServerSession.preStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFromProvider() {
        BluetoothOppService bluetoothOppService = this;
        synchronized (bluetoothOppService) {
            this.mPendingUpdate = true;
            if (this.mUpdateThread == null) {
                this.mUpdateThread = new UpdateThread();
                this.mUpdateThread.start();
            }
        }
    }

    private void insertShare(Cursor cursor, int arrayPos) {
        BluetoothOppShareInfo info = new BluetoothOppShareInfo(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("uri")), cursor.getString(cursor.getColumnIndexOrThrow("hint")), cursor.getString(cursor.getColumnIndexOrThrow("_data")), cursor.getString(cursor.getColumnIndexOrThrow("mimetype")), cursor.getInt(cursor.getColumnIndexOrThrow("direction")), cursor.getString(cursor.getColumnIndexOrThrow("destination")), cursor.getInt(cursor.getColumnIndexOrThrow("visibility")), cursor.getInt(cursor.getColumnIndexOrThrow("confirm")), cursor.getInt(cursor.getColumnIndexOrThrow("status")), cursor.getInt(cursor.getColumnIndexOrThrow("total_bytes")), cursor.getInt(cursor.getColumnIndexOrThrow("current_bytes")), cursor.getInt(cursor.getColumnIndexOrThrow("timestamp")), cursor.getInt(cursor.getColumnIndexOrThrow("scanned")) != 0);
        this.mShares.add(arrayPos, info);
        if (info.isObsolete()) {
            Constants.updateShareStatus((Context)this, info.mId, 491);
        }
        if (info.isReadyToStart()) {
            if (info.mDirection == 0) {
                InputStream i;
                try {
                    i = this.getContentResolver().openInputStream(Uri.parse((String)info.mUri));
                }
                catch (FileNotFoundException e) {
                    Log.e((String)TAG, (String)("Can't open file for OUTBOUND info " + info.mId));
                    Constants.updateShareStatus((Context)this, info.mId, 400);
                    return;
                }
                catch (SecurityException e) {
                    Log.e((String)TAG, (String)("Exception:" + e.toString() + " for OUTBOUND info " + info.mId));
                    Constants.updateShareStatus((Context)this, info.mId, 400);
                    return;
                }
                try {
                    i.close();
                }
                catch (IOException ex) {
                    Log.e((String)TAG, (String)("IO error when close file for OUTBOUND info " + info.mId));
                    return;
                }
            }
            if (this.mBatchs.size() == 0) {
                BluetoothOppBatch newBatch = new BluetoothOppBatch((Context)this, info);
                newBatch.mId = this.mBatchId++;
                this.mBatchs.add(newBatch);
                if (info.mDirection == 0) {
                    this.mTransfer = new BluetoothOppTransfer((Context)this, this.mPowerManager, newBatch);
                } else if (info.mDirection == 1) {
                    this.mServerTransfer = new BluetoothOppTransfer((Context)this, this.mPowerManager, newBatch, this.mServerSession);
                }
                if (info.mDirection == 0 && this.mTransfer != null) {
                    this.mTransfer.start();
                } else if (info.mDirection == 1 && this.mServerTransfer != null) {
                    this.mServerTransfer.start();
                }
            } else {
                int i = this.findBatchWithTimeStamp(info.mTimestamp);
                if (i != -1) {
                    this.mBatchs.get(i).addShare(info);
                } else {
                    BluetoothOppBatch newBatch = new BluetoothOppBatch((Context)this, info);
                    newBatch.mId = this.mBatchId++;
                    this.mBatchs.add(newBatch);
                }
            }
        }
    }

    private void updateShare(Cursor cursor, int arrayPos, boolean userAccepted) {
        BluetoothOppBatch batch;
        int i;
        BluetoothOppShareInfo info = this.mShares.get(arrayPos);
        int statusColumn = cursor.getColumnIndexOrThrow("status");
        info.mId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
        info.mUri = this.stringFromCursor(info.mUri, cursor, "uri");
        info.mHint = this.stringFromCursor(info.mHint, cursor, "hint");
        info.mFilename = this.stringFromCursor(info.mFilename, cursor, "_data");
        info.mMimetype = this.stringFromCursor(info.mMimetype, cursor, "mimetype");
        info.mDirection = cursor.getInt(cursor.getColumnIndexOrThrow("direction"));
        info.mDestination = this.stringFromCursor(info.mDestination, cursor, "destination");
        int newVisibility = cursor.getInt(cursor.getColumnIndexOrThrow("visibility"));
        boolean confirmed = false;
        int newConfirm = cursor.getInt(cursor.getColumnIndexOrThrow("confirm"));
        if (info.mVisibility == 0 && newVisibility != 0 && (BluetoothShare.isStatusCompleted(info.mStatus) || newConfirm == 0)) {
            this.mNotifier.mNotificationMgr.cancel(info.mId);
        }
        info.mVisibility = newVisibility;
        if (info.mConfirm == 0 && newConfirm != 0) {
            confirmed = true;
        }
        info.mConfirm = cursor.getInt(cursor.getColumnIndexOrThrow("confirm"));
        int newStatus = cursor.getInt(statusColumn);
        if (!BluetoothShare.isStatusCompleted(info.mStatus) && BluetoothShare.isStatusCompleted(newStatus)) {
            this.mNotifier.mNotificationMgr.cancel(info.mId);
        }
        info.mStatus = newStatus;
        info.mTotalBytes = cursor.getInt(cursor.getColumnIndexOrThrow("total_bytes"));
        info.mCurrentBytes = cursor.getInt(cursor.getColumnIndexOrThrow("current_bytes"));
        info.mTimestamp = cursor.getInt(cursor.getColumnIndexOrThrow("timestamp"));
        boolean bl = info.mMediaScanned = cursor.getInt(cursor.getColumnIndexOrThrow("scanned")) != 0;
        if (confirmed && (i = this.findBatchWithTimeStamp(info.mTimestamp)) != -1) {
            batch = this.mBatchs.get(i);
            if (this.mServerTransfer != null && batch.mId == this.mServerTransfer.getBatchId()) {
                this.mServerTransfer.setConfirmed();
            }
        }
        if ((i = this.findBatchWithTimeStamp(info.mTimestamp)) != -1) {
            batch = this.mBatchs.get(i);
            if (batch.mStatus == 2 || batch.mStatus == 3) {
                if (batch.mDirection == 0) {
                    if (this.mTransfer == null) {
                        Log.e((String)TAG, (String)"Unexpected error! mTransfer is null");
                    } else if (batch.mId == this.mTransfer.getBatchId()) {
                        this.mTransfer.stop();
                    } else {
                        Log.e((String)TAG, (String)("Unexpected error! batch id " + batch.mId + " doesn't match mTransfer id " + this.mTransfer.getBatchId()));
                    }
                    this.mTransfer = null;
                } else {
                    if (this.mServerTransfer == null) {
                        Log.e((String)TAG, (String)"Unexpected error! mServerTransfer is null");
                    } else if (batch.mId == this.mServerTransfer.getBatchId()) {
                        this.mServerTransfer.stop();
                    } else {
                        Log.e((String)TAG, (String)("Unexpected error! batch id " + batch.mId + " doesn't match mServerTransfer id " + this.mServerTransfer.getBatchId()));
                    }
                    this.mServerTransfer = null;
                }
                this.removeBatch(batch);
            }
        }
    }

    private void deleteShare(int arrayPos) {
        BluetoothOppShareInfo info = this.mShares.get(arrayPos);
        int i = this.findBatchWithTimeStamp(info.mTimestamp);
        if (i != -1) {
            BluetoothOppBatch batch = this.mBatchs.get(i);
            if (batch.hasShare(info)) {
                batch.cancelBatch();
            }
            if (batch.isEmpty()) {
                this.removeBatch(batch);
            }
        }
        this.mShares.remove(arrayPos);
    }

    private String stringFromCursor(String old, Cursor cursor, String column) {
        int index = cursor.getColumnIndexOrThrow(column);
        if (old == null) {
            return cursor.getString(index);
        }
        if (this.mNewChars == null) {
            this.mNewChars = new CharArrayBuffer(128);
        }
        cursor.copyStringToBuffer(index, this.mNewChars);
        int length = this.mNewChars.sizeCopied;
        if (length != old.length()) {
            return cursor.getString(index);
        }
        if (this.mOldChars == null || this.mOldChars.sizeCopied < length) {
            this.mOldChars = new CharArrayBuffer(length);
        }
        char[] oldArray = this.mOldChars.data;
        char[] newArray = this.mNewChars.data;
        old.getChars(0, length, oldArray, 0);
        for (int i = length - 1; i >= 0; --i) {
            if (oldArray[i] == newArray[i]) continue;
            return new String(newArray, 0, length);
        }
        return old;
    }

    private int findBatchWithTimeStamp(long timestamp) {
        for (int i = this.mBatchs.size() - 1; i >= 0; --i) {
            if (this.mBatchs.get((int)i).mTimestamp != timestamp) continue;
            return i;
        }
        return -1;
    }

    private void removeBatch(BluetoothOppBatch batch) {
        this.mBatchs.remove(batch);
        if (this.mBatchs.size() > 0) {
            for (int i = 0; i < this.mBatchs.size(); ++i) {
                BluetoothOppBatch nextBatch = this.mBatchs.get(i);
                if (nextBatch.mStatus == 1) {
                    return;
                }
                if (nextBatch.mDirection == 0) {
                    this.mTransfer = new BluetoothOppTransfer((Context)this, this.mPowerManager, nextBatch);
                    this.mTransfer.start();
                    return;
                }
                if (nextBatch.mDirection != 1 || this.mServerSession == null) continue;
                this.mServerTransfer = new BluetoothOppTransfer((Context)this, this.mPowerManager, nextBatch, this.mServerSession);
                this.mServerTransfer.start();
                if (nextBatch.getPendingShare().mConfirm == 1) {
                    this.mServerTransfer.setConfirmed();
                }
                return;
            }
        }
    }

    private boolean needAction(int arrayPos) {
        BluetoothOppShareInfo info = this.mShares.get(arrayPos);
        return !BluetoothShare.isStatusCompleted(info.mStatus);
    }

    private boolean visibleNotification(int arrayPos) {
        BluetoothOppShareInfo info = this.mShares.get(arrayPos);
        return info.hasCompletionNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanFile(Cursor cursor, int arrayPos) {
        BluetoothOppShareInfo info = this.mShares.get(arrayPos);
        BluetoothOppService bluetoothOppService = this;
        synchronized (bluetoothOppService) {
            if (!this.mMediaScanInProgress) {
                this.mMediaScanInProgress = true;
                new MediaScannerNotifier((Context)this, info, this.mHandler);
                return true;
            }
            return false;
        }
    }

    private boolean shouldScanFile(int arrayPos) {
        BluetoothOppShareInfo info = this.mShares.get(arrayPos);
        return BluetoothShare.isStatusSuccess(info.mStatus) && info.mDirection == 1 && !info.mMediaScanned;
    }

    private static void trimDatabase(ContentResolver contentResolver) {
        int numToDelete;
        String INVISIBLE = "visibility=1";
        String WHERE_INVISIBLE_COMPLETE_OUTBOUND = "direction=0 AND status>=200 AND visibility=1";
        int delNum = contentResolver.delete(BluetoothShare.CONTENT_URI, "direction=0 AND status>=200 AND visibility=1", null);
        String WHERE_INVISIBLE_COMPLETE_INBOUND_FAILED = "direction=1 AND status>200 AND visibility=1";
        delNum = contentResolver.delete(BluetoothShare.CONTENT_URI, "direction=1 AND status>200 AND visibility=1", null);
        String WHERE_INBOUND_SUCCESS = "direction=1 AND status=200 AND visibility=1";
        Cursor cursor = contentResolver.query(BluetoothShare.CONTENT_URI, new String[]{"_id"}, "direction=1 AND status=200 AND visibility=1", null, "_id");
        if (cursor == null) {
            return;
        }
        int recordNum = cursor.getCount();
        if (recordNum > 1000 && cursor.moveToPosition(numToDelete = recordNum - 1000)) {
            int columnId = cursor.getColumnIndexOrThrow("_id");
            long id2 = cursor.getLong(columnId);
            delNum = contentResolver.delete(BluetoothShare.CONTENT_URI, "_id < " + id2, null);
        }
        cursor.close();
    }

    private static class MediaScannerNotifier
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private MediaScannerConnection mConnection;
        private BluetoothOppShareInfo mInfo;
        private Context mContext;
        private Handler mCallback;

        public MediaScannerNotifier(Context context, BluetoothOppShareInfo info, Handler handler) {
            this.mContext = context;
            this.mInfo = info;
            this.mCallback = handler;
            this.mConnection = new MediaScannerConnection(this.mContext, (MediaScannerConnection.MediaScannerConnectionClient)this);
            this.mConnection.connect();
        }

        public void onMediaScannerConnected() {
            this.mConnection.scanFile(this.mInfo.mFilename, this.mInfo.mMimetype);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onScanCompleted(String path, Uri uri) {
            try {
                try {
                    if (uri != null) {
                        Message msg = Message.obtain();
                        msg.setTarget(this.mCallback);
                        msg.what = 2;
                        msg.arg1 = this.mInfo.mId;
                        msg.obj = uri;
                        msg.sendToTarget();
                    }
                    Message msg = Message.obtain();
                    msg.setTarget(this.mCallback);
                    msg.what = 3;
                    msg.arg1 = this.mInfo.mId;
                    msg.sendToTarget();
                }
                catch (Exception ex) {
                    Log.v((String)BluetoothOppService.TAG, (String)("!!!MediaScannerConnection exception: " + ex));
                    Object var5_7 = null;
                    this.mConnection.disconnect();
                    return;
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.mConnection.disconnect();
                throw throwable;
            }
            this.mConnection.disconnect();
        }
    }

    private class UpdateThread
    extends Thread {
        public UpdateThread() {
            super("Bluetooth Share Service");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Process.setThreadPriority((int)10);
            boolean keepService = false;
            while (true) {
                BluetoothOppService bluetoothOppService = BluetoothOppService.this;
                synchronized (bluetoothOppService) {
                    if (BluetoothOppService.this.mUpdateThread != this) {
                        throw new IllegalStateException("multiple UpdateThreads in BluetoothOppService");
                    }
                    if (!BluetoothOppService.this.mPendingUpdate) {
                        BluetoothOppService.this.mUpdateThread = null;
                        if (!keepService && !BluetoothOppService.this.mListenStarted) {
                            BluetoothOppService.this.stopSelf();
                            break;
                        }
                        return;
                    }
                    BluetoothOppService.this.mPendingUpdate = false;
                }
                Cursor cursor = BluetoothOppService.this.getContentResolver().query(BluetoothShare.CONTENT_URI, null, null, null, "_id");
                if (cursor == null) {
                    return;
                }
                cursor.moveToFirst();
                int arrayPos = 0;
                keepService = false;
                boolean isAfterLast = cursor.isAfterLast();
                int idColumn = cursor.getColumnIndexOrThrow("_id");
                while (!isAfterLast || arrayPos < BluetoothOppService.this.mShares.size()) {
                    if (isAfterLast) {
                        if (BluetoothOppService.this.shouldScanFile(arrayPos)) {
                            BluetoothOppService.this.scanFile(null, arrayPos);
                        }
                        BluetoothOppService.this.deleteShare(arrayPos);
                        continue;
                    }
                    int id2 = cursor.getInt(idColumn);
                    if (arrayPos == BluetoothOppService.this.mShares.size()) {
                        BluetoothOppService.this.insertShare(cursor, arrayPos);
                        if (BluetoothOppService.this.shouldScanFile(arrayPos) && !BluetoothOppService.this.scanFile(cursor, arrayPos)) {
                            keepService = true;
                        }
                        if (BluetoothOppService.this.visibleNotification(arrayPos)) {
                            keepService = true;
                        }
                        if (BluetoothOppService.this.needAction(arrayPos)) {
                            keepService = true;
                        }
                        ++arrayPos;
                        cursor.moveToNext();
                        isAfterLast = cursor.isAfterLast();
                        continue;
                    }
                    int arrayId = ((BluetoothOppShareInfo)((BluetoothOppService)BluetoothOppService.this).mShares.get((int)arrayPos)).mId;
                    if (arrayId < id2) {
                        if (BluetoothOppService.this.shouldScanFile(arrayPos)) {
                            BluetoothOppService.this.scanFile(null, arrayPos);
                        }
                        BluetoothOppService.this.deleteShare(arrayPos);
                        continue;
                    }
                    if (arrayId == id2) {
                        BluetoothOppService.this.updateShare(cursor, arrayPos, BluetoothOppService.this.userAccepted);
                        if (BluetoothOppService.this.shouldScanFile(arrayPos) && !BluetoothOppService.this.scanFile(cursor, arrayPos)) {
                            keepService = true;
                        }
                        if (BluetoothOppService.this.visibleNotification(arrayPos)) {
                            keepService = true;
                        }
                        if (BluetoothOppService.this.needAction(arrayPos)) {
                            keepService = true;
                        }
                        ++arrayPos;
                        cursor.moveToNext();
                        isAfterLast = cursor.isAfterLast();
                        continue;
                    }
                    BluetoothOppService.this.insertShare(cursor, arrayPos);
                    if (BluetoothOppService.this.shouldScanFile(arrayPos) && !BluetoothOppService.this.scanFile(cursor, arrayPos)) {
                        keepService = true;
                    }
                    if (BluetoothOppService.this.visibleNotification(arrayPos)) {
                        keepService = true;
                    }
                    if (BluetoothOppService.this.needAction(arrayPos)) {
                        keepService = true;
                    }
                    ++arrayPos;
                    cursor.moveToNext();
                    isAfterLast = cursor.isAfterLast();
                }
                BluetoothOppService.this.mNotifier.updateNotification();
                cursor.close();
            }
        }
    }

    private class BluetoothShareContentObserver
    extends ContentObserver {
        public BluetoothShareContentObserver() {
            super(new Handler());
        }

        public void onChange(boolean selfChange) {
            BluetoothOppService.this.updateFromProvider();
        }
    }
}

