/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BluetoothOppSendFileInfo {
    private static final String TAG = "BluetoothOppSendFileInfo";
    private static final boolean D = false;
    private static final boolean V = false;
    public final String mFileName;
    public final FileInputStream mInputStream;
    public final String mData;
    public final int mStatus;
    public final String mMimetype;
    public final long mLength;
    public final String mDestAddr;

    public BluetoothOppSendFileInfo(String fileName, String type, long length, FileInputStream inputStream, int status, String dest) {
        this.mFileName = fileName;
        this.mMimetype = type;
        this.mLength = length;
        this.mInputStream = inputStream;
        this.mStatus = status;
        this.mDestAddr = dest;
        this.mData = null;
    }

    public BluetoothOppSendFileInfo(String data, String type, long length, int status, String dest) {
        this.mFileName = null;
        this.mInputStream = null;
        this.mData = data;
        this.mMimetype = type;
        this.mLength = length;
        this.mStatus = status;
        this.mDestAddr = dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BluetoothOppSendFileInfo generateFileInfo(Context context, String uri, String type, String dest) {
        FileInputStream is;
        ContentResolver contentResolver = context.getContentResolver();
        Uri u = Uri.parse((String)uri);
        String scheme = u.getScheme();
        String fileName = null;
        String contentType = null;
        long length = 0L;
        if (scheme.equals("content")) {
            contentType = contentResolver.getType(u);
            Cursor metadataCursor = contentResolver.query(u, new String[]{"_display_name", "_size"}, null, null, null);
            if (metadataCursor != null) {
                try {
                    if (metadataCursor.moveToFirst()) {
                        fileName = metadataCursor.getString(0);
                        length = metadataCursor.getInt(1);
                    }
                    Object var13_11 = null;
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    metadataCursor.close();
                    throw throwable;
                }
                metadataCursor.close();
                {
                }
            }
        } else if (scheme.equals("file")) {
            fileName = u.getLastPathSegment();
            contentType = type;
            File f = new File(u.getPath());
            length = f.length();
        } else {
            return new BluetoothOppSendFileInfo(null, null, 0L, null, 492, dest);
        }
        try {
            is = (FileInputStream)contentResolver.openInputStream(u);
        }
        catch (FileNotFoundException e) {
            return new BluetoothOppSendFileInfo(null, null, 0L, null, 492, dest);
        }
        if (length == 0L) {
            try {
                length = is.available();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Read stream exception: ", (Throwable)e);
                return new BluetoothOppSendFileInfo(null, null, 0L, null, 492, dest);
            }
        }
        return new BluetoothOppSendFileInfo(fileName, contentType, length, is, 0, dest);
    }
}

