/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppRfcommTransport;
import java.io.IOException;
import java.net.ServerSocket;

public class BluetoothOppRfcommListener {
    private static final String TAG = "BtOppRfcommListener";
    private static final boolean D = false;
    private static final boolean V = false;
    public static final int MSG_INCOMING_BTOPP_CONNECTION = 100;
    private volatile boolean mInterrupted;
    private Thread mSocketAcceptThread;
    private Handler mCallback;
    private static final int CREATE_RETRY_TIME = 10;
    private static final int DEFAULT_OPP_CHANNEL = 12;
    private final int mBtOppRfcommChannel;
    private final BluetoothAdapter mAdapter;
    private BluetoothServerSocket mBtServerSocket = null;
    private ServerSocket mTcpServerSocket = null;

    public BluetoothOppRfcommListener(BluetoothAdapter adapter) {
        this(adapter, 12);
    }

    public BluetoothOppRfcommListener(BluetoothAdapter adapter, int channel) {
        this.mBtOppRfcommChannel = channel;
        this.mAdapter = adapter;
    }

    public synchronized boolean start(Handler callback) {
        if (this.mSocketAcceptThread == null) {
            this.mCallback = callback;
            this.mSocketAcceptThread = new Thread(TAG){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean serverOK = true;
                    for (int i = 0; i < 10 && !BluetoothOppRfcommListener.this.mInterrupted; ++i) {
                        try {
                            BluetoothOppRfcommListener.this.mBtServerSocket = BluetoothOppRfcommListener.this.mAdapter.listenUsingInsecureRfcommOn(BluetoothOppRfcommListener.this.mBtOppRfcommChannel);
                        }
                        catch (IOException e1) {
                            Log.e((String)BluetoothOppRfcommListener.TAG, (String)("Error create RfcommServerSocket " + e1));
                            serverOK = false;
                        }
                        if (serverOK) break;
                        1 e1 = this;
                        synchronized (e1) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                Log.e((String)BluetoothOppRfcommListener.TAG, (String)"socketAcceptThread thread was interrupted (3)");
                                BluetoothOppRfcommListener.this.mInterrupted = true;
                            }
                            continue;
                        }
                    }
                    if (!serverOK) {
                        Log.e((String)BluetoothOppRfcommListener.TAG, (String)"Error start listening after 10 try");
                        BluetoothOppRfcommListener.this.mInterrupted = true;
                    }
                    if (!BluetoothOppRfcommListener.this.mInterrupted) {
                        Log.i((String)BluetoothOppRfcommListener.TAG, (String)("Accept thread started on channel " + BluetoothOppRfcommListener.this.mBtOppRfcommChannel));
                    }
                    while (!BluetoothOppRfcommListener.this.mInterrupted) {
                        try {
                            BluetoothSocket clientSocket = BluetoothOppRfcommListener.this.mBtServerSocket.accept();
                            Log.i((String)BluetoothOppRfcommListener.TAG, (String)("Accepted connectoin from " + clientSocket.getRemoteDevice()));
                            BluetoothOppRfcommTransport transport = new BluetoothOppRfcommTransport(clientSocket);
                            Message msg = Message.obtain();
                            msg.setTarget(BluetoothOppRfcommListener.this.mCallback);
                            msg.what = 100;
                            msg.obj = transport;
                            msg.sendToTarget();
                        }
                        catch (IOException e) {
                            Log.e((String)BluetoothOppRfcommListener.TAG, (String)("Error accept connection " + e));
                        }
                    }
                    Log.i((String)BluetoothOppRfcommListener.TAG, (String)"BluetoothSocket listen thread finished");
                }
            };
            this.mInterrupted = false;
            this.mSocketAcceptThread.start();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.mSocketAcceptThread != null) {
            Log.i((String)TAG, (String)"stopping Accept Thread");
            this.mInterrupted = true;
            if (this.mBtServerSocket != null) {
                try {
                    this.mBtServerSocket.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Error close mBtServerSocket");
                }
            }
            try {
                this.mSocketAcceptThread.interrupt();
                this.mSocketAcceptThread.join();
                this.mSocketAcceptThread = null;
                this.mCallback = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

