/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.NotificationManager;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import android.widget.Toast;
import com.android.bluetooth.opp.BluetoothOppIncomingFileConfirmActivity;
import com.android.bluetooth.opp.BluetoothOppManager;
import com.android.bluetooth.opp.BluetoothOppService;
import com.android.bluetooth.opp.BluetoothOppTransferActivity;
import com.android.bluetooth.opp.BluetoothOppTransferHistory;
import com.android.bluetooth.opp.BluetoothOppTransferInfo;
import com.android.bluetooth.opp.BluetoothOppUtility;
import com.android.bluetooth.opp.BluetoothShare;

public class BluetoothOppReceiver
extends BroadcastReceiver {
    private static final String TAG = "BluetoothOppReceiver";
    private static final boolean D = false;
    private static final boolean V = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.intent.action.BOOT_COMPLETED")) {
            context.startService(new Intent(context, BluetoothOppService.class));
        } else if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
            if (12 == intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) {
                context.startService(new Intent(context, BluetoothOppService.class));
                BluetoothOppReceiver bluetoothOppReceiver = this;
                synchronized (bluetoothOppReceiver) {
                    if (BluetoothOppManager.getInstance((Context)context).mSendingFlag) {
                        BluetoothOppManager.getInstance((Context)context).mSendingFlag = false;
                        Intent in1 = new Intent("android.bluetooth.devicepicker.action.LAUNCH");
                        in1.putExtra("android.bluetooth.devicepicker.extra.NEED_AUTH", false);
                        in1.putExtra("android.bluetooth.devicepicker.extra.FILTER_TYPE", 2);
                        in1.putExtra("android.bluetooth.devicepicker.extra.LAUNCH_PACKAGE", "com.android.bluetooth");
                        in1.putExtra("android.bluetooth.devicepicker.extra.DEVICE_PICKER_LAUNCH_CLASS", BluetoothOppReceiver.class.getName());
                        in1.setFlags(0x10000000);
                        context.startActivity(in1);
                    }
                }
            }
        } else if (action.equals("android.bluetooth.devicepicker.action.DEVICE_SELECTED")) {
            BluetoothOppManager mOppManager = BluetoothOppManager.getInstance(context);
            BluetoothDevice remoteDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            mOppManager.startTransfer(remoteDevice);
            String deviceName = mOppManager.getDeviceName(remoteDevice);
            int batchSize = mOppManager.getBatchSize();
            String toastMsg = mOppManager.mMultipleFlag ? context.getString(2130968638, new Object[]{Integer.toString(batchSize), deviceName}) : context.getString(2130968637, new Object[]{deviceName});
            Toast.makeText((Context)context, (CharSequence)toastMsg, (int)0).show();
        } else if (action.equals("android.btopp.intent.action.CONFIRM")) {
            Uri uri = intent.getData();
            Intent in = new Intent(context, BluetoothOppIncomingFileConfirmActivity.class);
            in.setFlags(0x10000000);
            in.setData(uri);
            context.startActivity(in);
            NotificationManager notMgr = (NotificationManager)context.getSystemService("notification");
            if (notMgr != null) {
                notMgr.cancel((int)ContentUris.parseId((Uri)intent.getData()));
            }
        } else if (action.equals("android.btopp.intent.action.INCOMING_FILE_NOTIFICATION")) {
            Toast.makeText((Context)context, (CharSequence)context.getString(2130968596), (int)0).show();
        } else if (action.equals("android.btopp.intent.action.OPEN") || action.equals("android.btopp.intent.action.LIST")) {
            BluetoothOppTransferInfo transInfo = new BluetoothOppTransferInfo();
            Uri uri = intent.getData();
            transInfo = BluetoothOppUtility.queryRecord(context, uri);
            if (transInfo == null) {
                Log.e((String)TAG, (String)"Error: Can not get data from db");
                return;
            }
            if (transInfo.mDirection == 1 && BluetoothShare.isStatusSuccess(transInfo.mStatus)) {
                BluetoothOppUtility.openReceivedFile(context, transInfo.mFileName, transInfo.mFileType, transInfo.mTimeStamp, uri);
                BluetoothOppUtility.updateVisibilityToHidden(context, uri);
            } else {
                Intent in = new Intent(context, BluetoothOppTransferActivity.class);
                in.setFlags(0x10000000);
                in.setData(uri);
                context.startActivity(in);
            }
            NotificationManager notMgr = (NotificationManager)context.getSystemService("notification");
            if (notMgr != null) {
                notMgr.cancel((int)ContentUris.parseId((Uri)intent.getData()));
            }
        } else if (action.equals("android.btopp.intent.action.OPEN_OUTBOUND")) {
            Intent in = new Intent(context, BluetoothOppTransferHistory.class);
            in.setFlags(0x14000000);
            in.putExtra("direction", 0);
            context.startActivity(in);
        } else if (action.equals("android.btopp.intent.action.OPEN_INBOUND")) {
            Intent in = new Intent(context, BluetoothOppTransferHistory.class);
            in.setFlags(0x14000000);
            in.putExtra("direction", 1);
            context.startActivity(in);
        } else if (action.equals("android.btopp.intent.action.HIDE")) {
            Cursor cursor = context.getContentResolver().query(intent.getData(), null, null, null, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    int statusColumn = cursor.getColumnIndexOrThrow("status");
                    int status = cursor.getInt(statusColumn);
                    int visibilityColumn = cursor.getColumnIndexOrThrow("visibility");
                    int visibility = cursor.getInt(visibilityColumn);
                    int userConfirmationColumn = cursor.getColumnIndexOrThrow("confirm");
                    int userConfirmation = cursor.getInt(userConfirmationColumn);
                    if (userConfirmation == 0 && visibility == 0) {
                        ContentValues values = new ContentValues();
                        values.put("visibility", Integer.valueOf(1));
                        context.getContentResolver().update(intent.getData(), values, null, null);
                    }
                }
                cursor.close();
            }
        } else if (action.equals("android.btopp.intent.action.HIDE_COMPLETE")) {
            ContentValues updateValues = new ContentValues();
            updateValues.put("visibility", Integer.valueOf(1));
            context.getContentResolver().update(BluetoothShare.CONTENT_URI, updateValues, "status >= '200' AND (visibility IS NULL OR visibility == '0')", null);
        } else if (action.equals("android.btopp.intent.action.TRANSFER_COMPLETE")) {
            String toastMsg = null;
            BluetoothOppTransferInfo transInfo = new BluetoothOppTransferInfo();
            transInfo = BluetoothOppUtility.queryRecord(context, intent.getData());
            if (transInfo == null) {
                Log.e((String)TAG, (String)"Error: Can not get data from db");
                return;
            }
            if (BluetoothShare.isStatusSuccess(transInfo.mStatus)) {
                if (transInfo.mDirection == 0) {
                    toastMsg = context.getString(2130968601, new Object[]{transInfo.mFileName});
                } else if (transInfo.mDirection == 1) {
                    toastMsg = context.getString(2130968598, new Object[]{transInfo.mFileName});
                }
            } else if (BluetoothShare.isStatusError(transInfo.mStatus)) {
                if (transInfo.mDirection == 0) {
                    toastMsg = context.getString(2130968603, new Object[]{transInfo.mFileName});
                } else if (transInfo.mDirection == 1) {
                    toastMsg = context.getString(2130968612);
                }
            }
            if (toastMsg != null) {
                Toast.makeText((Context)context, toastMsg, (int)0).show();
            }
        }
    }
}

