/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import com.android.bluetooth.opp.BluetoothShare;
import com.android.bluetooth.opp.Constants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class BluetoothOppReceiveFileInfo {
    private static final boolean D = false;
    private static final boolean V = false;
    private static String sDesiredStoragePath = null;
    public String mFileName;
    public long mLength;
    public FileOutputStream mOutputStream;
    public int mStatus;
    public String mData;

    public BluetoothOppReceiveFileInfo(String data, long length, int status) {
        this.mData = data;
        this.mStatus = status;
        this.mLength = length;
    }

    public BluetoothOppReceiveFileInfo(String filename, long length, FileOutputStream outputStream, int status) {
        this.mFileName = filename;
        this.mOutputStream = outputStream;
        this.mStatus = status;
        this.mLength = length;
    }

    public BluetoothOppReceiveFileInfo(int status) {
        this(null, 0L, null, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BluetoothOppReceiveFileInfo generateFileInfo(Context context, int id2) {
        ContentResolver contentResolver = context.getContentResolver();
        Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + id2));
        String filename = null;
        String hint = null;
        long length = 0L;
        Cursor metadataCursor = contentResolver.query(contentUri, new String[]{"hint", "total_bytes", "mimetype"}, null, null, null);
        if (metadataCursor != null) {
            try {
                if (metadataCursor.moveToFirst()) {
                    hint = metadataCursor.getString(0);
                    length = metadataCursor.getInt(1);
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                metadataCursor.close();
                throw throwable;
            }
            metadataCursor.close();
            {
            }
        }
        File base = null;
        StatFs stat = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            String root = Environment.getExternalStorageDirectory().getPath();
            base = new File(root + "/bluetooth");
            if (!base.isDirectory() && !base.mkdir()) {
                return new BluetoothOppReceiveFileInfo(492);
            }
        } else {
            return new BluetoothOppReceiveFileInfo(493);
        }
        stat = new StatFs(base.getPath());
        if ((long)stat.getBlockSize() * ((long)stat.getAvailableBlocks() - 4L) < length) {
            return new BluetoothOppReceiveFileInfo(494);
        }
        filename = BluetoothOppReceiveFileInfo.choosefilename(hint);
        if (filename == null) {
            return new BluetoothOppReceiveFileInfo(492);
        }
        String extension = null;
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex < 0) {
            return new BluetoothOppReceiveFileInfo(492);
        }
        extension = filename.substring(dotIndex);
        filename = filename.substring(0, dotIndex);
        filename = base.getPath() + File.separator + filename;
        String fullfilename = BluetoothOppReceiveFileInfo.chooseUniquefilename(filename, extension);
        if (!BluetoothOppReceiveFileInfo.safeCanonicalPath(fullfilename)) {
            return new BluetoothOppReceiveFileInfo(492);
        }
        if (fullfilename != null) {
            try {
                new FileOutputStream(fullfilename).close();
                int index = fullfilename.lastIndexOf(47) + 1;
                if (index > 0) {
                    String displayName = fullfilename.substring(index);
                    ContentValues updateValues = new ContentValues();
                    updateValues.put("hint", displayName);
                    context.getContentResolver().update(contentUri, updateValues, null, null);
                }
                return new BluetoothOppReceiveFileInfo(fullfilename, length, new FileOutputStream(fullfilename), 0);
            }
            catch (IOException e) {
                return new BluetoothOppReceiveFileInfo(492);
            }
        }
        return new BluetoothOppReceiveFileInfo(492);
    }

    private static boolean safeCanonicalPath(String uniqueFileName) {
        try {
            String canonicalPath;
            File receiveFile = new File(uniqueFileName);
            if (sDesiredStoragePath == null) {
                sDesiredStoragePath = Environment.getExternalStorageDirectory().getPath() + "/bluetooth";
            }
            return (canonicalPath = receiveFile.getCanonicalPath()).startsWith(sDesiredStoragePath);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private static String chooseUniquefilename(String filename, String extension) {
        String fullfilename = filename + extension;
        if (!new File(fullfilename).exists()) {
            return fullfilename;
        }
        filename = filename + Constants.filename_SEQUENCE_SEPARATOR;
        Random rnd = new Random(SystemClock.uptimeMillis());
        int sequence = 1;
        for (int magnitude = 1; magnitude < 1000000000; magnitude *= 10) {
            for (int iteration = 0; iteration < 9; ++iteration) {
                fullfilename = filename + sequence + extension;
                if (!new File(fullfilename).exists()) {
                    return fullfilename;
                }
                sequence += rnd.nextInt(magnitude) + 1;
            }
        }
        return null;
    }

    private static String choosefilename(String hint) {
        String filename = null;
        if (filename == null && hint != null && !hint.endsWith("/") && !hint.endsWith("\\")) {
            int index = (hint = hint.replace('\\', '/')).lastIndexOf(47) + 1;
            filename = index > 0 ? hint.substring(index) : hint;
        }
        return filename;
    }
}

