/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppService;
import com.android.bluetooth.opp.BluetoothShare;
import java.util.HashMap;

public final class BluetoothOppProvider
extends ContentProvider {
    private static final String TAG = "BluetoothOppProvider";
    private static final boolean D = false;
    private static final boolean V = false;
    private static final String DB_NAME = "btopp.db";
    private static final int DB_VERSION = 1;
    private static final int DB_VERSION_NOP_UPGRADE_FROM = 0;
    private static final int DB_VERSION_NOP_UPGRADE_TO = 1;
    private static final String DB_TABLE = "btopp";
    private static final String SHARE_LIST_TYPE = "vnd.android.cursor.dir/vnd.android.btopp";
    private static final String SHARE_TYPE = "vnd.android.cursor.item/vnd.android.btopp";
    private static final UriMatcher sURIMatcher = new UriMatcher(-1);
    private static final int SHARES = 1;
    private static final int SHARES_ID = 2;
    private static final int LIVE_FOLDER_RECEIVED_FILES = 3;
    private static final HashMap<String, String> LIVE_FOLDER_PROJECTION_MAP;
    private SQLiteOpenHelper mOpenHelper = null;

    private void createTable(SQLiteDatabase db) {
        try {
            db.execSQL("CREATE TABLE btopp(_id INTEGER PRIMARY KEY AUTOINCREMENT,uri TEXT, hint TEXT, _data TEXT, mimetype TEXT, direction INTEGER, destination TEXT, visibility INTEGER, confirm INTEGER, status INTEGER, total_bytes INTEGER, current_bytes INTEGER, timestamp INTEGER,scanned INTEGER); ");
        }
        catch (SQLException ex) {
            Log.e((String)TAG, (String)"couldn't create table in downloads database");
            throw ex;
        }
    }

    private void dropTable(SQLiteDatabase db) {
        try {
            db.execSQL("DROP TABLE IF EXISTS btopp");
        }
        catch (SQLException ex) {
            Log.e((String)TAG, (String)"couldn't drop table in downloads database");
            throw ex;
        }
    }

    public String getType(Uri uri) {
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 1: {
                return SHARE_LIST_TYPE;
            }
            case 2: {
                return SHARE_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown URI: " + uri);
    }

    private static final void copyString(String key, ContentValues from, ContentValues to) {
        String s = from.getAsString(key);
        if (s != null) {
            to.put(key, s);
        }
    }

    private static final void copyInteger(String key, ContentValues from, ContentValues to) {
        Integer i = from.getAsInteger(key);
        if (i != null) {
            to.put(key, i);
        }
    }

    public Uri insert(Uri uri, ContentValues values) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        if (sURIMatcher.match(uri) != 1) {
            throw new IllegalArgumentException("Unknown/Invalid URI " + uri);
        }
        ContentValues filteredValues = new ContentValues();
        BluetoothOppProvider.copyString("uri", values, filteredValues);
        BluetoothOppProvider.copyString("hint", values, filteredValues);
        BluetoothOppProvider.copyString("mimetype", values, filteredValues);
        BluetoothOppProvider.copyString("destination", values, filteredValues);
        BluetoothOppProvider.copyInteger("visibility", values, filteredValues);
        BluetoothOppProvider.copyInteger("total_bytes", values, filteredValues);
        if (values.getAsInteger("visibility") == null) {
            filteredValues.put("visibility", Integer.valueOf(0));
        }
        Integer dir = values.getAsInteger("direction");
        Integer con = values.getAsInteger("confirm");
        if (values.getAsInteger("direction") == null) {
            dir = 0;
        }
        if (dir == 0 && con == null) {
            con = 2;
        }
        if (dir == 1 && con == null) {
            con = 0;
        }
        filteredValues.put("confirm", con);
        filteredValues.put("direction", dir);
        filteredValues.put("status", Integer.valueOf(190));
        filteredValues.put("scanned", Integer.valueOf(0));
        Long ts = values.getAsLong("timestamp");
        if (ts == null) {
            ts = System.currentTimeMillis();
        }
        filteredValues.put("timestamp", ts);
        Context context = this.getContext();
        context.startService(new Intent(context, BluetoothOppService.class));
        long rowID = db.insert(DB_TABLE, null, filteredValues);
        Uri ret = null;
        if (rowID != -1L) {
            context.startService(new Intent(context, BluetoothOppService.class));
            ret = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + rowID));
            context.getContentResolver().notifyChange(uri, null);
        }
        return ret;
    }

    public boolean onCreate() {
        this.mOpenHelper = new DatabaseHelper(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 1: {
                qb.setTables(DB_TABLE);
                break;
            }
            case 2: {
                qb.setTables(DB_TABLE);
                qb.appendWhere((CharSequence)"_id=");
                qb.appendWhere((CharSequence)uri.getPathSegments().get(1));
                break;
            }
            case 3: {
                qb.setTables(DB_TABLE);
                qb.setProjectionMap(LIVE_FOLDER_PROJECTION_MAP);
                qb.appendWhere((CharSequence)"direction=1 AND status=200");
                sortOrder = "_id DESC, " + sortOrder;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        Cursor ret = qb.query(db, projection, selection, selectionArgs, null, null, sortOrder);
        if (ret != null) {
            ret.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return ret;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        long rowId = 0L;
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 1: 
            case 2: {
                String myWhere = selection != null ? (match == 1 ? "( " + selection + " )" : "( " + selection + " ) AND ") : "";
                if (match == 2) {
                    String segment = (String)uri.getPathSegments().get(1);
                    rowId = Long.parseLong(segment);
                    myWhere = myWhere + " ( _id = " + rowId + " ) ";
                }
                if (values.size() > 0) {
                    count = db.update(DB_TABLE, values, myWhere, selectionArgs);
                    break;
                }
                count = 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot update URI: " + uri);
            }
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 1: 
            case 2: {
                String myWhere = selection != null ? (match == 1 ? "( " + selection + " )" : "( " + selection + " ) AND ") : "";
                if (match == 2) {
                    String segment = (String)uri.getPathSegments().get(1);
                    long rowId = Long.parseLong(segment);
                    myWhere = myWhere + " ( _id = " + rowId + " ) ";
                }
                count = db.delete(DB_TABLE, myWhere, selectionArgs);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot delete URI: " + uri);
            }
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    static {
        sURIMatcher.addURI("com.android.bluetooth.opp", DB_TABLE, 1);
        sURIMatcher.addURI("com.android.bluetooth.opp", "btopp/#", 2);
        sURIMatcher.addURI("com.android.bluetooth.opp", "live_folders/received", 3);
        LIVE_FOLDER_PROJECTION_MAP = new HashMap();
        LIVE_FOLDER_PROJECTION_MAP.put("_id", "_id AS _id");
        LIVE_FOLDER_PROJECTION_MAP.put("name", "hint AS name");
    }

    private final class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            super(context, BluetoothOppProvider.DB_NAME, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            BluetoothOppProvider.this.createTable(db);
        }

        public void onUpgrade(SQLiteDatabase db, int oldV, int newV) {
            if (oldV == 0) {
                if (newV == 1) {
                    return;
                }
                oldV = 1;
            }
            Log.i((String)BluetoothOppProvider.TAG, (String)("Upgrading downloads database from version " + oldV + " to " + newV + ", which will destroy all old data"));
            BluetoothOppProvider.this.dropTable(db);
            BluetoothOppProvider.this.createTable(db);
        }
    }
}

