/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.util.HashMap;

public class BluetoothOppPreference {
    private static final String TAG = "BluetoothOppPreference";
    private static final boolean D = false;
    private static final boolean V = false;
    private static BluetoothOppPreference INSTANCE;
    private static Object INSTANCE_LOCK;
    private boolean mInitialized;
    private Context mContext;
    private SharedPreferences mNamePreference;
    private SharedPreferences mChannelPreference;
    private HashMap<String, Integer> mChannels = new HashMap();
    private HashMap<String, String> mNames = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BluetoothOppPreference getInstance(Context context) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new BluetoothOppPreference();
            }
            if (!INSTANCE.init(context)) {
                return null;
            }
            return INSTANCE;
        }
    }

    private boolean init(Context context) {
        if (this.mInitialized) {
            return true;
        }
        this.mInitialized = true;
        this.mContext = context;
        this.mNamePreference = this.mContext.getSharedPreferences("btopp_names", 0);
        this.mChannelPreference = this.mContext.getSharedPreferences("btopp_channels", 0);
        this.mNames = (HashMap)this.mNamePreference.getAll();
        this.mChannels = (HashMap)this.mChannelPreference.getAll();
        return true;
    }

    private String getChannelKey(BluetoothDevice remoteDevice, int uuid) {
        return remoteDevice.getAddress() + "_" + Integer.toHexString(uuid);
    }

    public String getName(BluetoothDevice remoteDevice) {
        String name;
        if (remoteDevice.getAddress().equals("FF:FF:FF:00:00:00")) {
            return "localhost";
        }
        if (!this.mNames.isEmpty() && (name = this.mNames.get(remoteDevice.getAddress())) != null) {
            return name;
        }
        return null;
    }

    public int getChannel(BluetoothDevice remoteDevice, int uuid) {
        String key = this.getChannelKey(remoteDevice, uuid);
        Integer channel = null;
        if (this.mChannels != null) {
            channel = this.mChannels.get(key);
        }
        return channel != null ? channel : -1;
    }

    public void setName(BluetoothDevice remoteDevice, String name) {
        if (!name.equals(this.getName(remoteDevice))) {
            SharedPreferences.Editor ed = this.mNamePreference.edit();
            ed.putString(remoteDevice.getAddress(), name);
            ed.apply();
            this.mNames.put(remoteDevice.getAddress(), name);
        }
    }

    public void setChannel(BluetoothDevice remoteDevice, int uuid, int channel) {
        if (channel != this.getChannel(remoteDevice, uuid)) {
            String key = this.getChannelKey(remoteDevice, uuid);
            SharedPreferences.Editor ed = this.mChannelPreference.edit();
            ed.putInt(key, channel);
            ed.apply();
            this.mChannels.put(key, channel);
        }
    }

    public void removeChannel(BluetoothDevice remoteDevice, int uuid) {
        String key = this.getChannelKey(remoteDevice, uuid);
        SharedPreferences.Editor ed = this.mChannelPreference.edit();
        ed.remove(key);
        ed.apply();
        this.mChannels.remove(key);
    }

    public void dump() {
        Log.d((String)TAG, (String)"Dumping Names:  ");
        Log.d((String)TAG, (String)this.mNames.toString());
        Log.d((String)TAG, (String)"Dumping Channels:  ");
        Log.d((String)TAG, (String)this.mChannels.toString());
    }

    static {
        INSTANCE_LOCK = new Object();
    }
}

