/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.android.bluetooth.opp.BluetoothOppObexSession;
import com.android.bluetooth.opp.BluetoothOppReceiveFileInfo;
import com.android.bluetooth.opp.BluetoothOppReceiver;
import com.android.bluetooth.opp.BluetoothOppRfcommTransport;
import com.android.bluetooth.opp.BluetoothOppShareInfo;
import com.android.bluetooth.opp.BluetoothShare;
import com.android.bluetooth.opp.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.obex.HeaderSet;
import javax.obex.ObexTransport;
import javax.obex.Operation;
import javax.obex.ServerRequestHandler;
import javax.obex.ServerSession;

public class BluetoothOppObexServerSession
extends ServerRequestHandler
implements BluetoothOppObexSession {
    private static final String TAG = "BtOppObexServer";
    private static final boolean D = false;
    private static final boolean V = false;
    private ObexTransport mTransport;
    private Context mContext;
    private Handler mCallback = null;
    private boolean mServerBlocking = true;
    private BluetoothOppShareInfo mInfo;
    private int mLocalShareInfoId;
    private int mAccepted = 0;
    private boolean mInterrupted = false;
    private ServerSession mSession;
    private long mTimestamp;
    private BluetoothOppReceiveFileInfo mFileInfo;
    private PowerManager.WakeLock mWakeLock;
    private PowerManager.WakeLock mPartialWakeLock;
    boolean mTimeoutMsgSent = false;

    public BluetoothOppObexServerSession(Context context, ObexTransport transport) {
        this.mContext = context;
        this.mTransport = transport;
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(805306394, TAG);
        this.mPartialWakeLock = pm.newWakeLock(1, TAG);
    }

    public void unblock() {
        this.mServerBlocking = false;
    }

    public void preStart() {
        this.mWakeLock.acquire();
        try {
            this.mSession = new ServerSession(this.mTransport, (ServerRequestHandler)this, null);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Create server session error" + e));
        }
    }

    public void start(Handler handler) {
        this.mCallback = handler;
    }

    public void stop() {
        this.mInterrupted = true;
        if (this.mSession != null) {
            try {
                this.mSession.close();
                this.mTransport.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("close mTransport error" + e));
            }
        }
        this.mCallback = null;
        this.mSession = null;
    }

    public void addShare(BluetoothOppShareInfo info) {
        this.mInfo = info;
        this.mFileInfo = this.processShareInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onPut(Operation op) {
        Message msg;
        String mimeType;
        Long length;
        String name;
        int obexResponse = 160;
        if (this.mAccepted == 3) {
            return 195;
        }
        try {
            boolean pre_reject = false;
            HeaderSet request = op.getReceivedHeader();
            name = (String)request.getHeader(1);
            length = (Long)request.getHeader(195);
            mimeType = (String)request.getHeader(66);
            if (length == 0L) {
                pre_reject = true;
                obexResponse = 203;
            }
            if (name == null || name.equals("")) {
                pre_reject = true;
                obexResponse = 192;
            }
            if (!pre_reject) {
                int dotIndex = name.lastIndexOf(".");
                if (dotIndex < 0) {
                    pre_reject = true;
                    obexResponse = 192;
                } else {
                    String extension = name.substring(dotIndex + 1).toLowerCase();
                    MimeTypeMap map = MimeTypeMap.getSingleton();
                    String type = map.getMimeTypeFromExtension(extension);
                    if (type != null) {
                        mimeType = type;
                    } else if (mimeType == null) {
                        pre_reject = true;
                        obexResponse = 207;
                    }
                    if (mimeType != null) {
                        mimeType = mimeType.toLowerCase();
                    }
                }
            }
            if (!(pre_reject || mimeType != null && Constants.mimeTypeMatches(mimeType, Constants.ACCEPTABLE_SHARE_INBOUND_TYPES))) {
                pre_reject = true;
                obexResponse = 207;
            }
            if (pre_reject && obexResponse != 160) {
                return obexResponse;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("get getReceivedHeaders error " + e));
            return 192;
        }
        ContentValues values = new ContentValues();
        values.put("hint", name);
        values.put("total_bytes", Integer.valueOf(length.intValue()));
        values.put("mimetype", mimeType);
        if (this.mTransport instanceof BluetoothOppRfcommTransport) {
            String a = ((BluetoothOppRfcommTransport)this.mTransport).getRemoteAddress();
            values.put("destination", a);
        } else {
            values.put("destination", "FF:FF:FF:00:00:00");
        }
        values.put("direction", Integer.valueOf(1));
        values.put("timestamp", Long.valueOf(this.mTimestamp));
        boolean needConfirm = true;
        if (!this.mServerBlocking) {
            values.put("confirm", Integer.valueOf(2));
            needConfirm = false;
        }
        Uri contentUri = this.mContext.getContentResolver().insert(BluetoothShare.CONTENT_URI, values);
        this.mLocalShareInfoId = Integer.parseInt((String)contentUri.getPathSegments().get(1));
        if (needConfirm) {
            Intent in = new Intent("android.btopp.intent.action.INCOMING_FILE_NOTIFICATION");
            in.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            this.mContext.sendBroadcast(in);
        }
        BluetoothOppObexServerSession in = this;
        synchronized (in) {
            if (this.mWakeLock.isHeld()) {
                this.mPartialWakeLock.acquire();
                this.mWakeLock.release();
            }
            this.mServerBlocking = true;
            try {
                while (this.mServerBlocking) {
                    this.wait(1000L);
                    if (this.mCallback == null || this.mTimeoutMsgSent) continue;
                    this.mCallback.sendMessageDelayed(this.mCallback.obtainMessage(4), 50000L);
                    this.mTimeoutMsgSent = true;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        in = this;
        synchronized (in) {
            if (this.mCallback != null && this.mTimeoutMsgSent) {
                this.mCallback.removeMessages(4);
            }
        }
        if (this.mInfo.mId != this.mLocalShareInfoId) {
            Log.e((String)TAG, (String)"Unexpected error!");
        }
        this.mAccepted = this.mInfo.mConfirm;
        int status = 200;
        if (this.mAccepted == 1 || this.mAccepted == 2) {
            if (this.mFileInfo.mFileName == null) {
                status = this.mFileInfo.mStatus;
                this.mInfo.mStatus = this.mFileInfo.mStatus;
                Constants.updateShareStatus(this.mContext, this.mInfo.mId, status);
                obexResponse = 208;
            }
            if (this.mFileInfo.mFileName != null) {
                ContentValues updateValues = new ContentValues();
                contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + this.mInfo.mId));
                updateValues.put("_data", this.mFileInfo.mFileName);
                updateValues.put("status", Integer.valueOf(192));
                this.mContext.getContentResolver().update(contentUri, updateValues, null, null);
                status = this.receiveFile(this.mFileInfo, op);
                if (status != 200) {
                    obexResponse = 208;
                }
                Constants.updateShareStatus(this.mContext, this.mInfo.mId, status);
            }
            if (status == 200) {
                msg = Message.obtain((Handler)this.mCallback, (int)0);
                msg.obj = this.mInfo;
                msg.sendToTarget();
            } else if (this.mCallback != null) {
                msg = Message.obtain((Handler)this.mCallback, (int)2);
                this.mInfo.mStatus = status;
                msg.obj = this.mInfo;
                msg.sendToTarget();
            }
        } else if (this.mAccepted == 3 || this.mAccepted == 4) {
            Log.i((String)TAG, (String)"Rejected incoming request");
            if (this.mFileInfo.mFileName != null) {
                try {
                    this.mFileInfo.mOutputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"error close file stream");
                }
                new File(this.mFileInfo.mFileName).delete();
            }
            status = 490;
            Constants.updateShareStatus(this.mContext, this.mInfo.mId, status);
            obexResponse = 195;
            msg = Message.obtain((Handler)this.mCallback);
            msg.what = 3;
            this.mInfo.mStatus = status;
            msg.obj = this.mInfo;
            msg.sendToTarget();
        }
        return obexResponse;
    }

    private int receiveFile(BluetoothOppReceiveFileInfo fileInfo, Operation op) {
        int status = -1;
        BufferedOutputStream bos = null;
        InputStream is = null;
        boolean error = false;
        try {
            is = op.openInputStream();
        }
        catch (IOException e1) {
            Log.e((String)TAG, (String)"Error when openInputStream");
            status = 496;
            error = true;
        }
        Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + this.mInfo.mId));
        if (!error) {
            ContentValues updateValues = new ContentValues();
            updateValues.put("_data", fileInfo.mFileName);
            this.mContext.getContentResolver().update(contentUri, updateValues, null, null);
        }
        int position = 0;
        if (!error) {
            bos = new BufferedOutputStream(fileInfo.mOutputStream, 65536);
        }
        if (!error) {
            int outputBufferSize = op.getMaxPacketSize();
            byte[] b = new byte[outputBufferSize];
            int readLength = 0;
            long timestamp = 0L;
            try {
                while (!this.mInterrupted && (long)position != fileInfo.mLength && (readLength = is.read(b)) != -1) {
                    bos.write(b, 0, readLength);
                    ContentValues updateValues = new ContentValues();
                    updateValues.put("current_bytes", Integer.valueOf(position += readLength));
                    this.mContext.getContentResolver().update(contentUri, updateValues, null, null);
                }
            }
            catch (IOException e1) {
                Log.e((String)TAG, (String)"Error when receiving file");
                status = 496;
                error = true;
            }
        }
        if (this.mInterrupted) {
            status = 490;
        } else if ((long)position == fileInfo.mLength) {
            status = 200;
        } else if (status == -1) {
            status = 491;
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error when closing stream after send");
            }
        }
        return status;
    }

    private BluetoothOppReceiveFileInfo processShareInfo() {
        BluetoothOppReceiveFileInfo fileInfo = BluetoothOppReceiveFileInfo.generateFileInfo(this.mContext, this.mInfo.mId);
        return fileInfo;
    }

    public int onConnect(HeaderSet request, HeaderSet reply) {
        try {
            byte[] uuid = (byte[])request.getHeader(70);
            if (uuid != null) {
                reply.setHeader(74, (Object)uuid);
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
            return 208;
        }
        this.mTimestamp = System.currentTimeMillis();
        return 160;
    }

    public void onDisconnect(HeaderSet req, HeaderSet resp) {
        resp.responseCode = 160;
    }

    private synchronized void releaseWakeLocks() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        if (this.mPartialWakeLock.isHeld()) {
            this.mPartialWakeLock.release();
        }
    }

    public void onClose() {
        this.releaseWakeLocks();
        if (this.mCallback != null) {
            Message msg = Message.obtain((Handler)this.mCallback);
            msg.what = 1;
            msg.obj = this.mInfo;
            msg.sendToTarget();
        }
    }
}

