/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppObexSession;
import com.android.bluetooth.opp.BluetoothOppSendFileInfo;
import com.android.bluetooth.opp.BluetoothOppShareInfo;
import com.android.bluetooth.opp.BluetoothShare;
import com.android.bluetooth.opp.Constants;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.ClientOperation;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import javax.obex.ObexTransport;

public class BluetoothOppObexClientSession
implements BluetoothOppObexSession {
    private static final String TAG = "BtOpp ObexClient";
    private static final boolean D = false;
    private static final boolean V = false;
    private ClientThread mThread;
    private ObexTransport mTransport;
    private Context mContext;
    private volatile boolean mInterrupted;
    private volatile boolean mWaitingForRemote;
    private Handler mCallback;

    public BluetoothOppObexClientSession(Context context, ObexTransport transport) {
        if (transport == null) {
            throw new NullPointerException("transport is null");
        }
        this.mContext = context;
        this.mTransport = transport;
    }

    public void start(Handler handler) {
        this.mCallback = handler;
        this.mThread = new ClientThread(this.mContext, this.mTransport);
        this.mThread.start();
    }

    public void stop() {
        if (this.mThread != null) {
            this.mInterrupted = true;
            try {
                this.mThread.interrupt();
                this.mThread.join();
                this.mThread = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mCallback = null;
    }

    public void addShare(BluetoothOppShareInfo share) {
        this.mThread.addShare(share);
    }

    public static void applyRemoteDeviceQuirks(HeaderSet request, BluetoothOppSendFileInfo info) {
        String address = info.mDestAddr;
        if (address == null) {
            return;
        }
        if (address.startsWith("00:04:48")) {
            String filename = info.mFileName;
            char[] c = filename.toCharArray();
            boolean firstDot = true;
            boolean modified = false;
            for (int i = c.length - 1; i >= 0; --i) {
                if (c[i] != '.') continue;
                if (!firstDot) {
                    modified = true;
                    c[i] = 95;
                }
                firstDot = false;
            }
            if (modified) {
                String newFilename = new String(c);
                request.setHeader(1, (Object)newFilename);
                Log.i((String)TAG, (String)("Sending file \"" + filename + "\" as \"" + newFilename + "\" to workaround Poloroid filename quirk"));
            }
        }
    }

    public void unblock() {
    }

    private class ClientThread
    extends Thread {
        private static final int sSleepTime = 500;
        private Context mContext1;
        private BluetoothOppShareInfo mInfo;
        private volatile boolean waitingForShare;
        private ObexTransport mTransport1;
        private ClientSession mCs;
        private PowerManager.WakeLock wakeLock;
        private BluetoothOppSendFileInfo mFileInfo;
        private boolean mConnected;

        public ClientThread(Context context, ObexTransport transport) {
            super("BtOpp ClientThread");
            this.mFileInfo = null;
            this.mConnected = false;
            this.mContext1 = context;
            this.mTransport1 = transport;
            this.waitingForShare = true;
            BluetoothOppObexClientSession.this.mWaitingForRemote = false;
            PowerManager pm = (PowerManager)this.mContext1.getSystemService("power");
            this.wakeLock = pm.newWakeLock(1, BluetoothOppObexClientSession.TAG);
        }

        public void addShare(BluetoothOppShareInfo info) {
            this.mInfo = info;
            this.mFileInfo = this.processShareInfo();
            this.waitingForShare = false;
        }

        public void run() {
            Process.setThreadPriority((int)10);
            this.wakeLock.acquire();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                BluetoothOppObexClientSession.this.mInterrupted = true;
            }
            if (!BluetoothOppObexClientSession.this.mInterrupted) {
                this.connect();
            }
            while (!BluetoothOppObexClientSession.this.mInterrupted) {
                if (!this.waitingForShare) {
                    this.doSend();
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            this.disconnect();
            if (this.wakeLock.isHeld()) {
                this.wakeLock.release();
            }
            Message msg = Message.obtain((Handler)BluetoothOppObexClientSession.this.mCallback);
            msg.what = 1;
            msg.obj = this.mInfo;
            msg.sendToTarget();
        }

        private void disconnect() {
            try {
                if (this.mCs != null) {
                    this.mCs.disconnect(null);
                }
                this.mCs = null;
            }
            catch (IOException e) {
                Log.w((String)BluetoothOppObexClientSession.TAG, (String)("OBEX session disconnect error" + e));
            }
            try {
                if (this.mCs != null) {
                    this.mCs.close();
                }
            }
            catch (IOException e) {
                Log.w((String)BluetoothOppObexClientSession.TAG, (String)("OBEX session close error" + e));
            }
            if (this.mTransport1 != null) {
                try {
                    this.mTransport1.close();
                }
                catch (IOException e) {
                    Log.e((String)BluetoothOppObexClientSession.TAG, (String)"mTransport.close error");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connect() {
            try {
                this.mCs = new ClientSession(this.mTransport1);
                this.mConnected = true;
            }
            catch (IOException e1) {
                Log.e((String)BluetoothOppObexClientSession.TAG, (String)"OBEX session create error");
            }
            if (this.mConnected) {
                this.mConnected = false;
                HeaderSet hs = new HeaderSet();
                ClientThread clientThread = this;
                synchronized (clientThread) {
                    BluetoothOppObexClientSession.this.mWaitingForRemote = true;
                }
                try {
                    this.mCs.connect(hs);
                    this.mConnected = true;
                }
                catch (IOException e) {
                    Log.e((String)BluetoothOppObexClientSession.TAG, (String)"OBEX session connect error");
                }
            }
            ClientThread clientThread = this;
            synchronized (clientThread) {
                BluetoothOppObexClientSession.this.mWaitingForRemote = false;
            }
        }

        private void doSend() {
            int status = 200;
            while (this.mFileInfo == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    status = 490;
                }
            }
            if (!this.mConnected) {
                status = 497;
            }
            if (status == 200) {
                status = this.mFileInfo.mFileName != null ? this.sendFile(this.mFileInfo) : this.mFileInfo.mStatus;
                this.waitingForShare = true;
            } else {
                Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
            }
            if (status == 200) {
                Message msg = Message.obtain((Handler)BluetoothOppObexClientSession.this.mCallback);
                msg.what = 0;
                msg.obj = this.mInfo;
                msg.sendToTarget();
            } else {
                Message msg = Message.obtain((Handler)BluetoothOppObexClientSession.this.mCallback);
                msg.what = 2;
                this.mInfo.mStatus = status;
                msg.obj = this.mInfo;
                msg.sendToTarget();
            }
        }

        private BluetoothOppSendFileInfo processShareInfo() {
            BluetoothOppSendFileInfo fileInfo = BluetoothOppSendFileInfo.generateFileInfo(this.mContext1, this.mInfo.mUri, this.mInfo.mMimetype, this.mInfo.mDestination);
            if (fileInfo.mFileName == null || fileInfo.mLength == 0L) {
                Constants.updateShareStatus(this.mContext1, this.mInfo.mId, fileInfo.mStatus);
            } else {
                ContentValues updateValues = new ContentValues();
                Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + this.mInfo.mId));
                updateValues.put("hint", fileInfo.mFileName);
                updateValues.put("total_bytes", Long.valueOf(fileInfo.mLength));
                updateValues.put("mimetype", fileInfo.mMimetype);
                this.mContext1.getContentResolver().update(contentUri, updateValues, null, null);
            }
            return fileInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private int sendFile(BluetoothOppSendFileInfo fileInfo) {
            int status;
            block83: {
                InputStream inputStream;
                ClientOperation putOperation;
                int responseCode;
                boolean error;
                block82: {
                    ContentValues updateValues;
                    error = false;
                    responseCode = -1;
                    status = 200;
                    Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + this.mInfo.mId));
                    HeaderSet request = new HeaderSet();
                    request.setHeader(1, (Object)fileInfo.mFileName);
                    request.setHeader(66, (Object)fileInfo.mMimetype);
                    BluetoothOppObexClientSession.applyRemoteDeviceQuirks(request, fileInfo);
                    Constants.updateShareStatus(this.mContext1, this.mInfo.mId, 192);
                    request.setHeader(195, (Object)fileInfo.mLength);
                    putOperation = null;
                    OutputStream outputStream = null;
                    inputStream = null;
                    ClientThread clientThread = this;
                    synchronized (clientThread) {
                        BluetoothOppObexClientSession.this.mWaitingForRemote = true;
                    }
                    try {
                        putOperation = (ClientOperation)this.mCs.put(request);
                    }
                    catch (IOException e) {
                        status = 496;
                        Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
                        Log.e((String)BluetoothOppObexClientSession.TAG, (String)"Error when put HeaderSet ");
                        error = true;
                    }
                    ClientThread e = this;
                    synchronized (e) {
                        BluetoothOppObexClientSession.this.mWaitingForRemote = false;
                    }
                    if (!error) {
                        try {
                            outputStream = putOperation.openOutputStream();
                            inputStream = putOperation.openInputStream();
                        }
                        catch (IOException e2) {
                            status = 496;
                            Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
                            Log.e((String)BluetoothOppObexClientSession.TAG, (String)"Error when openOutputStream");
                            error = true;
                        }
                    }
                    if (!error) {
                        updateValues = new ContentValues();
                        updateValues.put("current_bytes", Integer.valueOf(0));
                        updateValues.put("status", Integer.valueOf(192));
                        this.mContext1.getContentResolver().update(contentUri, updateValues, null, null);
                    }
                    if (error) break block82;
                    int position = 0;
                    int readLength = 0;
                    boolean okToProceed = false;
                    long timestamp = 0L;
                    int outputBufferSize = putOperation.getMaxPacketSize();
                    byte[] buffer = new byte[outputBufferSize];
                    BufferedInputStream a = new BufferedInputStream(fileInfo.mInputStream, 16384);
                    if (!BluetoothOppObexClientSession.this.mInterrupted && (long)position != fileInfo.mLength) {
                        readLength = a.read(buffer, 0, outputBufferSize);
                        BluetoothOppObexClientSession.this.mCallback.sendMessageDelayed(BluetoothOppObexClientSession.this.mCallback.obtainMessage(4), 50000L);
                        ClientThread clientThread2 = this;
                        synchronized (clientThread2) {
                            BluetoothOppObexClientSession.this.mWaitingForRemote = true;
                        }
                        outputStream.write(buffer, 0, readLength);
                        if ((long)(position += readLength) != fileInfo.mLength) {
                            BluetoothOppObexClientSession.this.mCallback.removeMessages(4);
                            clientThread2 = this;
                            synchronized (clientThread2) {
                                BluetoothOppObexClientSession.this.mWaitingForRemote = false;
                            }
                        }
                        outputStream.close();
                        BluetoothOppObexClientSession.this.mCallback.removeMessages(4);
                        clientThread2 = this;
                        synchronized (clientThread2) {
                            BluetoothOppObexClientSession.this.mWaitingForRemote = false;
                        }
                        responseCode = putOperation.getResponseCode();
                        if (responseCode == 144 || responseCode == 160) {
                            okToProceed = true;
                            updateValues = new ContentValues();
                            updateValues.put("current_bytes", Integer.valueOf(position));
                            this.mContext1.getContentResolver().update(contentUri, updateValues, null, null);
                        } else {
                            Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Remote reject, Response code is " + responseCode));
                        }
                    }
                    while (!BluetoothOppObexClientSession.this.mInterrupted && okToProceed && (long)position != fileInfo.mLength) {
                        readLength = a.read(buffer, 0, outputBufferSize);
                        outputStream.write(buffer, 0, readLength);
                        responseCode = putOperation.getResponseCode();
                        if (responseCode != 144 && responseCode != 160) {
                            okToProceed = false;
                            continue;
                        }
                        updateValues = new ContentValues();
                        updateValues.put("current_bytes", Integer.valueOf(position += readLength));
                        this.mContext1.getContentResolver().update(contentUri, updateValues, null, null);
                    }
                    if (responseCode == 195 || responseCode == 198) {
                        Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Remote reject file " + fileInfo.mFileName + " length " + fileInfo.mLength));
                        status = 403;
                        break block82;
                    }
                    if (responseCode == 207) {
                        Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Remote reject file type " + fileInfo.mMimetype));
                        status = 406;
                        break block82;
                    }
                    if (!BluetoothOppObexClientSession.this.mInterrupted && (long)position == fileInfo.mLength) {
                        Log.i((String)BluetoothOppObexClientSession.TAG, (String)("SendFile finished send out file " + fileInfo.mFileName + " length " + fileInfo.mLength));
                        outputStream.close();
                        break block82;
                    }
                    error = true;
                    status = 490;
                    putOperation.abort();
                    Log.i((String)BluetoothOppObexClientSession.TAG, (String)("SendFile interrupted when send out file " + fileInfo.mFileName + " at " + position + " of " + fileInfo.mLength));
                }
                Object var24_30 = null;
                try {
                    fileInfo.mInputStream.close();
                    if (!error) {
                        responseCode = putOperation.getResponseCode();
                        if (responseCode != -1) {
                            if (responseCode != 160) {
                                Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Response error code is " + responseCode));
                                status = 495;
                                if (responseCode == 207) {
                                    status = 406;
                                }
                                if (responseCode == 195 || responseCode == 198) {
                                    status = 403;
                                }
                            }
                        } else {
                            status = 497;
                        }
                    }
                    Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (putOperation != null) {
                        putOperation.close();
                    }
                    break block83;
                }
                catch (IOException e3) {
                    Log.e((String)BluetoothOppObexClientSession.TAG, (String)"Error when closing stream after send");
                }
                break block83;
                {
                    catch (IOException e) {
                        this.handleSendException(e.toString());
                        Object var24_31 = null;
                        try {
                            fileInfo.mInputStream.close();
                            if (!error) {
                                responseCode = putOperation.getResponseCode();
                                if (responseCode != -1) {
                                    if (responseCode != 160) {
                                        Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Response error code is " + responseCode));
                                        status = 495;
                                        if (responseCode == 207) {
                                            status = 406;
                                        }
                                        if (responseCode == 195 || responseCode == 198) {
                                            status = 403;
                                        }
                                    }
                                } else {
                                    status = 497;
                                }
                            }
                            Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (putOperation != null) {
                                putOperation.close();
                            }
                            break block83;
                        }
                        catch (IOException e3) {
                            Log.e((String)BluetoothOppObexClientSession.TAG, (String)"Error when closing stream after send");
                        }
                        break block83;
                    }
                    catch (NullPointerException e) {
                        this.handleSendException(e.toString());
                        Object var24_32 = null;
                        try {
                            fileInfo.mInputStream.close();
                            if (!error) {
                                responseCode = putOperation.getResponseCode();
                                if (responseCode != -1) {
                                    if (responseCode != 160) {
                                        Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Response error code is " + responseCode));
                                        status = 495;
                                        if (responseCode == 207) {
                                            status = 406;
                                        }
                                        if (responseCode == 195 || responseCode == 198) {
                                            status = 403;
                                        }
                                    }
                                } else {
                                    status = 497;
                                }
                            }
                            Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (putOperation != null) {
                                putOperation.close();
                            }
                            break block83;
                        }
                        catch (IOException e3) {
                            Log.e((String)BluetoothOppObexClientSession.TAG, (String)"Error when closing stream after send");
                        }
                        break block83;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.handleSendException(e.toString());
                        Object var24_33 = null;
                        try {
                            fileInfo.mInputStream.close();
                            if (!error) {
                                responseCode = putOperation.getResponseCode();
                                if (responseCode != -1) {
                                    if (responseCode != 160) {
                                        Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Response error code is " + responseCode));
                                        status = 495;
                                        if (responseCode == 207) {
                                            status = 406;
                                        }
                                        if (responseCode == 195 || responseCode == 198) {
                                            status = 403;
                                        }
                                    }
                                } else {
                                    status = 497;
                                }
                            }
                            Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (putOperation != null) {
                                putOperation.close();
                            }
                            break block83;
                        }
                        catch (IOException e3) {
                            Log.e((String)BluetoothOppObexClientSession.TAG, (String)"Error when closing stream after send");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var24_34 = null;
                    try {
                        fileInfo.mInputStream.close();
                        if (!error) {
                            responseCode = putOperation.getResponseCode();
                            if (responseCode != -1) {
                                if (responseCode != 160) {
                                    Log.i((String)BluetoothOppObexClientSession.TAG, (String)("Response error code is " + responseCode));
                                    status = 495;
                                    if (responseCode == 207) {
                                        status = 406;
                                    }
                                    if (responseCode == 195 || responseCode == 198) {
                                        status = 403;
                                    }
                                }
                            } else {
                                status = 497;
                            }
                        }
                        Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (putOperation != null) {
                            putOperation.close();
                        }
                    }
                    catch (IOException e3) {
                        Log.e((String)BluetoothOppObexClientSession.TAG, (String)"Error when closing stream after send");
                    }
                    throw throwable;
                }
            }
            return status;
        }

        private void handleSendException(String exception) {
            Log.e((String)BluetoothOppObexClientSession.TAG, (String)("Error when sending file: " + exception));
            int status = 496;
            Constants.updateShareStatus(this.mContext1, this.mInfo.mId, status);
            BluetoothOppObexClientSession.this.mCallback.removeMessages(4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interrupt() {
            super.interrupt();
            ClientThread clientThread = this;
            synchronized (clientThread) {
                if (BluetoothOppObexClientSession.this.mWaitingForRemote) {
                    try {
                        this.mTransport1.close();
                    }
                    catch (IOException e) {
                        Log.e((String)BluetoothOppObexClientSession.TAG, (String)"mTransport.close error");
                    }
                    Message msg = Message.obtain((Handler)BluetoothOppObexClientSession.this.mCallback);
                    msg.what = 3;
                    if (this.mInfo != null) {
                        msg.obj = this.mInfo;
                    }
                    msg.sendToTarget();
                }
            }
        }
    }
}

