/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.widget.RemoteViews;
import com.android.bluetooth.opp.BluetoothOppReceiver;
import com.android.bluetooth.opp.BluetoothOppUtility;
import com.android.bluetooth.opp.BluetoothShare;
import java.util.HashMap;

class BluetoothOppNotification {
    private static final String TAG = "BluetoothOppNotification";
    private static final boolean D = false;
    private static final boolean V = false;
    static final String status = "(status == '192')";
    static final String visible = "(visibility IS NULL OR visibility == '0')";
    static final String confirm = "(confirm == '1' OR confirm == '2')";
    static final String WHERE_RUNNING = "(status == '192') AND (visibility IS NULL OR visibility == '0') AND (confirm == '1' OR confirm == '2')";
    static final String WHERE_COMPLETED = "status >= '200' AND (visibility IS NULL OR visibility == '0')";
    private static final String WHERE_COMPLETED_OUTBOUND = "status >= '200' AND (visibility IS NULL OR visibility == '0') AND (direction == 0)";
    private static final String WHERE_COMPLETED_INBOUND = "status >= '200' AND (visibility IS NULL OR visibility == '0') AND (direction == 1)";
    static final String WHERE_CONFIRM_PENDING = "confirm == '0' AND (visibility IS NULL OR visibility == '0')";
    public NotificationManager mNotificationMgr;
    private Context mContext;
    private HashMap<String, NotificationItem> mNotifications;
    private NotificationUpdateThread mUpdateNotificationThread;
    private int mPendingUpdate = 0;
    private static final int NOTIFICATION_ID_OUTBOUND = -1000005;
    private static final int NOTIFICATION_ID_INBOUND = -1000006;
    private boolean mUpdateCompleteNotification = true;
    private int mActiveNotificationId = 0;
    private static final int NOTIFY = 0;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BluetoothOppNotification bluetoothOppNotification = BluetoothOppNotification.this;
                    synchronized (bluetoothOppNotification) {
                        if (BluetoothOppNotification.this.mPendingUpdate > 0 && BluetoothOppNotification.this.mUpdateNotificationThread == null) {
                            BluetoothOppNotification.this.mUpdateNotificationThread = new NotificationUpdateThread();
                            BluetoothOppNotification.this.mUpdateNotificationThread.start();
                            BluetoothOppNotification.this.mHandler.sendMessageDelayed(BluetoothOppNotification.this.mHandler.obtainMessage(0), 1000L);
                        } else if (BluetoothOppNotification.this.mPendingUpdate > 0) {
                            BluetoothOppNotification.this.mHandler.sendMessageDelayed(BluetoothOppNotification.this.mHandler.obtainMessage(0), 1000L);
                        }
                        break;
                    }
                }
            }
        }
    };

    BluetoothOppNotification(Context ctx) {
        this.mContext = ctx;
        this.mNotificationMgr = (NotificationManager)this.mContext.getSystemService("notification");
        this.mNotifications = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNotification() {
        BluetoothOppNotification bluetoothOppNotification = this;
        synchronized (bluetoothOppNotification) {
            ++this.mPendingUpdate;
            if (this.mPendingUpdate > 1) {
                return;
            }
            if (!this.mHandler.hasMessages(0)) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
            }
        }
    }

    private void updateActiveNotification() {
        Cursor cursor = this.mContext.getContentResolver().query(BluetoothShare.CONTENT_URI, null, WHERE_RUNNING, null, "_id");
        if (cursor == null) {
            return;
        }
        this.mUpdateCompleteNotification = cursor.getCount() <= 0;
        int timestampIndex = cursor.getColumnIndexOrThrow("timestamp");
        int directionIndex = cursor.getColumnIndexOrThrow("direction");
        int idIndex = cursor.getColumnIndexOrThrow("_id");
        int totalBytesIndex = cursor.getColumnIndexOrThrow("total_bytes");
        int currentBytesIndex = cursor.getColumnIndexOrThrow("current_bytes");
        int dataIndex = cursor.getColumnIndexOrThrow("_data");
        int filenameHintIndex = cursor.getColumnIndexOrThrow("hint");
        this.mNotifications.clear();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            String batchID;
            int timeStamp = cursor.getInt(timestampIndex);
            int dir = cursor.getInt(directionIndex);
            int id2 = cursor.getInt(idIndex);
            int total = cursor.getInt(totalBytesIndex);
            int current = cursor.getInt(currentBytesIndex);
            String fileName = cursor.getString(dataIndex);
            if (fileName == null) {
                fileName = cursor.getString(filenameHintIndex);
            }
            if (fileName == null) {
                fileName = this.mContext.getString(2130968628);
            }
            if (!this.mNotifications.containsKey(batchID = Long.toString(timeStamp))) {
                NotificationItem item = new NotificationItem();
                item.id = id2;
                item.direction = dir;
                if (item.direction == 0) {
                    item.description = this.mContext.getString(2130968600, new Object[]{fileName});
                } else if (item.direction == 1) {
                    item.description = this.mContext.getString(2130968597, new Object[]{fileName});
                }
                item.totalCurrent = current;
                item.totalTotal = total;
                this.mNotifications.put(batchID, item);
            }
            cursor.moveToNext();
        }
        cursor.close();
        for (NotificationItem item : this.mNotifications.values()) {
            RemoteViews expandedView = new RemoteViews("com.android.bluetooth", 2130903048);
            expandedView.setTextViewText(2131099669, (CharSequence)item.description);
            expandedView.setProgressBar(2131099670, item.totalTotal, item.totalCurrent, item.totalTotal == -1);
            expandedView.setTextViewText(2131099668, (CharSequence)BluetoothOppUtility.formatProgressText(item.totalTotal, item.totalCurrent));
            Notification n = new Notification();
            if (item.direction == 0) {
                n.icon = 0x1080088;
                expandedView.setImageViewResource(2131099667, 0x1080088);
            } else if (item.direction == 1) {
                n.icon = 0x1080081;
                expandedView.setImageViewResource(2131099667, 0x1080081);
            }
            n.flags |= 2;
            n.contentView = expandedView;
            Intent intent = new Intent("android.btopp.intent.action.LIST");
            intent.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            intent.setData(Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + item.id)));
            n.contentIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            this.mNotificationMgr.notify(item.id, n);
            this.mActiveNotificationId = item.id;
        }
    }

    private void updateCompletedNotification() {
        Intent intent;
        String caption;
        String title;
        Cursor cursor;
        long timeStamp = 0L;
        int outboundSuccNumber = 0;
        int outboundFailNumber = 0;
        int inboundSuccNumber = 0;
        int inboundFailNumber = 0;
        if (!this.mUpdateCompleteNotification) {
            return;
        }
        if (this.mNotificationMgr != null && this.mActiveNotificationId != 0) {
            this.mNotificationMgr.cancel(this.mActiveNotificationId);
        }
        if ((cursor = this.mContext.getContentResolver().query(BluetoothShare.CONTENT_URI, null, WHERE_COMPLETED_OUTBOUND, null, "timestamp DESC")) == null) {
            return;
        }
        int timestampIndex = cursor.getColumnIndexOrThrow("timestamp");
        int statusIndex = cursor.getColumnIndexOrThrow("status");
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int status;
            if (cursor.isFirst()) {
                timeStamp = cursor.getLong(timestampIndex);
            }
            if (BluetoothShare.isStatusError(status = cursor.getInt(statusIndex))) {
                ++outboundFailNumber;
            } else {
                ++outboundSuccNumber;
            }
            cursor.moveToNext();
        }
        cursor.close();
        int outboundNum = outboundSuccNumber + outboundFailNumber;
        if (outboundNum > 0) {
            Notification outNoti = new Notification();
            outNoti.icon = 17301641;
            title = this.mContext.getString(2130968661);
            caption = this.mContext.getString(2130968663, new Object[]{outboundSuccNumber, outboundFailNumber});
            intent = new Intent("android.btopp.intent.action.OPEN_OUTBOUND");
            intent.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            outNoti.setLatestEventInfo(this.mContext, (CharSequence)title, (CharSequence)caption, PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0));
            intent = new Intent("android.btopp.intent.action.HIDE_COMPLETE");
            intent.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            outNoti.deleteIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            outNoti.when = timeStamp;
            this.mNotificationMgr.notify(-1000005, outNoti);
        } else if (this.mNotificationMgr != null) {
            this.mNotificationMgr.cancel(-1000005);
        }
        cursor = this.mContext.getContentResolver().query(BluetoothShare.CONTENT_URI, null, WHERE_COMPLETED_INBOUND, null, "timestamp DESC");
        if (cursor == null) {
            return;
        }
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int status;
            if (cursor.isFirst()) {
                timeStamp = cursor.getLong(timestampIndex);
            }
            if (BluetoothShare.isStatusError(status = cursor.getInt(statusIndex))) {
                ++inboundFailNumber;
            } else {
                ++inboundSuccNumber;
            }
            cursor.moveToNext();
        }
        cursor.close();
        int inboundNum = inboundSuccNumber + inboundFailNumber;
        if (inboundNum > 0) {
            Notification inNoti = new Notification();
            inNoti.icon = 17301634;
            title = this.mContext.getString(2130968662);
            caption = this.mContext.getString(2130968663, new Object[]{inboundSuccNumber, inboundFailNumber});
            intent = new Intent("android.btopp.intent.action.OPEN_INBOUND");
            intent.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            inNoti.setLatestEventInfo(this.mContext, (CharSequence)title, (CharSequence)caption, PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0));
            intent = new Intent("android.btopp.intent.action.HIDE_COMPLETE");
            intent.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            inNoti.deleteIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            inNoti.when = timeStamp;
            this.mNotificationMgr.notify(-1000006, inNoti);
        } else if (this.mNotificationMgr != null) {
            this.mNotificationMgr.cancel(-1000006);
        }
    }

    private void updateIncomingFileConfirmNotification() {
        Cursor cursor = this.mContext.getContentResolver().query(BluetoothShare.CONTENT_URI, null, WHERE_CONFIRM_PENDING, null, "_id");
        if (cursor == null) {
            return;
        }
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            String title = this.mContext.getString(2130968594);
            String caption = this.mContext.getString(2130968595);
            int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            long timeStamp = cursor.getLong(cursor.getColumnIndexOrThrow("timestamp"));
            Uri contentUri = Uri.parse((String)(BluetoothShare.CONTENT_URI + "/" + id2));
            Notification n = new Notification();
            n.icon = 2130837504;
            n.flags |= 8;
            n.defaults = 1;
            n.tickerText = title;
            Intent intent = new Intent("android.btopp.intent.action.CONFIRM");
            intent.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            intent.setData(contentUri);
            n.when = timeStamp;
            n.setLatestEventInfo(this.mContext, (CharSequence)title, (CharSequence)caption, PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0));
            intent = new Intent("android.btopp.intent.action.HIDE");
            intent.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
            intent.setData(contentUri);
            n.deleteIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            this.mNotificationMgr.notify(id2, n);
            cursor.moveToNext();
        }
        cursor.close();
    }

    private class NotificationUpdateThread
    extends Thread {
        public NotificationUpdateThread() {
            super("Notification Update Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Process.setThreadPriority((int)10);
            BluetoothOppNotification bluetoothOppNotification = BluetoothOppNotification.this;
            synchronized (bluetoothOppNotification) {
                if (BluetoothOppNotification.this.mUpdateNotificationThread != this) {
                    throw new IllegalStateException("multiple UpdateThreads in BluetoothOppNotification");
                }
                BluetoothOppNotification.this.mPendingUpdate = 0;
            }
            BluetoothOppNotification.this.updateActiveNotification();
            BluetoothOppNotification.this.updateCompletedNotification();
            BluetoothOppNotification.this.updateIncomingFileConfirmNotification();
            bluetoothOppNotification = BluetoothOppNotification.this;
            synchronized (bluetoothOppNotification) {
                BluetoothOppNotification.this.mUpdateNotificationThread = null;
            }
        }
    }

    static class NotificationItem {
        int id;
        int direction;
        int totalCurrent = 0;
        int totalTotal = 0;
        String description;

        NotificationItem() {
        }
    }
}

