/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppBtErrorActivity;
import com.android.bluetooth.opp.BluetoothOppPreference;
import com.android.bluetooth.opp.BluetoothShare;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothOppManager {
    private static final String TAG = "BluetoothOppManager";
    private static final boolean D = false;
    private static final boolean V = false;
    private static BluetoothOppManager INSTANCE;
    private static Object INSTANCE_LOCK;
    private boolean mInitialized;
    private Context mContext;
    private BluetoothAdapter mAdapter;
    private String mMimeTypeOfSendingFile;
    private String mUriOfSendingFile;
    private String mMimeTypeOfSendingFiles;
    private ArrayList<Uri> mUrisOfSendingFiles;
    private static final String OPP_PREFERENCE_FILE = "OPPMGR";
    private static final String SENDING_FLAG = "SENDINGFLAG";
    private static final String MIME_TYPE = "MIMETYPE";
    private static final String FILE_URI = "FILE_URI";
    private static final String MIME_TYPE_MULTIPLE = "MIMETYPE_MULTIPLE";
    private static final String FILE_URIS = "FILE_URIS";
    private static final String MULTIPLE_FLAG = "MULTIPLE_FLAG";
    private static final String ARRAYLIST_ITEM_SEPERATOR = ";";
    private static final int ALLOWED_INSERT_SHARE_THREAD_NUMBER = 3;
    public boolean mSendingFlag;
    public boolean mMultipleFlag;
    private int mfileNumInBatch;
    private int mInsertShareThreadNum = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BluetoothOppManager getInstance(Context context) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new BluetoothOppManager();
            }
            INSTANCE.init(context);
            return INSTANCE;
        }
    }

    private boolean init(Context context) {
        if (this.mInitialized) {
            return true;
        }
        this.mInitialized = true;
        this.mContext = context;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mAdapter == null) {
            // empty if block
        }
        this.restoreApplicationData();
        return true;
    }

    private void restoreApplicationData() {
        SharedPreferences settings = this.mContext.getSharedPreferences(OPP_PREFERENCE_FILE, 0);
        this.mSendingFlag = settings.getBoolean(SENDING_FLAG, false);
        this.mMimeTypeOfSendingFile = settings.getString(MIME_TYPE, null);
        this.mUriOfSendingFile = settings.getString(FILE_URI, null);
        this.mMimeTypeOfSendingFiles = settings.getString(MIME_TYPE_MULTIPLE, null);
        this.mMultipleFlag = settings.getBoolean(MULTIPLE_FLAG, false);
        String strUris = settings.getString(FILE_URIS, null);
        this.mUrisOfSendingFiles = new ArrayList();
        if (strUris != null) {
            String[] splitUri = strUris.split(ARRAYLIST_ITEM_SEPERATOR);
            for (int i = 0; i < splitUri.length; ++i) {
                this.mUrisOfSendingFiles.add(Uri.parse((String)splitUri[i]));
            }
        }
        this.mContext.getSharedPreferences(OPP_PREFERENCE_FILE, 0).edit().clear().apply();
    }

    private void storeApplicationData() {
        SharedPreferences.Editor editor = this.mContext.getSharedPreferences(OPP_PREFERENCE_FILE, 0).edit();
        editor.putBoolean(SENDING_FLAG, this.mSendingFlag);
        editor.putBoolean(MULTIPLE_FLAG, this.mMultipleFlag);
        if (this.mMultipleFlag) {
            editor.putString(MIME_TYPE_MULTIPLE, this.mMimeTypeOfSendingFiles);
            StringBuilder sb = new StringBuilder();
            int count = this.mUrisOfSendingFiles.size();
            for (int i = 0; i < count; ++i) {
                Uri uriContent = this.mUrisOfSendingFiles.get(i);
                sb.append(uriContent);
                sb.append(ARRAYLIST_ITEM_SEPERATOR);
            }
            String strUris = sb.toString();
            editor.putString(FILE_URIS, strUris);
            editor.remove(MIME_TYPE);
            editor.remove(FILE_URI);
        } else {
            editor.putString(MIME_TYPE, this.mMimeTypeOfSendingFile);
            editor.putString(FILE_URI, this.mUriOfSendingFile);
            editor.remove(MIME_TYPE_MULTIPLE);
            editor.remove(FILE_URIS);
        }
        editor.apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSendingFileInfo(String mimeType, String uri) {
        BluetoothOppManager bluetoothOppManager = this;
        synchronized (bluetoothOppManager) {
            this.mMultipleFlag = false;
            this.mMimeTypeOfSendingFile = mimeType;
            this.mUriOfSendingFile = uri;
            this.storeApplicationData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSendingFileInfo(String mimeType, ArrayList<Uri> uris) {
        BluetoothOppManager bluetoothOppManager = this;
        synchronized (bluetoothOppManager) {
            this.mMultipleFlag = true;
            this.mMimeTypeOfSendingFiles = mimeType;
            this.mUrisOfSendingFiles = uris;
            this.storeApplicationData();
        }
    }

    public boolean isEnabled() {
        if (this.mAdapter != null) {
            return this.mAdapter.isEnabled();
        }
        return false;
    }

    public void enableBluetooth() {
        if (this.mAdapter != null) {
            this.mAdapter.enable();
        }
    }

    public void disableBluetooth() {
        if (this.mAdapter != null) {
            this.mAdapter.disable();
        }
    }

    public String getDeviceName(BluetoothDevice device) {
        String deviceName = BluetoothOppPreference.getInstance(this.mContext).getName(device);
        if (deviceName == null && this.mAdapter != null) {
            deviceName = device.getName();
        }
        if (deviceName == null) {
            deviceName = this.mContext.getString(2130968579);
        }
        return deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBatchSize() {
        BluetoothOppManager bluetoothOppManager = this;
        synchronized (bluetoothOppManager) {
            return this.mfileNumInBatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransfer(BluetoothDevice device) {
        InsertShareInfoThread insertThread;
        BluetoothOppManager bluetoothOppManager = this;
        synchronized (bluetoothOppManager) {
            if (this.mInsertShareThreadNum > 3) {
                Log.e((String)TAG, (String)"Too many shares user triggered concurrently!");
                Intent in = new Intent(this.mContext, BluetoothOppBtErrorActivity.class);
                in.setFlags(0x10000000);
                in.putExtra("title", this.mContext.getString(2130968632));
                in.putExtra("content", this.mContext.getString(2130968642));
                this.mContext.startActivity(in);
                return;
            }
            insertThread = new InsertShareInfoThread(device, this.mMultipleFlag, this.mMimeTypeOfSendingFile, this.mUriOfSendingFile, this.mMimeTypeOfSendingFiles, this.mUrisOfSendingFiles);
            if (this.mMultipleFlag) {
                this.mfileNumInBatch = this.mUrisOfSendingFiles.size();
            }
        }
        insertThread.start();
    }

    static {
        INSTANCE_LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InsertShareInfoThread
    extends Thread {
        private final BluetoothDevice mRemoteDevice;
        private final String mTypeOfSingleFile;
        private final String mUri;
        private final String mTypeOfMultipleFiles;
        private final ArrayList<Uri> mUris;
        private final boolean mIsMultiple;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InsertShareInfoThread(BluetoothDevice device, boolean multiple, String typeOfSingleFile, String uri, String typeOfMultipleFiles, ArrayList<Uri> uris) {
            super("Insert ShareInfo Thread");
            this.mRemoteDevice = device;
            this.mIsMultiple = multiple;
            this.mTypeOfSingleFile = typeOfSingleFile;
            this.mUri = uri;
            this.mTypeOfMultipleFiles = typeOfMultipleFiles;
            this.mUris = uris;
            BluetoothOppManager bluetoothOppManager2 = BluetoothOppManager.this;
            synchronized (bluetoothOppManager2) {
                BluetoothOppManager.this.mInsertShareThreadNum++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            if (this.mRemoteDevice == null) {
                Log.e((String)BluetoothOppManager.TAG, (String)"Target bt device is null!");
                return;
            }
            if (this.mIsMultiple) {
                this.insertMultipleShare();
            } else {
                this.insertSingleShare();
            }
            BluetoothOppManager bluetoothOppManager = BluetoothOppManager.this;
            synchronized (bluetoothOppManager) {
                BluetoothOppManager.this.mInsertShareThreadNum--;
            }
        }

        private void insertMultipleShare() {
            int count = this.mUris.size();
            Long ts = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                Uri fileUri = this.mUris.get(i);
                ContentResolver contentResolver = BluetoothOppManager.this.mContext.getContentResolver();
                String contentType = contentResolver.getType(fileUri);
                if (TextUtils.isEmpty((CharSequence)contentType)) {
                    contentType = this.mTypeOfMultipleFiles;
                }
                ContentValues values = new ContentValues();
                values.put("uri", fileUri.toString());
                values.put("mimetype", contentType);
                values.put("destination", this.mRemoteDevice.getAddress());
                values.put("timestamp", ts);
                Uri contentUri = BluetoothOppManager.this.mContext.getContentResolver().insert(BluetoothShare.CONTENT_URI, values);
            }
        }

        private void insertSingleShare() {
            ContentValues values = new ContentValues();
            values.put("uri", this.mUri);
            values.put("mimetype", this.mTypeOfSingleFile);
            values.put("destination", this.mRemoteDevice.getAddress());
            Uri contentUri = BluetoothOppManager.this.mContext.getContentResolver().insert(BluetoothShare.CONTENT_URI, values);
        }
    }
}

