/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import com.android.bluetooth.opp.BluetoothOppBtEnableActivity;
import com.android.bluetooth.opp.BluetoothOppBtErrorActivity;
import com.android.bluetooth.opp.BluetoothOppManager;
import com.android.bluetooth.opp.BluetoothOppReceiver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BluetoothOppLauncherActivity
extends Activity {
    private static final String TAG = "BluetoothLauncherActivity";
    private static final boolean D = false;
    private static final boolean V = false;

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate(Bundle savedInstanceState) {
        block10: {
            String action;
            block11: {
                Intent in;
                block14: {
                    Intent intent;
                    block12: {
                        CharSequence extra_text;
                        String type;
                        block13: {
                            super.onCreate(savedInstanceState);
                            intent = this.getIntent();
                            action = intent.getAction();
                            if (!action.equals("android.intent.action.SEND") && !action.equals("android.intent.action.SEND_MULTIPLE")) break block11;
                            if (!action.equals("android.intent.action.SEND")) break block12;
                            type = intent.getType();
                            Uri stream = (Uri)intent.getParcelableExtra("android.intent.extra.STREAM");
                            extra_text = intent.getCharSequenceExtra("android.intent.extra.TEXT");
                            if (stream == null || type == null) break block13;
                            BluetoothOppManager.getInstance((Context)this).saveSendingFileInfo(type, stream.toString());
                            break block14;
                        }
                        if (extra_text != null && type != null) {
                            Uri fileUri = this.creatFileForSharedContent((Context)this, extra_text);
                            if (fileUri != null) {
                                BluetoothOppManager.getInstance((Context)this).saveSendingFileInfo(type, fileUri.toString());
                            }
                            break block14;
                        } else {
                            Log.e((String)TAG, (String)"type is null; or sending file URI is null");
                            this.finish();
                            return;
                        }
                    }
                    if (action.equals("android.intent.action.SEND_MULTIPLE")) {
                        ArrayList uris = new ArrayList();
                        String mimeType = intent.getType();
                        uris = intent.getParcelableArrayListExtra("android.intent.extra.STREAM");
                        if (mimeType != null && uris != null) {
                            BluetoothOppManager.getInstance((Context)this).saveSendingFileInfo(mimeType, uris);
                        } else {
                            Log.e((String)TAG, (String)"type is null; or sending files URIs are null");
                            this.finish();
                            return;
                        }
                    }
                }
                if (this.isAirplaneModeOn()) {
                    in = new Intent((Context)this, BluetoothOppBtErrorActivity.class);
                    in.setFlags(0x10000000);
                    in.putExtra("title", this.getString(2130968581));
                    in.putExtra("content", this.getString(2130968582));
                    this.startActivity(in);
                    this.finish();
                    return;
                }
                if (!BluetoothOppManager.getInstance((Context)this).isEnabled()) {
                    in = new Intent((Context)this, BluetoothOppBtEnableActivity.class);
                    in.setFlags(0x10000000);
                    this.startActivity(in);
                    break block10;
                } else {
                    Intent in1 = new Intent("android.bluetooth.devicepicker.action.LAUNCH");
                    in1.setFlags(0x800000);
                    in1.putExtra("android.bluetooth.devicepicker.extra.NEED_AUTH", false);
                    in1.putExtra("android.bluetooth.devicepicker.extra.FILTER_TYPE", 2);
                    in1.putExtra("android.bluetooth.devicepicker.extra.LAUNCH_PACKAGE", "com.android.bluetooth");
                    in1.putExtra("android.bluetooth.devicepicker.extra.DEVICE_PICKER_LAUNCH_CLASS", BluetoothOppReceiver.class.getName());
                    this.startActivity(in1);
                }
                break block10;
            }
            if (action.equals("android.btopp.intent.action.OPEN")) {
                Uri uri = this.getIntent().getData();
                Intent intent1 = new Intent();
                intent1.setAction(action);
                intent1.setClassName("com.android.bluetooth", BluetoothOppReceiver.class.getName());
                intent1.setData(uri);
                this.sendBroadcast(intent1);
            }
        }
        this.finish();
    }

    private final boolean isAirplaneModeOn() {
        return Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"airplane_mode_on", (int)0) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Uri creatFileForSharedContent(Context context, CharSequence shareContent) {
        if (shareContent == null) {
            return null;
        }
        Uri fileUri = null;
        FileOutputStream outStream = null;
        try {
            String fileName = this.getString(2130968668) + ".html";
            context.deleteFile(fileName);
            String uri = ((Object)shareContent).toString();
            String content = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/></head><body><a href=\"" + uri + "\">" + uri + "</a></p>" + "</body></html>";
            byte[] byteBuff = content.getBytes();
            outStream = context.openFileOutput(fileName, 0);
            if (outStream != null) {
                outStream.write(byteBuff, 0, byteBuff.length);
                fileUri = Uri.fromFile((File)new File(context.getFilesDir(), fileName));
                if (fileUri != null) {
                    // empty if block
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("FileNotFoundException: " + e.toString()));
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("IOException: " + e.toString()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e.toString()));
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileUri;
    }
}

