/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.format.Formatter;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.android.bluetooth.opp.BluetoothOppTransferInfo;
import com.android.bluetooth.opp.BluetoothOppUtility;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class BluetoothOppIncomingFileConfirmActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = "BluetoothIncomingFileConfirmActivity";
    private static final boolean D = false;
    private static final boolean V = false;
    private static final int DISMISS_TIMEOUT_DIALOG = 0;
    private static final int DISMISS_TIMEOUT_DIALOG_VALUE = 2000;
    private static final String PREFERENCE_USER_TIMEOUT = "user_timeout";
    private BluetoothOppTransferInfo mTransInfo;
    private Uri mUri;
    private ContentValues mUpdateValues;
    private TextView mContentView;
    private boolean mTimeout = false;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!"android.btopp.intent.action.USER_CONFIRMATION_TIMEOUT".equals(intent.getAction())) {
                return;
            }
            BluetoothOppIncomingFileConfirmActivity.this.onTimeout();
        }
    };
    private final Handler mTimeoutHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BluetoothOppIncomingFileConfirmActivity.this.finish();
                    break;
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mUri = intent.getData();
        this.mTransInfo = new BluetoothOppTransferInfo();
        this.mTransInfo = BluetoothOppUtility.queryRecord((Context)this, this.mUri);
        if (this.mTransInfo == null) {
            this.finish();
            return;
        }
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2130968588);
        p.mView = this.createView();
        p.mPositiveButtonText = this.getString(2130968591);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(2130968590);
        p.mNegativeButtonListener = this;
        this.setupAlert();
        if (this.mTimeout) {
            this.onTimeout();
        }
        this.registerReceiver(this.mReceiver, new IntentFilter("android.btopp.intent.action.USER_CONFIRMATION_TIMEOUT"));
    }

    private View createView() {
        View view = this.getLayoutInflater().inflate(2130903045, null);
        this.mContentView = (TextView)view.findViewById(2131099659);
        String text = this.getString(2130968589, new Object[]{this.mTransInfo.mDeviceName, this.mTransInfo.mFileName, Formatter.formatFileSize((Context)this, (long)this.mTransInfo.mTotalBytes)});
        this.mContentView.setText((CharSequence)text);
        return view;
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mTimeout) break;
                this.mUpdateValues = new ContentValues();
                this.mUpdateValues.put("confirm", Integer.valueOf(1));
                this.getContentResolver().update(this.mUri, this.mUpdateValues, null, null);
                Toast.makeText((Context)this, (CharSequence)this.getString(2130968634), (int)0).show();
                break;
            }
            case -2: {
                this.mUpdateValues = new ContentValues();
                this.mUpdateValues.put("confirm", Integer.valueOf(3));
                this.getContentResolver().update(this.mUri, this.mUpdateValues, null, null);
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mUpdateValues = new ContentValues();
            this.mUpdateValues.put("visibility", Integer.valueOf(1));
            this.getContentResolver().update(this.mUri, this.mUpdateValues, null, null);
            Toast.makeText((Context)this, (CharSequence)this.getString(2130968635), (int)0).show();
            this.finish();
        }
        return true;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mReceiver);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.mTimeout = savedInstanceState.getBoolean(PREFERENCE_USER_TIMEOUT);
        if (this.mTimeout) {
            this.onTimeout();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(PREFERENCE_USER_TIMEOUT, this.mTimeout);
    }

    private void onTimeout() {
        this.mTimeout = true;
        this.mContentView.setText((CharSequence)this.getString(2130968593, new Object[]{this.mTransInfo.mDeviceName}));
        this.mAlert.getButton(-2).setVisibility(8);
        this.mAlert.getButton(-1).setText((CharSequence)this.getString(2130968592));
        this.mTimeoutHandler.sendMessageDelayed(this.mTimeoutHandler.obtainMessage(0), 2000L);
    }
}

