/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.android.bluetooth.opp.BluetoothOppManager;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class BluetoothOppBtEnablingActivity
extends AlertActivity {
    private static final String TAG = "BluetoothOppEnablingActivity";
    private static final boolean D = false;
    private static final boolean V = false;
    private static final int BT_ENABLING_TIMEOUT = 0;
    private static final int BT_ENABLING_TIMEOUT_VALUE = 20000;
    private final Handler mTimeoutHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BluetoothOppBtEnablingActivity.this.cancelSendingProgress();
                    break;
                }
            }
        }
    };
    private final BroadcastReceiver mBluetoothReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                switch (intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) {
                    case 12: {
                        BluetoothOppBtEnablingActivity.this.mTimeoutHandler.removeMessages(0);
                        BluetoothOppBtEnablingActivity.this.finish();
                        break;
                    }
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        this.registerReceiver(this.mBluetoothReceiver, filter);
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301659;
        p.mTitle = this.getString(2130968632);
        p.mView = this.createView();
        this.setupAlert();
        this.mTimeoutHandler.sendMessageDelayed(this.mTimeoutHandler.obtainMessage(0), 20000L);
    }

    private View createView() {
        View view = this.getLayoutInflater().inflate(2130903044, null);
        TextView contentView = (TextView)view.findViewById(2131099658);
        contentView.setText((CharSequence)this.getString(2130968633));
        return view;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mTimeoutHandler.removeMessages(0);
            this.cancelSendingProgress();
        }
        return true;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mBluetoothReceiver);
    }

    private void cancelSendingProgress() {
        BluetoothOppManager mOppManager = BluetoothOppManager.getInstance((Context)this);
        if (mOppManager.mSendingFlag) {
            mOppManager.mSendingFlag = false;
        }
        this.finish();
    }
}

