/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.opp;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import com.android.bluetooth.opp.BluetoothOppShareInfo;
import com.android.bluetooth.opp.Constants;
import com.google.android.collect.Lists;
import java.io.File;
import java.util.ArrayList;

public class BluetoothOppBatch {
    private static final String TAG = "BtOppBatch";
    private static final boolean D = false;
    private static final boolean V = false;
    public int mId;
    public int mStatus;
    public final long mTimestamp;
    public final int mDirection;
    public final BluetoothDevice mDestination;
    private BluetoothOppBatchListener mListener;
    private final ArrayList<BluetoothOppShareInfo> mShares;
    private final Context mContext;

    public BluetoothOppBatch(Context context, BluetoothOppShareInfo info) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        this.mContext = context;
        this.mShares = Lists.newArrayList();
        this.mTimestamp = info.mTimestamp;
        this.mDirection = info.mDirection;
        this.mDestination = adapter.getRemoteDevice(info.mDestination);
        this.mStatus = 0;
        this.mShares.add(info);
    }

    public void addShare(BluetoothOppShareInfo info) {
        this.mShares.add(info);
        if (this.mListener != null) {
            this.mListener.onShareAdded(info.mId);
        }
    }

    public void deleteShare(BluetoothOppShareInfo info) {
        if (info.mStatus == 192) {
            info.mStatus = 490;
            if (info.mDirection == 1 && info.mFilename != null) {
                new File(info.mFilename).delete();
            }
        }
        if (this.mListener != null) {
            this.mListener.onShareDeleted(info.mId);
        }
    }

    public void cancelBatch() {
        if (this.mListener != null) {
            this.mListener.onBatchCanceled();
        }
        for (int i = this.mShares.size() - 1; i >= 0; --i) {
            BluetoothOppShareInfo info = this.mShares.get(i);
            if (info.mStatus >= 200) continue;
            if (info.mDirection == 1 && info.mFilename != null) {
                new File(info.mFilename).delete();
            }
            Constants.updateShareStatus(this.mContext, info.mId, 490);
        }
        this.mShares.clear();
    }

    public boolean hasShare(BluetoothOppShareInfo info) {
        return this.mShares.contains(info);
    }

    public boolean isEmpty() {
        return this.mShares.size() == 0;
    }

    public void registerListern(BluetoothOppBatchListener listener) {
        this.mListener = listener;
    }

    public BluetoothOppShareInfo getPendingShare() {
        for (int i = 0; i < this.mShares.size(); ++i) {
            BluetoothOppShareInfo share = this.mShares.get(i);
            if (share.mStatus != 190) continue;
            return share;
        }
        return null;
    }

    public static interface BluetoothOppBatchListener {
        public void onShareAdded(int var1);

        public void onShareDeleted(int var1);

        public void onBatchCanceled();
    }
}

