/*
 * Decompiled with CFR 0.152.
 */
package org.jheer;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class XMLWriter {
    private FileWriter m_out;
    private int m_bias = 0;
    private int m_tab;
    private ArrayList m_tagStack = new ArrayList();
    private static final char LOWER_RANGE = ' ';
    private static final char UPPER_RANGE = '\u007f';
    private static final char[] VALID_CHARS = new char[]{'\t', '\n', '\r'};
    private static final char[] INVALID = new char[]{'<', '>', '\"', '\'', '&'};
    private static final String[] VALID = new String[]{"&lt;", "&gt;", "&quot;", "&apos;", "&amp;"};

    public XMLWriter(FileWriter out) {
        this(out, 2);
    }

    public XMLWriter(FileWriter out, int tabLength) {
        this.m_out = out;
        this.m_tab = 2;
    }

    public void write(String s) throws IOException {
        this.m_out.write(s);
    }

    public void writeln(String s) throws IOException {
        this.m_out.write(s);
        this.m_out.write("\n");
    }

    public void writeln() throws IOException {
        this.m_out.write("\n");
    }

    public void begin() throws IOException {
        this.m_out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeln();
    }

    public void begin(String header, int bias) throws IOException {
        this.begin();
        this.m_out.write(header);
        this.m_bias = bias;
    }

    public void comment(String comment) throws IOException {
        this.spacing();
        this.m_out.write("<!-- ");
        this.m_out.write(comment);
        this.m_out.write(" -->");
        this.writeln();
    }

    protected void tag(String tag, String[] names, String[] values, int nattr, boolean close) throws IOException {
        this.spacing();
        this.m_out.write(60);
        this.m_out.write(tag);
        for (int i = 0; i < nattr; ++i) {
            this.m_out.write(32);
            this.m_out.write(names[i]);
            this.m_out.write(61);
            this.m_out.write(34);
            this.escapeString(values[i]);
            this.m_out.write(34);
        }
        if (close) {
            this.m_out.write(47);
        }
        this.m_out.write(62);
        this.writeln();
        if (!close) {
            this.m_tagStack.add(tag);
        }
    }

    public void tag(String tag, String[] names, String[] values, int nattr) throws IOException {
        this.tag(tag, names, values, nattr, true);
    }

    public void start(String tag, String[] names, String[] values, int nattr) throws IOException {
        this.tag(tag, names, values, nattr, false);
    }

    public void addAttribute(String name, String value) throws IOException {
        this.spacing();
        this.m_out.write(name);
        this.m_out.write(61);
        this.m_out.write(34);
        this.escapeString(value);
        this.m_out.write(34);
        this.writeln();
    }

    protected void tag(String tag, String name, String value, boolean close) throws IOException {
        this.spacing();
        this.m_out.write(60);
        this.m_out.write(tag);
        this.m_out.write(32);
        this.m_out.write(name);
        this.m_out.write(61);
        this.m_out.write(34);
        this.escapeString(value);
        this.m_out.write(34);
        if (close) {
            this.m_out.write(47);
        }
        this.m_out.write(62);
        this.writeln();
        if (!close) {
            this.m_tagStack.add(tag);
        }
    }

    public void tag(String tag, String name, String value) throws IOException {
        this.tag(tag, name, value, true);
    }

    public void start(String tag, String name, String value) throws IOException {
        this.tag(tag, name, value, false);
    }

    protected void tag(String tag, ArrayList names, ArrayList values, int nattr, boolean close) throws IOException {
        this.spacing();
        this.m_out.write(60);
        this.m_out.write(tag);
        for (int i = 0; i < nattr; ++i) {
            this.m_out.write(32);
            this.m_out.write((String)names.get(i));
            this.m_out.write(61);
            this.m_out.write(34);
            this.escapeString((String)values.get(i));
            this.m_out.write(34);
        }
        if (close) {
            this.m_out.write(47);
        }
        this.m_out.write(62);
        this.writeln();
        if (!close) {
            this.m_tagStack.add(tag);
        }
    }

    public void tag(String tag, ArrayList names, ArrayList values, int nattr) throws IOException {
        this.tag(tag, names, values, nattr, true);
    }

    public void start(String tag, ArrayList names, ArrayList values, int nattr) throws IOException {
        this.tag(tag, names, values, nattr, false);
    }

    public void start(String tag) throws IOException {
        this.tag(tag, (String[])null, null, 0, false);
    }

    public void end() throws IOException {
        String tag = (String)this.m_tagStack.remove(this.m_tagStack.size() - 1);
        this.spacing();
        this.m_out.write(60);
        this.m_out.write(47);
        this.m_out.write(tag);
        this.m_out.write(62);
        this.writeln();
    }

    public void contentTag(String tag, String name, String value, String content) throws IOException {
        this.spacing();
        this.m_out.write(60);
        this.m_out.write(tag);
        this.m_out.write(32);
        this.m_out.write(name);
        this.m_out.write(61);
        this.m_out.write(34);
        this.escapeString(value);
        this.m_out.write(34);
        this.m_out.write(62);
        this.escapeString(content);
        this.m_out.write(60);
        this.m_out.write(47);
        this.m_out.write(tag);
        this.m_out.write(62);
        this.writeln();
    }

    public void contentTag(String tag, String content) throws IOException {
        this.spacing();
        this.m_out.write(60);
        this.m_out.write(tag);
        this.m_out.write(62);
        this.escapeString(content);
        this.m_out.write(60);
        this.m_out.write(47);
        this.m_out.write(tag);
        this.m_out.write(62);
        this.writeln();
    }

    public void content(String content) throws IOException {
        this.escapeString(content);
    }

    public void finish() throws IOException {
        this.m_bias = 0;
        this.m_out.flush();
    }

    public void finish(String footer) throws IOException {
        this.m_bias = 0;
        this.m_out.write(footer);
        this.m_out.flush();
    }

    public void spacing() throws IOException {
        int len = this.m_bias + this.m_tagStack.size() * this.m_tab;
        for (int i = 0; i < len; ++i) {
            this.m_out.write(32);
        }
    }

    protected void escapeString(String str) throws IOException {
        if (str == null) {
            this.m_out.write("null");
            return;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < ' ' && c != VALID_CHARS[0] && c != VALID_CHARS[1] && c != VALID_CHARS[2] || c > '\u007f') {
                this.m_out.write("&#");
                this.m_out.write(Integer.toString(c));
                this.m_out.write(59);
                continue;
            }
            boolean valid = true;
            for (int j = INVALID.length - 1; j >= 0; --j) {
                if (INVALID[j] != c) continue;
                valid = false;
                this.m_out.write(VALID[j]);
                break;
            }
            if (!valid) continue;
            this.m_out.write(c);
        }
    }
}

