/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.testdefs;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.AbstractRemoteTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.testtype.testdefs.InstrumentationTestDef;
import com.android.tradefed.testtype.testdefs.XmlDefsParser;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDefsTest
extends AbstractRemoteTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "XmlDefsTest";
    private ITestDevice mDevice;
    @Option(name="timeout", description="Fail any test that takes longer than the specified number of milliseconds ")
    private long mTestTimeout = 600000L;
    @Option(name="size", description="Restrict tests to a specific test size")
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun non-executed tests individually if test run fails to complete")
    private boolean mIsRerunMode = true;
    @Option(name="local-file-path", description="local file path to test_defs.xml file to run")
    private Collection<File> mLocalFiles = new ArrayList<File>();
    @Option(name="device-file-path", description="file path on device to test_defs.xml file to run")
    private Collection<String> mRemotePaths = new ArrayList<String>();

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    void addRemoteFilePath(String path) {
        this.mRemotePaths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mLocalFiles.isEmpty() && this.mRemotePaths.isEmpty()) {
            throw new IllegalArgumentException("No test definition files (local-file-path or device-file-path) have been provided.");
        }
        this.mLocalFiles.addAll(this.getRemoteFile(this.mRemotePaths));
        XmlDefsParser parser = this.createParser();
        for (File testDefFile : this.mLocalFiles) {
            try {
                Log.i((String)LOG_TAG, (String)String.format("Parsing test def file %s", testDefFile.getAbsolutePath()));
                parser.parse(new FileInputStream(testDefFile));
            }
            catch (FileNotFoundException e) {
                Log.e((String)LOG_TAG, (String)String.format("Could not find test def file %s", testDefFile.getAbsolutePath()));
            }
            catch (AbstractXmlParser.ParseException e) {
                Log.e((String)LOG_TAG, (String)String.format("Could not parse test def file %s: %s", testDefFile.getAbsolutePath(), e.getMessage()));
            }
            finally {
                testDefFile.delete();
            }
        }
        for (InstrumentationTestDef def : parser.getTestDefs()) {
            if (!def.isContinuous()) continue;
            Log.d((String)LOG_TAG, (String)String.format("Running test def %s on %s", def.getName(), this.getDevice().getSerialNumber()));
            InstrumentationTest test = this.createInstrumentationTest();
            test.setDevice(this.getDevice());
            test.setPackageName(def.getPackage());
            if (def.getRunner() != null) {
                test.setRunnerName(def.getRunner());
            }
            if (def.getClassName() != null) {
                test.setClassName(def.getClassName());
            }
            test.setRerunMode(this.isRerunMode());
            test.setTestSize(this.getTestSize());
            test.setTestTimeout(this.getTestTimeout());
            test.run(listeners);
        }
    }

    private Collection<File> getRemoteFile(Collection<String> remoteFilePaths) throws DeviceNotAvailableException {
        ArrayList<File> files = new ArrayList<File>();
        for (String remoteFilePath : remoteFilePaths) {
            try {
                File tmpFile = FileUtil.createTempFile("test_defs_", ".xml");
                this.getDevice().pullFile(remoteFilePath, tmpFile);
                files.add(tmpFile);
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)"Failed to create temp file");
                Log.e((String)LOG_TAG, (Throwable)e);
            }
        }
        return files;
    }

    long getTestTimeout() {
        return this.mTestTimeout;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    boolean isRerunMode() {
        return this.mIsRerunMode;
    }

    XmlDefsParser createParser() {
        return new XmlDefsParser();
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }
}

