/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.AbstractRemoteTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.NativeStressTestParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeStressTest
extends AbstractRemoteTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "NativeStressTest";
    static final String DEFAULT_TEST_PATH = "data/nativestresstest";
    static final String AVG_ITERATION_TIME_KEY = "avg-iteration-time";
    static final String ITERATION_KEY = "iterations";
    private ITestDevice mDevice = null;
    @Option(name="native-stress-device-path", description="The path on the device where native stress tests are located.")
    private String mDeviceTestPath = "data/nativestresstest";
    @Option(name="stress-module-name", description="The name of the native test module to run. If not specified all tests in --native-stress-device-path will be run")
    private String mTestModule = null;
    @Option(name="iterations", description="The number of stress test iterations per run.")
    private int mNumIterations = -1;
    @Option(name="runs", description="The number of stress test runs to perform. Default 1.")
    private int mNumRuns = 1;
    @Option(name="max-iteration-time", description="The maximum time to allow for one stress test iteration in ms. Default is 5 min.")
    private int mMaxIterationTime = 300000;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String moduleName) {
        this.mTestModule = moduleName;
    }

    public String getModuleName(String moduleName) {
        return this.mTestModule;
    }

    void setNumIterations(int iterations) {
        this.mNumIterations = iterations;
    }

    void setNumRuns(int runs) {
        this.mNumRuns = runs;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mDeviceTestPath);
        if (this.mTestModule != null) {
            testPath.append("/");
            testPath.append(this.mTestModule);
        }
        return testPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAllTestsInSubdirectory(IFileEntry rootEntry, ITestDevice testDevice, Collection<ITestRunListener> listeners) throws DeviceNotAvailableException {
        if (rootEntry.isDirectory()) {
            for (IFileEntry childEntry : rootEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(childEntry, testDevice, listeners);
            }
        } else {
            NativeStressTestParser resultParser = this.createResultParser(rootEntry.getName());
            String fullPath = rootEntry.getFullEscapedPath();
            Log.i((String)LOG_TAG, (String)String.format("Running native stress test %s on %s", fullPath, this.mDevice.getSerialNumber()));
            testDevice.executeShellCommand(String.format("chmod 755 %s", fullPath));
            int startIteration = 0;
            int endIteration = this.mNumIterations - 1;
            long startTime = System.currentTimeMillis();
            for (ITestRunListener listener : listeners) {
                listener.testRunStarted(resultParser.getRunName(), 0);
            }
            try {
                for (int i = 0; i < this.mNumRuns; ++i) {
                    testDevice.executeShellCommand(String.format("%s -s %d -e %d", fullPath, startIteration, endIteration), (IShellOutputReceiver)resultParser, this.mMaxIterationTime, 1);
                    startIteration += this.mNumIterations;
                    endIteration += this.mNumIterations;
                }
            }
            finally {
                this.reportTestCompleted(startTime, listeners, resultParser);
            }
        }
    }

    private void reportTestCompleted(long startTime, Collection<ITestRunListener> listeners, NativeStressTestParser parser) {
        long elapsedTime = System.currentTimeMillis() - startTime;
        int iterationsComplete = parser.getIterationsCompleted();
        float avgIterationTime = iterationsComplete > 0 ? (float)(elapsedTime / (long)iterationsComplete) : 0.0f;
        HashMap<String, String> metricMap = new HashMap<String, String>(2);
        Log.i((String)LOG_TAG, (String)String.format("Stress test %s is finished. Num iterations %d, avg time %f ms", parser.getRunName(), iterationsComplete, Float.valueOf(avgIterationTime)));
        metricMap.put(ITERATION_KEY, Integer.toString(iterationsComplete));
        metricMap.put(AVG_ITERATION_TIME_KEY, Float.toString(avgIterationTime));
        for (ITestRunListener listener : listeners) {
            listener.testRunEnded(elapsedTime, metricMap);
        }
    }

    NativeStressTestParser createResultParser(String runName) {
        return new NativeStressTestParser(runName);
    }

    @Override
    public void run(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mNumIterations <= 0) {
            throw new IllegalArgumentException("number of iterations has not been set");
        }
        String testPath = this.getTestPath();
        IFileEntry nativeTestDirectory = this.mDevice.getFileEntry(testPath);
        if (nativeTestDirectory == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find native stress test directory %s in %s!", testPath, this.mDevice.getSerialNumber()));
        }
        this.doRunAllTestsInSubdirectory(nativeTestDirectory, this.mDevice, this.convertListeners(listeners));
    }

    private Collection<ITestRunListener> convertListeners(List<ITestInvocationListener> listeners) {
        ArrayList<ITestRunListener> copy = new ArrayList<ITestRunListener>(listeners.size());
        copy.addAll(listeners);
        return copy;
    }
}

