/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.testtype.DeviceTestSuite;
import com.android.tradefed.testtype.IDeviceTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostTest
implements IDeviceTest {
    @Option(name="class", description="The JUnit Test to run")
    private String mClassName;
    @Option(name="method", description="The JUnit TestCase method to run")
    private String mMethodName;
    private ITestDevice mDevice = null;

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public int countTestCases() {
        return 1;
    }

    void setClassName(String className) {
        this.mClassName = className;
    }

    void setMethodName(String methodName) {
        this.mMethodName = methodName;
    }

    @Override
    public void run(TestResult result) {
        if (this.mClassName == null) {
            throw new IllegalArgumentException("Missing Test class name");
        }
        Class<?> classObj = this.loadTestClass(this.mClassName);
        Test test = this.loadTest(classObj);
        if (test instanceof IDeviceTest) {
            if (this.mDevice == null) {
                throw new IllegalArgumentException("Missing device");
            }
            ((IDeviceTest)test).setDevice(this.mDevice);
        }
        if (test instanceof TestCase) {
            TestCase testCase = (TestCase)test;
            if (this.mMethodName != null) {
                testCase.setName(this.mMethodName);
            } else {
                DeviceTestSuite testSuite = new DeviceTestSuite();
                testSuite.addTestSuite(classObj);
                testSuite.setDevice(this.mDevice);
                test = testSuite;
            }
        }
        test.run(result);
    }

    private Class<?> loadTestClass(String className) throws IllegalArgumentException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
    }

    private Test loadTest(Class<?> classObj) throws IllegalArgumentException {
        String className = classObj.getName();
        try {
            Object testObject = classObj.newInstance();
            if (!(testObject instanceof Test)) {
                throw new IllegalArgumentException(String.format("%s is not a Test", className));
            }
            return (Test)testObject;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
    }
}

