/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTestResultParser
extends MultiLineReceiver {
    private static final String LOG_TAG = "GTestResultParser";
    private TestResult mCurrentTestResult = null;
    private int mNumTestsRun = 0;
    private int mNumTestsExpected = 0;
    private long mTotalRunTime = 0L;
    private boolean mTestInProgress = false;
    private boolean mTestRunInProgress = false;
    private final String mTestRunName;
    private final Collection<ITestRunListener> mTestListeners;
    private boolean mTestRunStartReported = false;
    private boolean mIsCancelled = false;

    public GTestResultParser(String testRunName, Collection<ITestRunListener> listeners) {
        this.mTestRunName = testRunName;
        this.mTestListeners = new ArrayList<ITestRunListener>(listeners);
    }

    public GTestResultParser(String testRunName, ITestRunListener listener) {
        this.mTestRunName = testRunName;
        this.mTestListeners = new ArrayList<ITestRunListener>(1);
        this.mTestListeners.add(listener);
    }

    private TestResult getCurrentTestResult() {
        if (this.mCurrentTestResult == null) {
            this.mCurrentTestResult = new TestResult();
        }
        return this.mCurrentTestResult;
    }

    private void clearCurrentTestResult() {
        this.mCurrentTestResult = null;
    }

    public void processNewLines(String[] lines) {
        for (String line : lines) {
            this.parse(line);
            Log.v((String)LOG_TAG, (String)line);
        }
    }

    private void parse(String line) {
        String message = null;
        if (this.mTestRunInProgress || line.startsWith("[==========]")) {
            if (line.startsWith("[ RUN      ]")) {
                message = line.substring("[ RUN      ]".length()).trim();
                this.processTestStartedTag(message);
            } else if (line.startsWith("[       OK ]")) {
                message = line.substring("[       OK ]".length()).trim();
                this.processOKTag(message);
                this.clearCurrentTestResult();
            } else if (line.startsWith("[  FAILED  ]")) {
                message = line.substring("[  FAILED  ]".length()).trim();
                this.processFailedTag(message);
                this.clearCurrentTestResult();
            } else if (line.startsWith("[==========] Running")) {
                message = line.substring("[==========]".length()).trim();
                this.processRunStartedTag(message);
            } else if (line.startsWith("[==========]")) {
                message = line.substring("[==========]".length()).trim();
                this.processRunCompletedTag(message);
            } else if (this.testInProgress()) {
                this.appendTestOutputLine(line);
            }
        }
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    private boolean testInProgress() {
        return this.mTestInProgress;
    }

    private void setTestStarted() {
        this.mTestInProgress = true;
    }

    private void setTestEnded() {
        this.mTestInProgress = false;
    }

    private void reportTestRunStarted() {
        if (!this.mTestRunStartReported) {
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testRunStarted(this.mTestRunName, this.mNumTestsExpected);
            }
            this.mTestRunStartReported = true;
        }
    }

    private void reportTestRunEnded() {
        Map emptyMap = Collections.emptyMap();
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunEnded(this.mTotalRunTime, emptyMap);
        }
        this.mTestRunStartReported = false;
    }

    private ParsedTestInfo parseTestIdentifier(String identifier) {
        String[] testId;
        ParsedTestInfo returnInfo = new ParsedTestInfo("UNKNOWN_CLASS", "UNKNOWN_TEST", null);
        Pattern timePattern = Pattern.compile(".*(\\((\\d+) ms\\))");
        Matcher time = timePattern.matcher(identifier);
        if (time.find()) {
            String timeString = time.group(2);
            String discardPortion = time.group(1);
            identifier = identifier.substring(0, identifier.lastIndexOf(discardPortion)).trim();
            returnInfo.mTestRunTime = timeString;
        }
        if ((testId = identifier.split("\\.")).length < 2) {
            Log.e((String)LOG_TAG, (String)("Could not detect the test class and test name, received: " + identifier));
        } else {
            returnInfo.mTestClassName = testId[0];
            returnInfo.mTestName = testId[1];
        }
        return returnInfo;
    }

    private void processRunStartedTag(String identifier) {
        Pattern numTestsPattern = Pattern.compile("Running (\\d+) test[s]? from .*");
        Matcher numTests = numTestsPattern.matcher(identifier);
        if (numTests.find()) {
            try {
                this.mNumTestsExpected = Integer.parseInt(numTests.group(1));
            }
            catch (NumberFormatException e) {
                Log.e((String)LOG_TAG, (String)("Unable to determine number of tests expected, received: " + numTests.group(1)));
            }
        }
        if (this.mNumTestsExpected > 0) {
            this.reportTestRunStarted();
            this.mNumTestsRun = 0;
            this.mTestRunInProgress = true;
        }
    }

    private void processRunCompletedTag(String identifier) {
        Pattern timePattern = Pattern.compile(".*\\((\\d+) ms total\\)");
        Matcher time = timePattern.matcher(identifier);
        if (time.find()) {
            try {
                this.mTotalRunTime = Long.parseLong(time.group(1));
            }
            catch (NumberFormatException e) {
                Log.e((String)LOG_TAG, (String)("Unable to determine the total running time, received: " + time.group(1)));
            }
        }
        this.reportTestRunEnded();
        this.mTestRunInProgress = false;
    }

    private void processTestStartedTag(String identifier) {
        ParsedTestInfo parsedResults = this.parseTestIdentifier(identifier);
        TestResult testResult = this.getCurrentTestResult();
        testResult.mTestClass = parsedResults.mTestClassName;
        testResult.mTestName = parsedResults.mTestName;
        TestIdentifier testId = new TestIdentifier(testResult.mTestClass, testResult.mTestName);
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testStarted(testId);
        }
        this.setTestStarted();
    }

    private void doTestEnded(String identifier, boolean testPassed) {
        ParsedTestInfo parsedResults = this.parseTestIdentifier(identifier);
        TestResult testResult = this.getCurrentTestResult();
        TestIdentifier testId = new TestIdentifier(testResult.mTestClass, testResult.mTestName);
        if (!this.testInProgress()) {
            Log.e((String)LOG_TAG, (String)("Test currently not in progress when trying to end test: " + identifier));
            return;
        }
        if (parsedResults.mTestRunTime != null) {
            try {
                testResult.mRunTime = new Long(parsedResults.mTestRunTime);
            }
            catch (NumberFormatException e) {
                Log.e((String)LOG_TAG, (String)("Test run time value is invalid, received: " + parsedResults.mTestRunTime));
            }
        }
        boolean encounteredUnexpectedTest = false;
        if (!testResult.isComplete()) {
            Log.e((String)LOG_TAG, (String)"No test/class name is currently recorded as running!");
        } else {
            if (testResult.mTestClass.compareTo(parsedResults.mTestClassName) != 0) {
                Log.e((String)LOG_TAG, (String)("Name for current test class does not match class we started with, expected: " + testResult.mTestClass + " but got: " + parsedResults.mTestClassName));
                encounteredUnexpectedTest = true;
            }
            if (testResult.mTestName.compareTo(parsedResults.mTestName) != 0) {
                Log.e((String)LOG_TAG, (String)("Name for current test does not match test we started with,expected: " + testResult.mTestName + " bug got: " + parsedResults.mTestName));
                encounteredUnexpectedTest = true;
            }
        }
        if (encounteredUnexpectedTest) {
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testFailed(ITestRunListener.TestFailure.ERROR, testId, this.mCurrentTestResult.getTrace());
            }
        } else if (!testPassed) {
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testFailed(ITestRunListener.TestFailure.FAILURE, testId, this.mCurrentTestResult.getTrace());
            }
        }
        Map emptyMap = Collections.emptyMap();
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testEnded(testId, emptyMap);
        }
        this.setTestEnded();
        ++this.mNumTestsRun;
    }

    private void processOKTag(String identifier) {
        this.doTestEnded(identifier, true);
    }

    private void processFailedTag(String identifier) {
        this.doTestEnded(identifier, false);
    }

    private void appendTestOutputLine(String line) {
        TestResult testResult = this.getCurrentTestResult();
        if (testResult.mStackTrace == null) {
            testResult.mStackTrace = new StringBuilder();
        } else {
            testResult.mStackTrace.append("\r\n");
        }
        testResult.mStackTrace.append(line);
    }

    private void handleTestRunFailed(String errorMsg) {
        errorMsg = errorMsg == null ? "Unknown error" : errorMsg;
        Log.i((String)LOG_TAG, (String)String.format("Test run failed: %s", errorMsg));
        String testRunStackTrace = "";
        if (this.mCurrentTestResult != null && this.mCurrentTestResult.isComplete()) {
            TestIdentifier testId = new TestIdentifier(this.mCurrentTestResult.mTestClass, this.mCurrentTestResult.mTestName);
            Map emptyMap = Collections.emptyMap();
            if (this.mCurrentTestResult.hasStackTrace()) {
                testRunStackTrace = this.mCurrentTestResult.getTrace();
            }
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testFailed(ITestRunListener.TestFailure.ERROR, testId, "No test results.\r\n" + testRunStackTrace);
                listener.testEnded(testId, emptyMap);
            }
            this.clearCurrentTestResult();
        }
        Map emptyMap = Collections.emptyMap();
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunFailed(errorMsg);
            listener.testRunEnded(this.mTotalRunTime, emptyMap);
        }
    }

    public void done() {
        super.done();
        if (this.mNumTestsExpected > this.mNumTestsRun) {
            this.handleTestRunFailed(String.format("Test run incomplete. Expected %d tests, received %d", this.mNumTestsExpected, this.mNumTestsRun));
        } else if (this.mTestRunInProgress) {
            this.handleTestRunFailed("No test results");
        }
    }

    private static class Prefixes {
        private static final String INFORMATIONAL_MARKER = "[----------]";
        private static final String START_TEST_RUN_MARKER = "[==========] Running";
        private static final String TEST_RUN_MARKER = "[==========]";
        private static final String START_TEST_MARKER = "[ RUN      ]";
        private static final String OK_TEST_MARKER = "[       OK ]";
        private static final String FAILED_TEST_MARKER = "[  FAILED  ]";

        private Prefixes() {
        }
    }

    private static class ParsedTestInfo {
        String mTestName = null;
        String mTestClassName = null;
        String mTestRunTime = null;

        public ParsedTestInfo(String testName, String testClassName, String testRunTime) {
            this.mTestName = testName;
            this.mTestClassName = testClassName;
            this.mTestRunTime = testRunTime;
        }
    }

    private static class TestResult {
        private String mTestName = null;
        private String mTestClass = null;
        private StringBuilder mStackTrace = null;
        private Long mRunTime = null;

        private TestResult() {
        }

        boolean isComplete() {
            return this.mTestName != null && this.mTestClass != null;
        }

        boolean hasStackTrace() {
            return this.mStackTrace != null;
        }

        String getTrace() {
            if (this.hasStackTrace()) {
                return this.mStackTrace.toString();
            }
            Log.e((String)GTestResultParser.LOG_TAG, (String)"Could not find stack trace for failed test");
            return new Throwable("Unknown failure").toString();
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            if (this.mTestClass != null) {
                output.append(this.mTestClass);
                output.append('#');
            }
            if (this.mTestName != null) {
                output.append(this.mTestName);
            }
            if (output.length() > 0) {
                return output.toString();
            }
            return "unknown result";
        }
    }
}

