/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.AbstractRemoteTest;
import com.android.tradefed.testtype.GTestResultParser;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTest
extends AbstractRemoteTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "GTest";
    static final String DEFAULT_NATIVETEST_PATH = "data/nativetest";
    private ITestDevice mDevice = null;
    private boolean mRunAllTestsInAllSubdirectories = true;
    private boolean mRunDisabledTests = false;
    @Option(name="native-test-device-path", description="The path on the device where native tests are located.")
    private String mNativeTestDevicePath = "data/nativetest";
    @Option(name="module-name", description="The name of the native test module to run.")
    private String mTestModule = null;
    @Option(name="positive-testname-filter", description="The GTest-based positive filter of the test name to run.")
    private String mTestNamePositiveFilter = null;
    @Option(name="negative-testname-filter", description="The GTest-based negative filter of the test name to run.")
    private String mTestNameNegativeFilter = null;
    private static final String GTEST_FLAG_PRINT_TIME = "--gtest_print_time";
    private static final String GTEST_FLAG_FILTER = "--gtest_filter";
    private static final String GTEST_FLAG_RUN_DISABLED_TESTS = "--gtest_also_run_disabled_tests";

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setRunTestsInAllSubdirectories(boolean runAllSubTests) {
        this.mRunAllTestsInAllSubdirectories = runAllSubTests;
    }

    public void setModuleName(String moduleName) {
        this.mTestModule = moduleName;
    }

    public String getModuleName(String moduleName) {
        return this.mTestModule;
    }

    public void setRunDisabled(boolean runDisabled) {
        this.mRunDisabledTests = runDisabled;
    }

    public boolean getRunDisabledTests() {
        return this.mRunDisabledTests;
    }

    public void setTestNamePositiveFilter(String testName) {
        this.mTestNamePositiveFilter = testName;
    }

    public String getTestNamePositiveFilter() {
        return this.mTestNamePositiveFilter;
    }

    public void setTestNameNegativeFilter(String testName) {
        this.mTestNameNegativeFilter = testName;
    }

    public String getTestNameNegativeFilter() {
        return this.mTestNameNegativeFilter;
    }

    private String getGTestFilters() {
        String filter = "";
        if (this.mTestNamePositiveFilter != null || this.mTestNameNegativeFilter != null) {
            filter = "--gtest_filter=";
            if (this.mTestNamePositiveFilter != null) {
                filter = String.format("%s*.%s", filter, this.mTestNamePositiveFilter);
            }
            if (this.mTestNameNegativeFilter != null) {
                filter = String.format("%s-*.%s", filter, this.mTestNameNegativeFilter);
            }
        }
        return filter;
    }

    private String getAllGTestFlags() {
        String flags = String.format("%s %s", GTEST_FLAG_PRINT_TIME, this.getGTestFilters());
        if (this.mRunDisabledTests) {
            flags = String.format("%s %s", flags, GTEST_FLAG_RUN_DISABLED_TESTS);
        }
        return flags;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mNativeTestDevicePath);
        if (this.mTestModule != null) {
            testPath.append("/");
            testPath.append(this.mTestModule);
        }
        return testPath.toString();
    }

    void doRunAllTestsInSubdirectory(IFileEntry rootEntry, ITestDevice testDevice, Collection<ITestRunListener> listeners) throws DeviceNotAvailableException {
        if (rootEntry.isDirectory() && this.mRunAllTestsInAllSubdirectories) {
            for (IFileEntry childEntry : rootEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(childEntry, testDevice, listeners);
            }
        } else {
            IShellOutputReceiver resultParser = this.createResultParser(rootEntry.getName(), listeners);
            String fullPath = rootEntry.getFullEscapedPath();
            String flags = this.getAllGTestFlags();
            Log.i((String)LOG_TAG, (String)String.format("Running gtest %s %s on %s", fullPath, flags, this.mDevice.getSerialNumber()));
            testDevice.executeShellCommand(String.format("chmod 755 %s", fullPath));
            testDevice.executeShellCommand(String.format("%s %s", fullPath, flags), resultParser);
        }
    }

    IShellOutputReceiver createResultParser(String runName, Collection<ITestRunListener> listeners) {
        GTestResultParser resultParser = new GTestResultParser(runName, listeners);
        return resultParser;
    }

    @Override
    public void run(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String testPath = this.getTestPath();
        IFileEntry nativeTestDirectory = this.mDevice.getFileEntry(testPath);
        if (nativeTestDirectory == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find native test directory %s in %s!", testPath, this.mDevice.getSerialNumber()));
        }
        this.doRunAllTestsInSubdirectory(nativeTestDirectory, this.mDevice, this.convertListeners(listeners));
    }

    private Collection<ITestRunListener> convertListeners(List<ITestInvocationListener> listeners) {
        ArrayList<ITestRunListener> copy = new ArrayList<ITestRunListener>(listeners.size());
        copy.addAll(listeners);
        return copy;
    }
}

