/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetsetup;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetsetup.FlashingResourcesParser;
import com.android.tradefed.targetsetup.IDeviceBuildInfo;
import com.android.tradefed.targetsetup.IDeviceFlasher;
import com.android.tradefed.targetsetup.IFlashingResourcesParser;
import com.android.tradefed.targetsetup.IFlashingResourcesRetriever;
import com.android.tradefed.targetsetup.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class DeviceFlasher
implements IDeviceFlasher {
    private static final String LOG_TAG = "DeviceFlasher";
    public static final String BASEBAND_IMAGE_NAME = "radio";
    private IDeviceFlasher.UserDataFlashOption mUserDataFlashOption = IDeviceFlasher.UserDataFlashOption.FLASH;
    private Set<String> mDataWipeSkipList = new HashSet<String>();
    private final IFlashingResourcesRetriever mResourceRetriever;

    public DeviceFlasher(IFlashingResourcesRetriever resourceRetriever) {
        this.mResourceRetriever = resourceRetriever;
        this.mDataWipeSkipList.add("media");
    }

    public void setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption flashOption) {
        this.mUserDataFlashOption = flashOption;
    }

    protected IDeviceFlasher.UserDataFlashOption getUserDataFlashOption() {
        return this.mUserDataFlashOption;
    }

    public void flash(ITestDevice device, IDeviceBuildInfo deviceBuild) throws TargetSetupError, DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Flashing device %s with build %d", device.getSerialNumber(), deviceBuild.getBuildId()));
        device.rebootIntoBootloader();
        this.downloadFlashingResources(device, deviceBuild);
        this.checkAndFlashBootloader(device, deviceBuild);
        this.checkAndFlashBaseband(device, deviceBuild);
        this.flashUserData(device, deviceBuild);
        this.eraseCache(device);
        this.flashSystem(device, deviceBuild);
    }

    private void downloadFlashingResources(ITestDevice device, IDeviceBuildInfo localBuild) throws TargetSetupError, DeviceNotAvailableException {
        String basebandVersion;
        IFlashingResourcesParser resourceParser = this.createFlashingResourcesParser(localBuild);
        if (resourceParser.getRequiredBoards() == null) {
            throw new TargetSetupError(String.format("Build %s is missing required board info.", localBuild.getBuildId()));
        }
        String deviceProductType = device.getProductType();
        if (deviceProductType == null) {
            throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s", device.getSerialNumber()));
        }
        if (!resourceParser.getRequiredBoards().contains(deviceProductType)) {
            throw new TargetSetupError(String.format("Device %s is %s. Expected %s", device.getSerialNumber(), deviceProductType, resourceParser.getRequiredBoards()));
        }
        String bootloaderVersion = resourceParser.getRequiredBootloaderVersion();
        if (bootloaderVersion != null) {
            localBuild.setBootloaderImageFile(this.mResourceRetriever.retrieveFile(this.getBootloaderFilePrefix(device), bootloaderVersion), bootloaderVersion);
        }
        if ((basebandVersion = resourceParser.getRequiredBasebandVersion()) != null) {
            localBuild.setBasebandImage(this.mResourceRetriever.retrieveFile(BASEBAND_IMAGE_NAME, basebandVersion), basebandVersion);
        }
        this.downloadExtraImageFiles(resourceParser, this.mResourceRetriever, localBuild);
    }

    protected void downloadExtraImageFiles(IFlashingResourcesParser resourceParser, IFlashingResourcesRetriever retriever, IDeviceBuildInfo localBuild) throws TargetSetupError {
    }

    protected IFlashingResourcesParser createFlashingResourcesParser(IDeviceBuildInfo localBuild) throws TargetSetupError {
        return new FlashingResourcesParser(localBuild.getDeviceImageFile());
    }

    protected boolean checkAndFlashBootloader(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        String currentBootloaderVersion = this.getImageVersion(device, "bootloader");
        if (deviceBuild.getBootloaderVersion() != null && !deviceBuild.getBootloaderVersion().equals(currentBootloaderVersion)) {
            Log.i((String)LOG_TAG, (String)String.format("Flashing bootloader %s", deviceBuild.getBootloaderVersion()));
            this.flashBootloader(device, deviceBuild.getBootloaderImageFile());
            return true;
        }
        Log.i((String)LOG_TAG, (String)String.format("Bootloader is already version %s, skipping flashing", currentBootloaderVersion));
        return false;
    }

    protected void flashBootloader(ITestDevice device, File bootloaderImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.executeFastbootCmd(device, "flash", this.getBootPartitionName(), bootloaderImageFile.getAbsolutePath());
        device.rebootIntoBootloader();
    }

    protected String getBootPartitionName() {
        return "hboot";
    }

    protected String getBootloaderFilePrefix(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        return this.getBootPartitionName();
    }

    protected void checkAndFlashBaseband(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        String currentBasebandVersion = this.getImageVersion(device, "baseband");
        if (deviceBuild.getBasebandVersion() != null && !deviceBuild.getBasebandVersion().equals(currentBasebandVersion)) {
            Log.i((String)LOG_TAG, (String)String.format("Flashing baseband %s", deviceBuild.getBasebandVersion()));
            this.flashBaseband(device, deviceBuild.getBasebandImageFile());
        } else {
            Log.i((String)LOG_TAG, (String)String.format("Baseband is already version %s, skipping flashing", currentBasebandVersion));
        }
    }

    protected void flashBaseband(ITestDevice device, File basebandImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.executeLongFastbootCmd(device, "flash", BASEBAND_IMAGE_NAME, basebandImageFile.getAbsolutePath());
        device.rebootIntoBootloader();
    }

    protected void eraseCache(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (!this.mUserDataFlashOption.equals((Object)IDeviceFlasher.UserDataFlashOption.RETAIN)) {
            Log.i((String)LOG_TAG, (String)String.format("Erasing cache on %s", device.getSerialNumber()));
            this.executeFastbootCmd(device, "erase", "cache");
        } else {
            Log.d((String)LOG_TAG, (String)String.format("Skipping cache erase on %s", device.getSerialNumber()));
        }
    }

    protected void flashUserData(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        switch (this.mUserDataFlashOption) {
            case FLASH: {
                Log.i((String)LOG_TAG, (String)String.format("Flashing %s with userdata %s", device.getSerialNumber(), deviceBuild.getUserDataImageFile().getAbsolutePath()));
                this.executeLongFastbootCmd(device, "flash", "userdata", deviceBuild.getUserDataImageFile().getAbsolutePath());
                break;
            }
            case WIPE: {
                Log.i((String)LOG_TAG, (String)String.format("Wiping userdata %s", device.getSerialNumber()));
                this.executeLongFastbootCmd(device, "erase", "userdata");
                break;
            }
            case TESTS_ZIP: {
                this.pushTestsZipOntoData(device, deviceBuild);
                break;
            }
            default: {
                Log.d((String)LOG_TAG, (String)String.format("Skipping userdata flash for %s", device.getSerialNumber()));
            }
        }
    }

    protected void pushTestsZipOntoData(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        Log.i((String)LOG_TAG, (String)String.format("Pushing test zips content onto userdata on %s", device.getSerialNumber()));
        device.rebootUntilOnline();
        Log.d((String)LOG_TAG, (String)"Stopping runtime");
        device.executeShellCommand("stop");
        Log.d((String)LOG_TAG, (String)String.format("Cleaning %s", "data"));
        IFileEntry dataEntry = device.getFileEntry("data");
        if (dataEntry == null) {
            throw new TargetSetupError(String.format("Could not find %s folder on %s", "data", device.getSerialNumber()));
        }
        for (IFileEntry dataSubDir : dataEntry.getChildren(false)) {
            if (this.mDataWipeSkipList.contains(dataSubDir.getName())) continue;
            device.executeShellCommand(String.format("rm -r %s", dataSubDir.getFullEscapedPath()));
        }
        File unzipDir = null;
        try {
            File[] hostDataFiles;
            unzipDir = FileUtil.createTempDir("tests-zip_");
            this.extractZip(deviceBuild, unzipDir);
            Log.d((String)LOG_TAG, (String)"Syncing test files/apks");
            File hostDir = new File(unzipDir, "DATA");
            for (File hostSubDir : hostDataFiles = this.getTestsZipDataFiles(hostDir)) {
                device.syncFiles(hostSubDir, "data");
            }
            for (IFileEntry dataSubDir : dataEntry.getChildren(false)) {
                if (this.mDataWipeSkipList.contains(dataSubDir.getName())) continue;
                device.executeShellCommand(String.format("chown system.system %s %s/*", dataSubDir.getFullEscapedPath(), dataSubDir.getFullEscapedPath()));
            }
            device.rebootIntoBootloader();
        }
        catch (IOException e) {
            throw new TargetSetupError(e.getMessage());
        }
        finally {
            FileUtil.recursiveDelete(unzipDir);
        }
    }

    File[] getTestsZipDataFiles(File hostDir) throws TargetSetupError {
        if (!hostDir.isDirectory()) {
            throw new TargetSetupError("Unrecognized tests.zip content: missing DATA folder");
        }
        File[] childFiles = hostDir.listFiles();
        if (childFiles == null || childFiles.length <= 0) {
            throw new TargetSetupError("Unrecognized tests.zip content: DATA folder has no content");
        }
        return childFiles;
    }

    void extractZip(IDeviceBuildInfo deviceBuild, File unzipDir) throws IOException, ZipException, TargetSetupError {
        if (deviceBuild.getTestsZipFile() == null) {
            throw new TargetSetupError("Missing tests.zip file");
        }
        FileUtil.extractZip(new ZipFile(deviceBuild.getTestsZipFile()), unzipDir);
    }

    protected void flashSystem(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        Log.i((String)LOG_TAG, (String)String.format("Flashing %s with update %s", device.getSerialNumber(), deviceBuild.getDeviceImageFile().getAbsolutePath()));
        this.executeLongFastbootCmd(device, "update", deviceBuild.getDeviceImageFile().getAbsolutePath());
    }

    protected String getImageVersion(ITestDevice device, String imageName) throws DeviceNotAvailableException, TargetSetupError {
        String versionQuery = String.format("version-%s", imageName);
        String queryOutput = this.executeFastbootCmd(device, "getvar", versionQuery);
        String patternString = String.format("%s:\\s(.*)\\s", versionQuery);
        Pattern versionOutputPattern = Pattern.compile(patternString);
        Matcher matcher = versionOutputPattern.matcher(queryOutput);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new TargetSetupError(String.format("Could not find version for '%s'. Output '%s'", imageName, queryOutput));
    }

    protected String executeFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        CommandResult result = device.executeFastbootCommand(cmdArgs);
        return this.handleFastbootResult(device, result, cmdArgs);
    }

    protected String executeLongFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        CommandResult result = device.executeLongFastbootCommand(cmdArgs);
        return this.handleFastbootResult(device, result, cmdArgs);
    }

    private String handleFastbootResult(ITestDevice device, CommandResult result, String ... cmdArgs) throws TargetSetupError {
        if (result.getStatus() != CommandStatus.SUCCESS || result.getStderr().contains("FAILED")) {
            throw new TargetSetupError(String.format("fastboot command %s failed in device %s. stdout: %s, stderr: %s", cmdArgs[0], device.getSerialNumber(), result.getStdout(), result.getStderr()));
        }
        if (result.getStderr().length() > 0) {
            return result.getStderr();
        }
        return result.getStdout();
    }
}

