/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetsetup;

import com.android.tradefed.targetsetup.BuildInfo;
import com.android.tradefed.targetsetup.IDeviceBuildInfo;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;

public class DeviceBuildInfo
extends BuildInfo
implements IDeviceBuildInfo {
    private Map<String, ImageFile> mImageFileMap = new Hashtable<String, ImageFile>();
    private static final String DEVICE_IMAGE_NAME = "device";
    private static final String USERDATA_IMAGE_NAME = "userdata";
    private static final String TESTZIP_IMAGE_NAME = "testszip";
    private static final String BASEBAND_IMAGE_NAME = "baseband";
    private static final String BOOTLOADER_IMAGE_NAME = "bootloader";

    public DeviceBuildInfo(int buildId, String testTarget, String buildName) {
        super(buildId, testTarget, buildName);
    }

    public File getImageFile(String imageName) {
        ImageFile imgFileRecord = this.mImageFileMap.get(imageName);
        if (imgFileRecord != null) {
            return imgFileRecord.getImageFile();
        }
        return null;
    }

    public String getImageVersion(String imageName) {
        ImageFile imgFileRecord = this.mImageFileMap.get(imageName);
        if (imgFileRecord != null) {
            return imgFileRecord.getVersion();
        }
        return null;
    }

    public void setImageFile(String imageName, File file, String version) {
        this.mImageFileMap.put(imageName, new ImageFile(file, version));
    }

    public File getDeviceImageFile() {
        return this.getImageFile(DEVICE_IMAGE_NAME);
    }

    public void setDeviceImageFile(File deviceImageFile) {
        this.setImageFile(DEVICE_IMAGE_NAME, deviceImageFile, Integer.toString(this.getBuildId()));
    }

    public File getUserDataImageFile() {
        return this.getImageFile(USERDATA_IMAGE_NAME);
    }

    public void setUserDataImageFile(File userDataFile) {
        this.setImageFile(USERDATA_IMAGE_NAME, userDataFile, Integer.toString(this.getBuildId()));
    }

    public File getTestsZipFile() {
        return this.getImageFile(TESTZIP_IMAGE_NAME);
    }

    public void setTestsZipFile(File testsZipFile) {
        this.setImageFile(TESTZIP_IMAGE_NAME, testsZipFile, Integer.toString(this.getBuildId()));
    }

    public File getBasebandImageFile() {
        return this.getImageFile(BASEBAND_IMAGE_NAME);
    }

    public String getBasebandVersion() {
        return this.getImageVersion(BASEBAND_IMAGE_NAME);
    }

    public void setBasebandImage(File basebandFile, String version) {
        this.setImageFile(BASEBAND_IMAGE_NAME, basebandFile, version);
    }

    public File getBootloaderImageFile() {
        return this.getImageFile(BOOTLOADER_IMAGE_NAME);
    }

    public String getBootloaderVersion() {
        return this.getImageVersion(BOOTLOADER_IMAGE_NAME);
    }

    public void setBootloaderImageFile(File bootloaderImgFile, String version) {
        this.setImageFile(BOOTLOADER_IMAGE_NAME, bootloaderImgFile, version);
    }

    public void cleanUp() {
        for (ImageFile fileRecord : this.mImageFileMap.values()) {
            fileRecord.getImageFile().delete();
        }
        this.mImageFileMap.clear();
    }

    private static class ImageFile {
        private final File mImageFile;
        private final String mVersion;

        ImageFile(File imageFile, String version) {
            this.mImageFile = imageFile;
            this.mVersion = version;
        }

        File getImageFile() {
            return this.mImageFile;
        }

        String getVersion() {
            return this.mVersion;
        }
    }
}

