/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetsetup;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetsetup.AppBuildInfo;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.targetsetup.ITargetPreparer;
import com.android.tradefed.targetsetup.TargetSetupError;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class AppSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "AppSetup";
    @Option(name="app-package-name", description="the package name(s) of app and tests. Used for device cleanup of old packages before starting tests.")
    private Collection<String> mAppPackageNames = new ArrayList<String>();
    @Option(name="reboot", description="reboot device during setup")
    private boolean mReboot = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!(buildInfo instanceof AppBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a AppBuildInfo");
        }
        AppBuildInfo appBuild = (AppBuildInfo)buildInfo;
        try {
            if (this.mAppPackageNames.size() == 0) {
                throw new IllegalArgumentException("Missing app-package-name or test-package-name options");
            }
            Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", device.getSerialNumber()));
            for (String packageName : this.mAppPackageNames) {
                device.uninstallPackage(packageName);
            }
            if (this.mReboot) {
                device.reboot();
            }
            for (File apkFile : appBuild.getAppPackageFiles()) {
                device.installPackage(apkFile, true);
            }
        }
        finally {
            appBuild.cleanUp();
        }
    }
}

