/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogFileSaver
implements ILogFileSaver {
    private static final String LOG_TAG = "LogFileSaver";
    private File mRootDir;

    public LogFileSaver(IBuildInfo buildInfo, File rootDir) {
        File buildDir = this.createBuildDir(buildInfo, rootDir);
        try {
            this.mRootDir = FileUtil.createTempDir("inv_", buildDir);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)String.format("Unable to create unique directory in %s", buildDir.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)e);
            this.mRootDir = buildDir;
        }
        Log.i((String)LOG_TAG, (String)String.format("Using log file directory %s", this.mRootDir.getAbsolutePath()));
    }

    public File getFileDir() {
        return this.mRootDir;
    }

    private File createBuildDir(IBuildInfo buildInfo, File rootDir) {
        File buildReportDir = new File(rootDir, Integer.toString(buildInfo.getBuildId()));
        if (buildReportDir.exists()) {
            if (buildReportDir.isDirectory()) {
                return buildReportDir;
            }
            Log.w((String)LOG_TAG, (String)String.format("Cannot create build-specific output dir %s. File already exists.", buildReportDir.getAbsolutePath()));
        } else {
            if (buildReportDir.mkdirs()) {
                if (!FileUtil.setGroupReadWritable(buildReportDir)) {
                    Log.w((String)LOG_TAG, (String)String.format("Failed to make  build-specific output dir %s group writable.", buildReportDir.getAbsolutePath()));
                }
                return buildReportDir;
            }
            Log.w((String)LOG_TAG, (String)String.format("Cannot create build-specific output dir %s. Failed to create directory.", buildReportDir.getAbsolutePath()));
        }
        return rootDir;
    }

    public File saveLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        File logFile = FileUtil.createTempFile(dataName + "_", "." + dataType.getFileExt(), this.mRootDir);
        FileUtil.writeToFile(dataStream, logFile);
        Log.i((String)LOG_TAG, (String)String.format("Saved log file %s", logFile.getAbsolutePath()));
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAndZipLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        BufferedInputStream bufInput = null;
        ZipOutputStream outStream = null;
        try {
            File logFile = FileUtil.createTempFile(dataName + "_", "." + LogDataType.ZIP.getFileExt(), this.mRootDir);
            bufInput = new BufferedInputStream(dataStream);
            outStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(logFile)));
            outStream.putNextEntry(new ZipEntry(dataName + "." + dataType.getFileExt()));
            int inputByte = -1;
            while ((inputByte = bufInput.read()) != -1) {
                outStream.write(inputByte);
            }
            Log.i((String)LOG_TAG, (String)String.format("Saved log file %s", logFile.getAbsolutePath()));
            File file = logFile;
            return file;
        }
        finally {
            if (bufInput != null) {
                try {
                    bufInput.close();
                }
                catch (IOException e) {}
            }
            if (outStream != null) {
                try {
                    outStream.closeEntry();
                    outStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

