/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.log.FileLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class LogRegistry
implements Log.ILogOutput {
    private static final String LOG_TAG = "LogRegistry";
    private static LogRegistry mLogRegistry = null;
    private Map<ThreadGroup, ILeveledLogOutput> mLogTable = new Hashtable<ThreadGroup, ILeveledLogOutput>();
    private FileLogger mGlobalLogger;

    LogRegistry() {
        try {
            this.mGlobalLogger = new FileLogger();
        }
        catch (ConfigurationException e) {
            System.err.println("Failed to create global logger");
            throw new IllegalStateException(e);
        }
    }

    public static LogRegistry getLogRegistry() {
        if (mLogRegistry == null) {
            mLogRegistry = new LogRegistry();
        }
        return mLogRegistry;
    }

    public void registerLogger(ILeveledLogOutput log) {
        ILeveledLogOutput oldValue = this.mLogTable.put(LogRegistry.getCurrentThreadGroup(), log);
        if (oldValue != null) {
            Log.e((String)LOG_TAG, (String)"Registering a new logger when one already exists for this thread!");
            oldValue.closeLog();
        }
    }

    public void unregisterLogger() {
        ThreadGroup currentThreadGroup = LogRegistry.getCurrentThreadGroup();
        if (currentThreadGroup != null) {
            this.mLogTable.remove(currentThreadGroup);
        } else {
            this.printLog(Log.LogLevel.ERROR, LOG_TAG, "Unregistering when thread has no logger registered.");
        }
    }

    private static ThreadGroup getCurrentThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public void printLog(Log.LogLevel logLevel, String tag, String message) {
        ILeveledLogOutput log = this.getLogger();
        Log.LogLevel currentLogLevel = Log.LogLevel.getByString((String)log.getLogLevel());
        if (logLevel.getPriority() >= currentLogLevel.getPriority()) {
            log.printLog(logLevel, tag, message);
        }
    }

    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
        this.getLogger().printAndPromptLog(logLevel, tag, message);
    }

    ILeveledLogOutput getLogger() {
        ILeveledLogOutput log = this.mLogTable.get(LogRegistry.getCurrentThreadGroup());
        if (log == null) {
            log = this.mGlobalLogger;
        }
        return log;
    }

    public void closeAndRemoveAllLogs() {
        Collection<ILeveledLogOutput> allLogs = this.mLogTable.values();
        Iterator<ILeveledLogOutput> iter = allLogs.iterator();
        while (iter.hasNext()) {
            ILeveledLogOutput log = iter.next();
            log.closeLog();
            iter.remove();
        }
        this.saveGlobalLog();
        this.mGlobalLogger.closeLog();
    }

    public void saveGlobalLog() {
        try {
            File tradefedLog = FileUtil.createTempFile("tradefed_global_log_", ".txt");
            FileUtil.writeToFile(this.mGlobalLogger.getLog(), tradefedLog);
            System.out.println(String.format("Saved global log to %s", tradefedLog.getAbsolutePath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

