/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class FileLogger
implements ILeveledLogOutput {
    private static final String TEMP_FILE_PREFIX = "tradefed_log_";
    private static final String TEMP_FILE_SUFFIX = ".txt";
    private File mTempLogFile = null;
    private BufferedWriter mLogWriter = null;
    @Option(name="log-level", description="minimum log level to log")
    private String mLogLevel = Log.LogLevel.DEBUG.getStringValue();
    @Option(name="log-level-display", description="minimum log level to display on stdout")
    private String mLogLevelStringDisplay = Log.LogLevel.ERROR.getStringValue();

    void setLogLevelDisplay(String logLevel) {
        this.mLogLevelStringDisplay = logLevel;
    }

    public FileLogger() throws ConfigurationException {
        try {
            this.mTempLogFile = FileUtil.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.mLogWriter = new BufferedWriter(new FileWriter(this.mTempLogFile));
        }
        catch (IOException e) {
            throw new ConfigurationException(String.format("Could not create output log file : %s", e.getMessage()));
        }
    }

    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
        this.printLog(logLevel, tag, message);
        Log.printLog((Log.LogLevel)logLevel, (String)tag, (String)message);
    }

    public void printLog(Log.LogLevel logLevel, String tag, String message) {
        String outMessage = Log.getLogFormatString((Log.LogLevel)logLevel, (String)tag, (String)message);
        Log.LogLevel displayLevel = Log.LogLevel.getByString((String)this.mLogLevelStringDisplay);
        if (logLevel.getPriority() >= displayLevel.getPriority()) {
            System.out.print(outMessage);
        }
        try {
            this.writeToLog(outMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void writeToLog(String outMessage) throws IOException {
        if (this.mLogWriter != null) {
            this.mLogWriter.write(outMessage);
        }
    }

    public String getLogLevel() {
        return this.mLogLevel;
    }

    String getFilename() throws SecurityException {
        return this.mTempLogFile.getAbsolutePath();
    }

    public InputStream getLog() {
        if (this.mLogWriter == null) {
            throw new IllegalStateException();
        }
        try {
            this.mLogWriter.flush();
            return new FileInputStream(this.mTempLogFile);
        }
        catch (IOException e) {
            System.err.println("Failed to get log");
            e.printStackTrace();
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public void closeLog() {
        try {
            this.doCloseLog();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCloseLog() throws IOException {
        if (this.mLogWriter == null) {
            return;
        }
        BufferedWriter writer = this.mLogWriter;
        this.mLogWriter = null;
        try {
            writer.flush();
            writer.close();
        }
        finally {
            this.mTempLogFile.delete();
        }
    }
}

