/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WifiHelper {
    private static final String INTERFACE_KEY = "interface";
    static final String SUCCESS_MARKER = "tHiS-iS-sUcCeSs-MaRkEr";
    private static final String WPA_STATE = "wpa_state";
    private static final long DEFAULT_WIFI_STATE_TIMEOUT = 30000L;
    private final ITestDevice mDevice;

    WifiHelper(ITestDevice device) {
        this.mDevice = device;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    void enableWifi() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand("svc wifi enable");
    }

    void disableWifi() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand("svc wifi disable");
    }

    void disconnectFromNetwork(int networkId) throws DeviceNotAvailableException {
        this.callWpaCli(String.format("disable_network %d", networkId));
    }

    boolean waitForWifiState(WifiState ... expectedStates) throws DeviceNotAvailableException {
        return this.waitForWifiState(30000L, expectedStates);
    }

    boolean waitForWifiState(long timeout, WifiState ... expectedStates) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            Map<String, String> statusMap = this.getWifiStatus();
            if (statusMap != null) {
                String state = statusMap.get(WPA_STATE);
                for (WifiState expectedState : expectedStates) {
                    if (!expectedState.name().equals(state)) continue;
                    return true;
                }
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    long getPollTime() {
        return 1000L;
    }

    Map<String, String> getWifiStatus() throws DeviceNotAvailableException {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        WpaCliOutput output = this.callWpaCli("status");
        if (!output.isSuccess()) {
            return null;
        }
        for (String line : output.mOutputLines) {
            String[] pair = line.split("=", 2);
            if (pair.length != 2) continue;
            statusMap.put(pair[0], pair[1]);
        }
        if (!statusMap.containsKey(WPA_STATE)) {
            return null;
        }
        statusMap.put(INTERFACE_KEY, output.mWpaInterface);
        return statusMap;
    }

    void removeNetwork(int networkId) throws DeviceNotAvailableException {
        this.callWpaCli(String.format("remove_network %d", networkId));
    }

    Integer addOpenNetwork(String ssid) throws DeviceNotAvailableException {
        WpaCliOutput output = this.callWpaCli("add_network");
        if (!output.isSuccess()) {
            return null;
        }
        Pattern networkIdPattern = Pattern.compile("^\\d+$");
        Integer networkId = null;
        for (String line : output.mOutputLines) {
            Matcher networkMatcher = networkIdPattern.matcher(line);
            if (!networkMatcher.matches()) continue;
            networkId = Integer.parseInt(line);
            break;
        }
        if (networkId == null) {
            return null;
        }
        String setSsidCmd = String.format("set_network %d ssid '\"%s\"'", networkId, ssid);
        if (!this.callWpaCliChecked(setSsidCmd)) {
            this.removeNetwork(networkId);
            return null;
        }
        if (!this.callWpaCliChecked(String.format("set_network %d key_mgmt NONE", networkId))) {
            this.removeNetwork(networkId);
            return null;
        }
        return networkId;
    }

    Integer addWpaPskNetwork(String ssid, String psk) throws DeviceNotAvailableException {
        Integer networkId = this.addOpenNetwork(ssid);
        if (networkId == null) {
            return null;
        }
        if (!this.callWpaCliChecked(String.format("set_network %d key_mgmt WPA-PSK", networkId))) {
            this.removeNetwork(networkId);
            return null;
        }
        String setPskCmd = String.format("set_network %d psk '\"%s\"'", networkId, psk);
        if (!this.callWpaCliChecked(setPskCmd)) {
            this.removeNetwork(networkId);
            return null;
        }
        return networkId;
    }

    boolean associateNetwork(int networkId) throws DeviceNotAvailableException {
        if (!this.callWpaCliChecked("disconnect")) {
            return false;
        }
        if (!this.callWpaCliChecked(String.format("enable_network %d", networkId))) {
            return false;
        }
        if (!this.callWpaCliChecked(String.format("select_network %d", networkId))) {
            return false;
        }
        return this.callWpaCliChecked("reconnect");
    }

    boolean waitForDhcp(long timeout) throws DeviceNotAvailableException {
        Map<String, String> statusMap = this.getWifiStatus();
        if (statusMap == null) {
            return false;
        }
        String interfaceName = statusMap.get(INTERFACE_KEY);
        if (interfaceName == null) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            DhcpOutput output = new DhcpOutput(interfaceName);
            this.mDevice.executeShellCommand("netcfg", (IShellOutputReceiver)output);
            if (output.mDhcpSuccess) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    void removeAllNetworks() throws DeviceNotAvailableException {
        WpaCliOutput output = this.callWpaCli("list_networks");
        if (!output.isSuccess()) {
            return;
        }
        Pattern networkPattern = Pattern.compile("^(\\d+)\\s+\\w+");
        for (String line : output.mOutputLines) {
            Matcher matcher = networkPattern.matcher(line);
            if (!matcher.find()) continue;
            Integer networkId = Integer.parseInt(matcher.group(1));
            this.removeNetwork(networkId);
        }
    }

    private WpaCliOutput callWpaCli(String cmd) throws DeviceNotAvailableException {
        String fullCmd = String.format("wpa_cli %s && echo && echo %s", cmd, SUCCESS_MARKER);
        WpaCliOutput output = new WpaCliOutput();
        this.mDevice.executeShellCommand(fullCmd, (IShellOutputReceiver)output);
        return output;
    }

    private boolean callWpaCliChecked(String cmd) throws DeviceNotAvailableException {
        WpaCliOutput output = this.callWpaCli(cmd);
        if (!output.isSuccess()) {
            return false;
        }
        for (String line : output.mOutputLines) {
            if (!line.equals("OK")) continue;
            return true;
        }
        return false;
    }

    private static class DhcpOutput
    extends MultiLineReceiver {
        boolean mDhcpSuccess = false;
        final String mInterfaceName;

        DhcpOutput(String interfaceName) {
            this.mInterfaceName = interfaceName;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (!line.contains(this.mInterfaceName)) continue;
                String[] fields = line.split("\\s+");
                if (fields.length < 2 || !fields[1].equals("UP") || fields[2].equals("0.0.0.0")) break;
                this.mDhcpSuccess = true;
                break;
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }

    private static class WpaCliOutput
    extends MultiLineReceiver {
        private boolean mDidCommandComplete = false;
        private boolean mIsCommandSuccess = true;
        String mWpaInterface = null;
        List<String> mOutputLines = new ArrayList<String>();

        WpaCliOutput() {
        }

        public void processNewLines(String[] lines) {
            if (!this.mDidCommandComplete) {
                this.mDidCommandComplete = lines[lines.length - 1].equals(WifiHelper.SUCCESS_MARKER);
            }
            Pattern interfacePattern = Pattern.compile("Using interface '(.*)'");
            for (String line : lines) {
                Matcher interfaceMatcher;
                this.mOutputLines.add(line);
                if (line.contains("Failed to connect to wpa_supplicant")) {
                    this.mIsCommandSuccess = false;
                }
                if (!(interfaceMatcher = interfacePattern.matcher(line)).find()) continue;
                this.mWpaInterface = interfaceMatcher.group(1);
            }
        }

        public boolean isSuccess() {
            return this.mDidCommandComplete && this.mIsCommandSuccess;
        }

        public boolean isCancelled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WifiState {
        COMPLETED,
        SCANNING,
        DISCONNECTED;

    }
}

