/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.config.Option;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceSelectionOptions {
    @Option(name="serial", shortName=115, description="run this test on a specific device with given serial number(s)")
    private Collection<String> mSerials = new ArrayList<String>();
    @Option(name="exclude-serial", description="run this test on any device except those with this serial number(s)")
    private Collection<String> mExcludeSerials = new ArrayList<String>();
    @Option(name="product-type", description="run this test on device with this product type(s)")
    private Collection<String> mProductTypes = new ArrayList<String>();

    public void addSerial(String serialNumber) {
        this.mSerials.add(serialNumber);
    }

    public void addExcludeSerial(String serialNumber) {
        this.mExcludeSerials.add(serialNumber);
    }

    public void addProductType(String productType) {
        this.mProductTypes.add(productType);
    }

    public Collection<String> getSerials() {
        return this.copyCollection(this.mSerials);
    }

    public Collection<String> getExcludeSerials() {
        return this.copyCollection(this.mExcludeSerials);
    }

    public Collection<String> getProductTypes() {
        return this.copyCollection(this.mProductTypes);
    }

    private Collection<String> copyCollection(Collection<String> original) {
        ArrayList<String> listCopy = new ArrayList<String>(original.size());
        listCopy.addAll(original);
        return listCopy;
    }
}

