/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tradefed.device.AndroidDebugBridgeWrapper;
import com.android.tradefed.device.DeviceSelectionMatcher;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.DeviceStateMonitor;
import com.android.tradefed.device.IAndroidDebugBridge;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.ConditionPriorityBlockingQueue;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManager
implements IDeviceManager {
    private static final String LOG_TAG = "DeviceManager";
    private static final long FASTBOOT_CMD_TIMEOUT = 60000L;
    private static final long FASTBOOT_POLL_WAIT_TIME = 5000L;
    private static final int CHECK_WAIT_DEVICE_AVAIL_MS = 5000;
    private static final DeviceSelectionOptions ANY_DEVICE_OPTIONS = new DeviceSelectionOptions();
    private static DeviceManager sInstance;
    private Map<String, IManagedTestDevice> mAllocatedDeviceMap = new Hashtable<String, IManagedTestDevice>();
    private ConditionPriorityBlockingQueue<IDevice> mAvailableDeviceQueue = new ConditionPriorityBlockingQueue();
    private IAndroidDebugBridge mAdbBridge;
    private final ManagedDeviceListener mManagedDeviceListener;
    private final FastbootMonitor mFastbootMonitor;
    private Map<String, IDeviceStateMonitor> mCheckDeviceMap = new Hashtable<String, IDeviceStateMonitor>();
    private boolean mEnableLogcat = true;
    private Set<IDeviceManager.IFastbootListener> mFastbootListeners;

    DeviceManager() {
        DdmPreferences.setTimeOut((int)30000);
        this.mAdbBridge = this.createAdbBridge();
        this.mAdbBridge.init(false, "adb");
        for (IDevice device : this.mAdbBridge.getDevices()) {
            if (device.getState() != IDevice.DeviceState.ONLINE) continue;
            this.checkAndAddAvailableDevice(device);
        }
        this.mManagedDeviceListener = new ManagedDeviceListener();
        this.mAdbBridge.addDeviceChangeListener(this.mManagedDeviceListener);
        this.mFastbootListeners = Collections.synchronizedSet(new HashSet());
        this.mFastbootMonitor = new FastbootMonitor();
        this.startFastbootMonitor();
    }

    void startFastbootMonitor() {
        this.mFastbootMonitor.start();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    public void setEnableLogcat(boolean enableLogcat) {
        this.mEnableLogcat = enableLogcat;
    }

    private void checkAndAddAvailableDevice(final IDevice device) {
        if (this.mCheckDeviceMap.containsKey(device.getSerialNumber())) {
            Log.d((String)LOG_TAG, (String)String.format("Already checking new device %s, ignoring", device.getSerialNumber()));
            return;
        }
        final IDeviceStateMonitor monitor = this.createStateMonitor(device);
        this.mCheckDeviceMap.put(device.getSerialNumber(), monitor);
        String threadName = String.format("Check device %s", device.getSerialNumber());
        Thread checkThread = new Thread(threadName){

            public void run() {
                Log.d((String)DeviceManager.LOG_TAG, (String)String.format("checking new device %s responsiveness", device.getSerialNumber()));
                boolean isAvail = false;
                if (!monitor.waitForDeviceNotAvailable(5000L) && monitor.getDeviceState().equals((Object)TestDeviceState.ONLINE)) {
                    Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)DeviceManager.LOG_TAG, (String)String.format("Detected new device %s", device.getSerialNumber()));
                    DeviceManager.this.addAvailableDevice(device);
                    isAvail = true;
                }
                if (!isAvail) {
                    Log.e((String)DeviceManager.LOG_TAG, (String)String.format("Device %s adb connection is not stable, skip adding to available pool", device.getSerialNumber()));
                }
                DeviceManager.this.mCheckDeviceMap.remove(device.getSerialNumber());
            }
        };
        checkThread.start();
    }

    IDeviceStateMonitor createStateMonitor(IDevice device) {
        return new DeviceStateMonitor(this, device);
    }

    private void addAvailableDevice(IDevice device) {
        this.mAvailableDeviceQueue.add(device);
    }

    public static synchronized IDeviceManager getInstance() {
        if (sInstance == null) {
            sInstance = new DeviceManager();
        }
        return sInstance;
    }

    @Override
    public ITestDevice allocateDevice() {
        IDevice allocatedDevice = this.takeAvailableDevice();
        if (allocatedDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(allocatedDevice);
    }

    private IDevice takeAvailableDevice() {
        try {
            return this.mAvailableDeviceQueue.take();
        }
        catch (InterruptedException e) {
            Log.w((String)LOG_TAG, (String)"interrupted while taking device");
            return null;
        }
    }

    @Override
    public ITestDevice allocateDevice(long timeout) {
        IDevice allocatedDevice = this.pollAvailableDevice(timeout, ANY_DEVICE_OPTIONS);
        if (allocatedDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(allocatedDevice);
    }

    @Override
    public ITestDevice allocateDevice(long timeout, DeviceSelectionOptions options) {
        IDevice allocatedDevice = this.pollAvailableDevice(timeout, options);
        if (allocatedDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(allocatedDevice);
    }

    private IDevice pollAvailableDevice(long timeout, DeviceSelectionOptions options) {
        try {
            return this.mAvailableDeviceQueue.poll(timeout, TimeUnit.MILLISECONDS, new DeviceMatcher(options));
        }
        catch (InterruptedException e) {
            Log.w((String)LOG_TAG, (String)"interrupted while polling for device");
            return null;
        }
    }

    private ITestDevice createAllocatedDevice(IDevice allocatedDevice) {
        IManagedTestDevice testDevice = this.createTestDevice(allocatedDevice, this.createStateMonitor(allocatedDevice));
        if (this.mEnableLogcat) {
            testDevice.startLogcat();
        }
        this.mAllocatedDeviceMap.put(allocatedDevice.getSerialNumber(), testDevice);
        Log.i((String)LOG_TAG, (String)String.format("Allocated device %s", testDevice.getSerialNumber()));
        return testDevice;
    }

    IManagedTestDevice createTestDevice(IDevice allocatedDevice, IDeviceStateMonitor monitor) {
        return new TestDevice(allocatedDevice, monitor);
    }

    synchronized IAndroidDebugBridge createAdbBridge() {
        return new AndroidDebugBridgeWrapper();
    }

    @Override
    public void freeDevice(ITestDevice device, IDeviceManager.FreeDeviceState deviceState) {
        if (device instanceof IManagedTestDevice) {
            IManagedTestDevice managedDevice = (IManagedTestDevice)device;
            managedDevice.stopLogcat();
        }
        if (this.mAllocatedDeviceMap.remove(device.getSerialNumber()) == null) {
            Log.e((String)LOG_TAG, (String)String.format("freeDevice called with unallocated device %s", device.getSerialNumber()));
        } else if (deviceState == IDeviceManager.FreeDeviceState.UNRESPONSIVE) {
            this.addAvailableDevice(device.getIDevice());
        } else if (deviceState == IDeviceManager.FreeDeviceState.AVAILABLE) {
            this.addAvailableDevice(device.getIDevice());
        } else if (deviceState == IDeviceManager.FreeDeviceState.UNAVAILABLE) {
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)LOG_TAG, (String)String.format("Freed device %s is unavailable. Removing from use.", device.getSerialNumber()));
        }
    }

    @Override
    public void terminate() {
        this.mAdbBridge.removeDeviceChangeListener(this.mManagedDeviceListener);
        this.mAdbBridge.terminate();
        this.mFastbootMonitor.terminate();
    }

    @Override
    public Collection<String> getAllocatedDevices() {
        ArrayList<String> allocatedDeviceSerials = new ArrayList<String>(this.mAllocatedDeviceMap.size());
        allocatedDeviceSerials.addAll(this.mAllocatedDeviceMap.keySet());
        return allocatedDeviceSerials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAvailableDevices() {
        ArrayList<String> availableDeviceSerials = new ArrayList<String>(this.mAvailableDeviceQueue.size());
        ConditionPriorityBlockingQueue<IDevice> conditionPriorityBlockingQueue = this.mAvailableDeviceQueue;
        synchronized (conditionPriorityBlockingQueue) {
            for (IDevice device : this.mAvailableDeviceQueue) {
                availableDeviceSerials.add(device.getSerialNumber());
            }
        }
        return availableDeviceSerials;
    }

    @Override
    public Collection<String> getUnavailableDevices() {
        IDevice[] visibleDevices = this.mAdbBridge.getDevices();
        ArrayList<String> unavailableSerials = new ArrayList<String>(visibleDevices.length);
        Collection<String> availSerials = this.getAvailableDevices();
        Collection<String> allocatedSerials = this.getAllocatedDevices();
        for (IDevice device : visibleDevices) {
            if (availSerials.contains(device.getSerialNumber()) || allocatedSerials.contains(device.getSerialNumber())) continue;
            unavailableSerials.add(device.getSerialNumber());
        }
        return unavailableSerials;
    }

    @Override
    public void addFastbootListener(IDeviceManager.IFastbootListener listener) {
        this.mFastbootListeners.add(listener);
    }

    @Override
    public void removeFastbootListener(IDeviceManager.IFastbootListener listener) {
        this.mFastbootListeners.remove(listener);
    }

    static Set<String> getDevicesOnFastboot(String fastbootOutput) {
        HashSet<String> serials = new HashSet<String>();
        Pattern fastbootPattern = Pattern.compile("([\\w\\d]+)\\s+fastboot\\s*");
        Matcher fastbootMatcher = fastbootPattern.matcher(fastbootOutput);
        while (fastbootMatcher.find()) {
            serials.add(fastbootMatcher.group(1));
        }
        return serials;
    }

    private class FastbootMonitor
    extends Thread {
        private boolean mQuit;

        FastbootMonitor() {
            super("FastbootMonitor");
            this.mQuit = false;
        }

        public void terminate() {
            this.mQuit = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.mQuit) {
                if (!DeviceManager.this.mFastbootListeners.isEmpty()) {
                    CommandResult fastbootResult = DeviceManager.this.getRunUtil().runTimedCmd(60000L, "fastboot", "devices");
                    if (fastbootResult.getStatus() == CommandStatus.SUCCESS) {
                        Log.v((String)DeviceManager.LOG_TAG, (String)String.format("fastboot devices returned %s", fastbootResult.getStdout()));
                        Set<String> serials = DeviceManager.getDevicesOnFastboot(fastbootResult.getStdout());
                        for (String serial : serials) {
                            IManagedTestDevice testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(serial);
                            if (testDevice == null || testDevice.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) continue;
                            testDevice.setDeviceState(TestDeviceState.FASTBOOT);
                        }
                        Map i$ = DeviceManager.this.mAllocatedDeviceMap;
                        synchronized (i$) {
                            for (IManagedTestDevice testDevice : DeviceManager.this.mAllocatedDeviceMap.values()) {
                                if (serials.contains(testDevice.getSerialNumber()) || !testDevice.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) continue;
                                testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
                            }
                        }
                    }
                    ArrayList listenersCopy = new ArrayList(DeviceManager.this.mFastbootListeners.size());
                    listenersCopy.addAll(DeviceManager.this.mFastbootListeners);
                    for (IDeviceManager.IFastbootListener listener : listenersCopy) {
                        listener.stateUpdated();
                    }
                }
                DeviceManager.this.getRunUtil().sleep(5000L);
            }
        }
    }

    private class ManagedDeviceListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private ManagedDeviceListener() {
        }

        public void deviceChanged(IDevice device, int changeMask) {
            IManagedTestDevice testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(device.getSerialNumber());
            if ((changeMask & 1) != 0) {
                if (testDevice != null) {
                    TestDeviceState newState = TestDeviceState.getStateByDdms(device.getState());
                    testDevice.setDeviceState(newState);
                } else if (DeviceManager.this.mCheckDeviceMap.containsKey(device.getSerialNumber())) {
                    IDeviceStateMonitor monitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(device.getSerialNumber());
                    monitor.setState(TestDeviceState.getStateByDdms(device.getState()));
                } else if (!DeviceManager.this.mAvailableDeviceQueue.contains(device) && device.getState() == IDevice.DeviceState.ONLINE) {
                    DeviceManager.this.checkAndAddAvailableDevice(device);
                }
            }
        }

        public void deviceConnected(IDevice device) {
            Log.d((String)DeviceManager.LOG_TAG, (String)String.format("Detected device connect %s, id %d", device.getSerialNumber(), device.hashCode()));
            IManagedTestDevice testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(device.getSerialNumber());
            if (testDevice == null) {
                if (this.isValidDeviceSerial(device.getSerialNumber()) && device.getState() == IDevice.DeviceState.ONLINE) {
                    DeviceManager.this.checkAndAddAvailableDevice(device);
                } else if (DeviceManager.this.mCheckDeviceMap.containsKey(device.getSerialNumber())) {
                    IDeviceStateMonitor monitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(device.getSerialNumber());
                    monitor.setState(TestDeviceState.getStateByDdms(device.getState()));
                }
            } else {
                Log.d((String)DeviceManager.LOG_TAG, (String)String.format("Updating IDevice for device %s", device.getSerialNumber()));
                testDevice.setIDevice(device);
                TestDeviceState newState = TestDeviceState.getStateByDdms(device.getState());
                testDevice.setDeviceState(newState);
            }
        }

        private boolean isValidDeviceSerial(String serial) {
            return serial.length() > 1 && !serial.contains("?");
        }

        public void deviceDisconnected(IDevice disconnectedDevice) {
            IManagedTestDevice testDevice;
            if (DeviceManager.this.mAvailableDeviceQueue.remove(disconnectedDevice)) {
                Log.i((String)DeviceManager.LOG_TAG, (String)String.format("Removed disconnected device %s from available queue", disconnectedDevice.getSerialNumber()));
            }
            if ((testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(disconnectedDevice.getSerialNumber())) != null) {
                testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
            } else if (DeviceManager.this.mCheckDeviceMap.containsKey(disconnectedDevice.getSerialNumber())) {
                IDeviceStateMonitor monitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(disconnectedDevice.getSerialNumber());
                monitor.setState(TestDeviceState.NOT_AVAILABLE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeviceMatcher
    implements ConditionPriorityBlockingQueue.IMatcher<IDevice> {
        private DeviceSelectionOptions mOptions;

        DeviceMatcher(DeviceSelectionOptions options) {
            this.mOptions = options;
        }

        @Override
        public boolean matches(IDevice device) {
            return DeviceSelectionMatcher.matches(device, this.mOptions);
        }
    }
}

