/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionSetter {
    static final String BOOL_FALSE_PREFIX = "no-";
    private static final HashMap<Class<?>, Handler> handlers = new HashMap();
    private final Collection<Object> mOptionSources;
    private final Map<String, OptionField> mOptionMap;

    private Handler getHandler(Type type) throws ConfigurationException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawClass = (Class)parameterizedType.getRawType();
            if (!Collection.class.isAssignableFrom(rawClass)) {
                throw new ConfigurationException("cannot handle non-collection parameterized type " + type);
            }
            Type actualType = parameterizedType.getActualTypeArguments()[0];
            if (!(actualType instanceof Class)) {
                throw new ConfigurationException("cannot handle nested parameterized type " + type);
            }
            return this.getHandler(actualType);
        }
        if (type instanceof Class) {
            if (Collection.class.isAssignableFrom((Class)type)) {
                throw new ConfigurationException(String.format("Cannot handle non-parameterized collection %s. %s", type, "use a generic Collection to specify a desired element type"));
            }
            return handlers.get((Class)type);
        }
        throw new ConfigurationException(String.format("cannot handle unknown field type %s", type));
    }

    public OptionSetter(Object ... optionSources) throws ConfigurationException {
        this(Arrays.asList(optionSources));
    }

    public OptionSetter(Collection<Object> optionSources) throws ConfigurationException {
        this.mOptionSources = optionSources;
        this.mOptionMap = this.makeOptionMap();
    }

    private OptionField fieldForArg(String name) throws ConfigurationException {
        OptionField field = this.mOptionMap.get(name);
        if (field == null) {
            throw new ConfigurationException(String.format("Could not find option with name %s", name));
        }
        return field;
    }

    public String getTypeForOption(String name) throws ConfigurationException {
        return this.fieldForArg((String)name).mField.getType().getSimpleName().toLowerCase();
    }

    public void setOptionValue(String optionName, String valueText) throws ConfigurationException {
        OptionField optionField = this.fieldForArg(optionName);
        Field field = optionField.mField;
        Handler handler = this.getHandler(field.getGenericType());
        Object value = handler.translate(valueText);
        if (value == null) {
            String type = field.getType().getSimpleName().toLowerCase();
            throw new ConfigurationException(String.format("Couldn't convert '%s' to a %s for option '%s'", valueText, type, optionName));
        }
        try {
            field.setAccessible(true);
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection collection = (Collection)field.get(optionField.mOptionSource);
                if (collection == null) {
                    throw new ConfigurationException(String.format("internal error: no storage allocated for field '%s' (used for option '%s') in class '%s'", field.getName(), optionName, optionField.mOptionSource.getClass().getName()));
                }
                collection.add(value);
            } else {
                field.set(optionField.mOptionSource, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("internal error when setting option '%s'", optionName), e);
        }
    }

    private Map<String, OptionField> makeOptionMap() throws ConfigurationException {
        HashMap<String, OptionField> optionMap = new HashMap<String, OptionField>();
        for (Object objectSource : this.mOptionSources) {
            this.addOptionsForObject(objectSource, optionMap);
        }
        return optionMap;
    }

    private void addOptionsForObject(Object optionSource, Map<String, OptionField> optionMap) throws ConfigurationException {
        Collection<Field> optionFields = OptionSetter.getOptionFieldsForClass(optionSource.getClass());
        for (Field field : optionFields) {
            Option option = field.getAnnotation(Option.class);
            this.addNameToMap(optionMap, optionSource, option.name(), field);
            if (option.shortName() != '0') {
                this.addNameToMap(optionMap, optionSource, String.valueOf(option.shortName()), field);
            }
            if (!this.isBooleanField(field)) continue;
            this.addNameToMap(optionMap, optionSource, BOOL_FALSE_PREFIX + option.name(), field);
        }
    }

    protected static Collection<Field> getOptionFieldsForClass(Class<?> optionClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        OptionSetter.buildOptionFieldsForClass(optionClass, fieldList);
        return fieldList;
    }

    private static void buildOptionFieldsForClass(Class<?> optionClass, Collection<Field> optionFields) {
        for (Field field : optionClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            optionFields.add(field);
        }
        Class<?> superClass = optionClass.getSuperclass();
        if (superClass != null) {
            OptionSetter.buildOptionFieldsForClass(superClass, optionFields);
        }
    }

    public boolean isBooleanOption(String name) throws ConfigurationException {
        Field field = this.fieldForArg((String)name).mField;
        return this.isBooleanField(field);
    }

    private boolean isBooleanField(Field field) throws ConfigurationException {
        return this.getHandler(field.getGenericType()).isBoolean();
    }

    private void addNameToMap(Map<String, OptionField> optionMap, Object optionSource, String name, Field field) throws ConfigurationException {
        OptionField optionField = new OptionField(optionSource, field);
        if (optionMap.put(name, optionField) != null) {
            throw new ConfigurationException("found multiple @Options sharing the name '" + name + "'");
        }
        if (this.getHandler(field.getGenericType()) == null) {
            throw new ConfigurationException("unsupported @Option field type '" + field.getType() + "'");
        }
    }

    static {
        handlers.put(Boolean.TYPE, new BooleanHandler());
        handlers.put(Boolean.class, new BooleanHandler());
        handlers.put(Byte.TYPE, new ByteHandler());
        handlers.put(Byte.class, new ByteHandler());
        handlers.put(Short.TYPE, new ShortHandler());
        handlers.put(Short.class, new ShortHandler());
        handlers.put(Integer.TYPE, new IntegerHandler());
        handlers.put(Integer.class, new IntegerHandler());
        handlers.put(Long.TYPE, new LongHandler());
        handlers.put(Long.class, new LongHandler());
        handlers.put(Float.TYPE, new FloatHandler());
        handlers.put(Float.class, new FloatHandler());
        handlers.put(Double.TYPE, new DoubleHandler());
        handlers.put(Double.class, new DoubleHandler());
        handlers.put(String.class, new StringHandler());
        handlers.put(File.class, new FileHandler());
    }

    private static class FileHandler
    extends Handler {
        private FileHandler() {
        }

        Object translate(String valueText) {
            return new File(valueText);
        }
    }

    private static class StringHandler
    extends Handler {
        private StringHandler() {
        }

        Object translate(String valueText) {
            return valueText;
        }
    }

    private static class DoubleHandler
    extends Handler {
        private DoubleHandler() {
        }

        Object translate(String valueText) {
            try {
                return Double.parseDouble(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class FloatHandler
    extends Handler {
        private FloatHandler() {
        }

        Object translate(String valueText) {
            try {
                return Float.valueOf(Float.parseFloat(valueText));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class LongHandler
    extends Handler {
        private LongHandler() {
        }

        Object translate(String valueText) {
            try {
                return Long.parseLong(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class IntegerHandler
    extends Handler {
        private IntegerHandler() {
        }

        Object translate(String valueText) {
            try {
                return Integer.parseInt(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class ShortHandler
    extends Handler {
        private ShortHandler() {
        }

        Object translate(String valueText) {
            try {
                return Short.parseShort(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class ByteHandler
    extends Handler {
        private ByteHandler() {
        }

        Object translate(String valueText) {
            try {
                return Byte.parseByte(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class BooleanHandler
    extends Handler {
        private BooleanHandler() {
        }

        boolean isBoolean() {
            return true;
        }

        Object translate(String valueText) {
            if (valueText.equalsIgnoreCase("true") || valueText.equalsIgnoreCase("yes")) {
                return Boolean.TRUE;
            }
            if (valueText.equalsIgnoreCase("false") || valueText.equalsIgnoreCase("no")) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        boolean isBoolean() {
            return false;
        }

        abstract Object translate(String var1);
    }

    private static class OptionField {
        final Object mOptionSource;
        final Field mField;

        OptionField(Object optionSource, Field field) {
            this.mOptionSource = optionSource;
            this.mField = field;
        }
    }
}

