/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigurationXmlParser {
    private static final String LOG_TAG = "ConfigurationDef";

    ConfigurationXmlParser() {
    }

    ConfigurationDef parse(String name, InputStream xmlInput) throws ConfigurationException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            ConfigHandler configHandler = new ConfigHandler(name);
            parser.parse(new InputSource(xmlInput), (DefaultHandler)configHandler);
            return configHandler.getParsedDef();
        }
        catch (ParserConfigurationException e) {
            this.throwConfigException(name, e);
        }
        catch (SAXException e) {
            this.throwConfigException(name, e);
        }
        catch (IOException e) {
            this.throwConfigException(name, e);
        }
        throw new ConfigurationException("should never reach here");
    }

    private void throwConfigException(String configName, Throwable e) throws ConfigurationException {
        if (e.getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)e.getCause();
        }
        throw new ConfigurationException(String.format("Failed to parse config xml '%s'", configName), e);
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private static final String OBJECT_TAG = "object";
        private static final String OPTION_TAG = "option";
        private static final Object CONFIG_TAG = "configuration";
        private ConfigurationDef mConfigDef;

        ConfigHandler(String name) {
            this.mConfigDef = new ConfigurationDef(name);
        }

        ConfigurationDef getParsedDef() {
            return this.mConfigDef;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (OBJECT_TAG.equals(localName)) {
                String objectName = attributes.getValue("name");
                this.addObject(objectName, attributes);
            } else if (OPTION_TAG.equals(localName)) {
                String optionValue;
                String optionName = attributes.getValue("name");
                if (optionName == null) {
                    this.throwException("Missing 'name' attribute for option");
                }
                if ((optionValue = attributes.getValue("value")) == null) {
                    this.throwException("Missing 'value' attribute for option");
                }
                this.mConfigDef.addOptionDef(optionName, optionValue);
            } else if (Configuration.getConfigObjNames().contains(localName)) {
                this.addObject(localName, attributes);
            } else if (CONFIG_TAG.equals(localName)) {
                String description = attributes.getValue("description");
                if (description != null) {
                    this.mConfigDef.setDescription(description);
                }
            } else {
                Log.w((String)ConfigurationXmlParser.LOG_TAG, (String)String.format("Unrecognized tag '%s' in configuration", localName));
            }
        }

        void addObject(String objectName, Attributes attributes) throws SAXException {
            String className = attributes.getValue("class");
            if (className == null) {
                this.throwException(String.format("Missing class attribute for object %s", objectName));
            }
            this.mConfigDef.addConfigObjectDef(objectName, className);
        }

        private void throwException(String reason) throws SAXException {
            throw new SAXException(new ConfigurationException(String.format("Failed to parse config xml '%s'. Reason: %s", this.mConfigDef.getName(), reason)));
        }
    }
}

