/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.targetsetup.IBuildProvider;
import com.android.tradefed.targetsetup.ITargetPreparer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    public static final String BUILD_PROVIDER_NAME = "build_provider";
    public static final String TARGET_PREPARER_NAME = "target_preparer";
    public static final String TEST_NAME = "test";
    public static final String DEVICE_RECOVERY_NAME = "device_recovery";
    public static final String LOGGER_NAME = "logger";
    public static final String RESULT_REPORTER_NAME = "result_reporter";
    private static Set<String> sObjNames = null;
    private Map<String, List<Object>> mConfigMap;

    static Set<String> getConfigObjNames() {
        if (sObjNames == null) {
            sObjNames = new HashSet<String>();
            sObjNames.add(BUILD_PROVIDER_NAME);
            sObjNames.add(TARGET_PREPARER_NAME);
            sObjNames.add(TEST_NAME);
            sObjNames.add(DEVICE_RECOVERY_NAME);
            sObjNames.add(LOGGER_NAME);
            sObjNames.add(RESULT_REPORTER_NAME);
        }
        return sObjNames;
    }

    Configuration() {
        this(new HashMap<String, List<Object>>());
    }

    Configuration(Map<String, List<Object>> configObjectMap) {
        this.mConfigMap = configObjectMap;
        for (List<Object> configObjectList : configObjectMap.values()) {
            for (Object configObject : configObjectList) {
                if (!(configObject instanceof IConfigurationReceiver)) continue;
                ((IConfigurationReceiver)configObject).setConfiguration(this);
            }
        }
    }

    void addObject(String name, Object configObject) {
        List<Object> objList = this.mConfigMap.get(name);
        if (objList == null) {
            objList = new ArrayList<Object>(1);
            this.mConfigMap.put(name, objList);
        }
        objList.add(configObject);
        if (configObject instanceof IConfigurationReceiver) {
            ((IConfigurationReceiver)configObject).setConfiguration(this);
        }
    }

    @Override
    public IBuildProvider getBuildProvider() throws ConfigurationException {
        return (IBuildProvider)this.getConfigurationObject(BUILD_PROVIDER_NAME, IBuildProvider.class);
    }

    @Override
    public List<ITargetPreparer> getTargetPreparers() throws ConfigurationException {
        return this.getConfigurationObjectList(TARGET_PREPARER_NAME, ITargetPreparer.class);
    }

    @Override
    public List<Test> getTests() throws ConfigurationException {
        return this.getConfigurationObjectList(TEST_NAME, Test.class);
    }

    @Override
    public IDeviceRecovery getDeviceRecovery() throws ConfigurationException {
        return (IDeviceRecovery)this.getConfigurationObject(DEVICE_RECOVERY_NAME, IDeviceRecovery.class);
    }

    @Override
    public ILeveledLogOutput getLogOutput() throws ConfigurationException {
        return (ILeveledLogOutput)this.getConfigurationObject(LOGGER_NAME, ILeveledLogOutput.class);
    }

    @Override
    public List<ITestInvocationListener> getTestInvocationListeners() throws ConfigurationException {
        return this.getConfigurationObjectList(RESULT_REPORTER_NAME, ITestInvocationListener.class);
    }

    @Override
    public List<?> getConfigurationObjectList(String name, Class<?> expectedType) throws ConfigurationException {
        List<Object> configObjects = this.mConfigMap.get(name);
        if (configObjects == null) {
            throw new ConfigurationException(String.format("Could not find config object with name %s", name));
        }
        for (Object object : configObjects) {
            if (expectedType.isInstance(object)) continue;
            throw new ConfigurationException(String.format("The config object %s is not the correct type. Expected %s, received %s", name, expectedType.getCanonicalName(), object.getClass().getCanonicalName()));
        }
        return configObjects;
    }

    @Override
    public Object getConfigurationObject(String name, Class<?> expectedType) throws ConfigurationException {
        List<?> configObjects = this.getConfigurationObjectList(name, expectedType);
        if (configObjects.size() != 1) {
            throw new ConfigurationException(String.format("Only one config object allowed for %s, but %d were specified.", name, configObjects.size()));
        }
        return configObjects.get(0);
    }

    @Override
    public Collection<Object> getAllConfigurationObjects() {
        ArrayList<Object> objectsCopy = new ArrayList<Object>();
        for (List<Object> objectList : this.mConfigMap.values()) {
            objectsCopy.addAll(objectList);
        }
        return objectsCopy;
    }

    @Override
    public void injectOptionValue(String optionName, String valueText) throws ConfigurationException {
        OptionSetter optionSetter = new OptionSetter(this.getAllConfigurationObjects());
        optionSetter.setOptionValue(optionName, valueText);
    }
}

