/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsOptionParser
extends OptionSetter {
    static final String SHORT_NAME_PREFIX = "-";
    static final String OPTION_NAME_PREFIX = "--";

    public ArgsOptionParser(Collection<Object> optionSources) throws ConfigurationException {
        super(optionSources);
    }

    public ArgsOptionParser(Object ... optionSources) throws ConfigurationException {
        super(optionSources);
    }

    public List<String> parse(String[] args) throws ConfigurationException {
        return this.parseOptions(Arrays.asList(args).listIterator());
    }

    private List<String> parseOptions(ListIterator<String> args) throws ConfigurationException {
        String arg;
        ArrayList<String> leftovers = new ArrayList<String>();
        while (args.hasNext() && !(arg = args.next()).equals(OPTION_NAME_PREFIX)) {
            if (arg.startsWith(OPTION_NAME_PREFIX)) {
                this.parseLongOption(arg, args);
                continue;
            }
            if (arg.startsWith(SHORT_NAME_PREFIX)) {
                this.parseGroupedShortOptions(arg, args);
                continue;
            }
            leftovers.add(arg);
            break;
        }
        while (args.hasNext()) {
            leftovers.add(args.next());
        }
        return leftovers;
    }

    private void parseLongOption(String arg, ListIterator<String> args) throws ConfigurationException {
        String name = arg.replaceFirst("^--", "");
        String value = null;
        int equalsIndex = name.indexOf(61);
        if (equalsIndex != -1) {
            value = name.substring(equalsIndex + 1);
            name = name.substring(0, equalsIndex);
        }
        if (value == null) {
            value = this.isBooleanOption(name) ? (name.startsWith("no-") ? "false" : "true") : this.grabNextValue(args, name);
        }
        this.setOptionValue(name, value);
    }

    private void parseGroupedShortOptions(String arg, ListIterator<String> args) throws ConfigurationException {
        for (int i = 1; i < arg.length(); ++i) {
            String value;
            String name = String.valueOf(arg.charAt(i));
            if (this.isBooleanOption(name)) {
                value = "true";
            } else if (i + 1 < arg.length()) {
                value = arg.substring(i + 1);
                i = arg.length() - 1;
            } else {
                value = this.grabNextValue(args, name);
            }
            this.setOptionValue(name, value);
        }
    }

    private String grabNextValue(ListIterator<String> args, String name) throws ConfigurationException {
        if (!args.hasNext()) {
            String type = this.getTypeForOption(name);
            throw new ConfigurationException(String.format("option '%s' requires a '%s' argument", name, type));
        }
        return args.next();
    }

    public static String getOptionHelp(Class<?> optionClass) {
        StringBuilder out = new StringBuilder();
        Collection<Field> optionFields = OptionSetter.getOptionFieldsForClass(optionClass);
        String eol = System.getProperty("line.separator");
        for (Field field : optionFields) {
            Option option = field.getAnnotation(Option.class);
            out.append(String.format("    %s%s: %s", OPTION_NAME_PREFIX, option.name(), option.description()));
            out.append(eol);
        }
        return out.toString();
    }
}

